/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class ClearFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CLEAR = "clear";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        if (params != null && params.length == 1) {
            if (params[0].getStringValue().equals("objects")) {
                engine.clearObjects();
            } else if (params[0].getStringValue().equals("deffacts")) {
                engine.clearFacts();
            }
        } else {
            engine.clearAll();
        }
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(true));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return CLEAR;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        if (indents > 0) {
            StringBuffer buf = new StringBuffer();
            int idx = 0;
            while (idx < indents) {
                buf.append(" ");
                ++idx;
            }
            buf.append("(clear)");
            return buf.toString();
        }
        return "(clear [objects | deffacts])\nFunction description:\n\tRemoves all the facts from memory and resets the fact index\n\tif no argument is provided.\n\tThe argument \"objects\" removes all the facts and\n\tthe argument \"deffacts\" clears all the defined facts.\n";
    }
}

