/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class BindFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BIND = "bind";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean bound = false;
        if (params.length == 2) {
            String name = params[0].getStringValue();
            Object val = null;
            if (params[1] instanceof ValueParam) {
                val = params[1].getValue();
            } else if (params[1] instanceof FunctionParam2) {
                FunctionParam2 fp2 = (FunctionParam2)params[1];
                fp2.setEngine(engine);
                fp2.lookUpFunction();
                DefaultReturnVector drv = (DefaultReturnVector)fp2.getValue();
                val = drv.firstReturnValue().getValue();
            }
            engine.setBindingValue(name, val);
            bound = true;
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(bound));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return BIND;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class, ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(bind ?" + params[0].getStringValue());
            int idx = 1;
            while (idx < params.length) {
                if (params[idx] instanceof ValueParam) {
                    buf.append(" " + params[idx].getStringValue());
                } else if (params[idx] instanceof FunctionParam2) {
                    FunctionParam2 fp2 = (FunctionParam2)params[idx];
                    buf.append(" " + fp2.toPPString());
                }
                ++idx;
            }
            buf.append(" )");
            return buf.toString();
        }
        return "(bind ?<variable-name> <expression>)\nFunction description:\n\tBinds the value of the argument <expression> to the \n\tvariable <variable-name>.";
    }
}

