/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class AnyEqFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ANYEQUAL = "any-eq";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        boolean eq = false;
        if (params != null && params.length > 1) {
            Object constant = params[0].getValue(engine, 9);
            int idx = 1;
            while (idx < params.length) {
                if (constant.equals(params[idx].getValue(engine, 9))) {
                    eq = true;
                    break;
                }
                ++idx;
            }
        }
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(eq));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return ANYEQUAL;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class, BoundParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(any-eq (<literal> | <binding>)+)\nFunction description:\n\tCompares a literal value against one or morebindings. \n\tIf any of the bindings is equal to the constant value,\n\tthe function returns true.";
    }
}

