/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class AndFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String AND = "and";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        boolean eq = true;
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                if (!eq) break;
                if (params[idx] instanceof FunctionParam2) {
                    FunctionParam2 n = (FunctionParam2)params[idx];
                    n.setEngine(engine);
                    n.lookUpFunction();
                    ReturnVector rval = (ReturnVector)n.getValue();
                    eq = rval.firstReturnValue().getBooleanValue();
                }
                ++idx;
            }
        }
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(eq));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return AND;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public int getReturnType() {
        return 20;
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null) {
            StringBuffer buf = new StringBuffer();
            int idx = 0;
            while (idx < params.length) {
                if (idx > 0) {
                    buf.append(" && ");
                }
                if (params[idx] instanceof FunctionParam2) {
                    FunctionParam2 fp = (FunctionParam2)params[idx];
                    buf.append(fp.toPPString());
                }
                ++idx;
            }
            return buf.toString();
        }
        return "(and <expression>)";
    }
}

