/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.compiler;

import java.math.BigDecimal;
import org.jamocha.rete.AbstractTemporalNode;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Function;
import org.jamocha.rete.LIANode;
import org.jamocha.rete.NotJoin;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Template;
import org.jamocha.rete.TemporalEqNode;
import org.jamocha.rete.TemporalIntervalNode;
import org.jamocha.rete.compiler.ObjectConditionCompiler;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rule.AndLiteralConstraint;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.LiteralConstraint;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.OrLiteralConstraint;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Rule;
import org.jamocha.rule.TemporalCondition;

public class TemporalConditionCompiler
extends ObjectConditionCompiler {
    public TemporalConditionCompiler(RuleCompiler ruleCompiler) {
        super(ruleCompiler);
    }

    public TemporalConditionCompiler(QueryCompiler queryCompiler) {
        super(queryCompiler);
    }

    public void compile(Condition condition, int position, Rule rule, boolean alphaMemory) {
        TemporalCondition cond = (TemporalCondition)condition;
        ObjectTypeNode otn = this.ruleCompiler.findObjectTypeNode(cond.getTemplateName());
        boolean switchMatch = false;
        if (rule.getRememberMatch()) {
            rule.setRememberMatch(false);
            switchMatch = true;
        }
        if (otn != null) {
            BaseAlpha2 first = null;
            BaseAlpha2 previous = null;
            BaseAlpha current = null;
            Template templ = cond.getTemplate();
            Constraint[] constrs = cond.getConstraints();
            int idx = 0;
            while (idx < constrs.length) {
                Constraint cnstr = constrs[idx];
                if (cnstr instanceof LiteralConstraint) {
                    current = this.ruleCompiler.compileConstraint((LiteralConstraint)cnstr, templ, rule);
                } else if (cnstr instanceof AndLiteralConstraint) {
                    current = this.ruleCompiler.compileConstraint((AndLiteralConstraint)cnstr, templ, rule);
                } else if (cnstr instanceof OrLiteralConstraint) {
                    current = this.ruleCompiler.compileConstraint((OrLiteralConstraint)cnstr, templ, rule);
                } else if (cnstr instanceof BoundConstraint) {
                    this.ruleCompiler.compileConstraint((BoundConstraint)cnstr, templ, rule, position);
                } else if (cnstr instanceof PredicateConstraint) {
                    current = this.ruleCompiler.compileConstraint((PredicateConstraint)cnstr, templ, rule, position);
                }
                if (first == null) {
                    first = current;
                    previous = current;
                } else if (current != previous) {
                    try {
                        previous.addSuccessorNode(current, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
                        previous = current;
                    }
                    catch (AssertException assertException) {
                        // empty catch block
                    }
                }
                ++idx;
            }
            if (first != null) {
                this.attachAlphaNode(otn, first, cond);
            }
        }
        if (!cond.getNegated()) {
            ++position;
        }
        if (switchMatch) {
            rule.setRememberMatch(true);
        }
    }

    public void compileFirstJoin(Condition condition, Rule rule) throws AssertException {
        ObjectCondition cond = (ObjectCondition)condition;
        ObjectTypeNode otn = this.ruleCompiler.findObjectTypeNode(cond.getTemplateName());
        LIANode node = new LIANode(this.ruleCompiler.getEngine().nextNodeId());
        if (cond.getNodes().size() == 0) {
            LIANode existingLIANode = this.ruleCompiler.findLIANode(otn);
            if (existingLIANode == null) {
                otn.addSuccessorNode(node, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
                cond.addNode(node);
            } else {
                existingLIANode.incrementUseCount();
                cond.addNode(existingLIANode);
            }
        } else {
            BaseAlpha old = (BaseAlpha)cond.getLastNode();
            BaseNode[] successors = (BaseNode[])old.getSuccessorNodes();
            int i = 0;
            while (i < successors.length) {
                if (successors[i] instanceof LIANode) {
                    cond.addNode(successors[i]);
                    return;
                }
                ++i;
            }
            if (!(old instanceof LIANode)) {
                old.addSuccessorNode(node, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
                cond.addNode(node);
            }
        }
    }

    public BaseJoin compileJoin(Condition condition, int position, Rule rule, Condition previousCond) {
        Binding[] binds = this.getBindings(condition, rule, position);
        TemporalCondition tc = (TemporalCondition)condition;
        BaseJoin joinNode = null;
        if (!tc.getNegated()) {
            if (binds.length > 0 && tc.getIntervalTime() > 0) {
                joinNode = new TemporalIntervalNode(this.ruleCompiler.getEngine().nextNodeId(), this.ruleCompiler.getEngine());
                ((TemporalIntervalNode)joinNode).setInterval(tc.getIntervalTime() * 1000);
                Function f = this.ruleCompiler.getEngine().findFunction(tc.getFunction());
                if (f != null) {
                    ((TemporalIntervalNode)joinNode).setFunction(f);
                    BigDecimal count = tc.getParameters()[0].getBigDecimalValue();
                    ((TemporalIntervalNode)joinNode).setCount(count);
                }
            } else if (binds.length > 0) {
                joinNode = new TemporalEqNode(this.ruleCompiler.getEngine().nextNodeId());
            }
        }
        joinNode.setBindings(binds);
        ((AbstractTemporalNode)joinNode).setRightElapsedTime(tc.getRelativeTime() * 1000);
        if (previousCond != null && previousCond instanceof TemporalCondition) {
            ((AbstractTemporalNode)joinNode).setLeftElapsedTime(((TemporalCondition)previousCond).getRelativeTime() * 1000);
        }
        return joinNode;
    }

    public void compileSingleCE(Rule rule) throws AssertException {
        Condition[] conds = rule.getConditions();
        ObjectCondition oc = (ObjectCondition)conds[0];
        if (oc.getNegated()) {
            ObjectTypeNode otn = (ObjectTypeNode)this.ruleCompiler.getInputnodes().get(this.ruleCompiler.getEngine().getInitFact());
            LIANode lianode = this.ruleCompiler.findLIANode(otn);
            NotJoin njoin = new NotJoin(this.ruleCompiler.getEngine().nextNodeId());
            njoin.setBindings(new Binding[0]);
            lianode.addSuccessorNode(njoin, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
            rule.addJoinNode(njoin);
            oc.getLastNode().addSuccessorNode(njoin, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
        } else if (oc.getNodes().size() == 0) {
            ObjectTypeNode otn = this.ruleCompiler.findObjectTypeNode(oc.getTemplateName());
            LIANode lianode = new LIANode(this.ruleCompiler.getEngine().nextNodeId());
            otn.addSuccessorNode(lianode, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
            rule.getConditions()[0].addNode(lianode);
        }
    }
}

