/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.compiler;

import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.CompileEvent;
import org.jamocha.rete.DefaultQueryCompiler;
import org.jamocha.rete.DefaultRuleCompiler;
import org.jamocha.rete.HashedEqBNode;
import org.jamocha.rete.HashedEqNJoin;
import org.jamocha.rete.HashedNotEqBNode;
import org.jamocha.rete.HashedNotEqNJoin;
import org.jamocha.rete.LIANode;
import org.jamocha.rete.NotJoin;
import org.jamocha.rete.NotJoinFrst;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.PredicateBNode;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Template;
import org.jamocha.rete.ZJBetaNode;
import org.jamocha.rete.compiler.AbstractConditionCompiler;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryFuncJoin;
import org.jamocha.rete.query.QueryHashedEqJoin;
import org.jamocha.rete.query.QueryHashedEqNot;
import org.jamocha.rete.query.QueryHashedNeqJoin;
import org.jamocha.rete.query.QueryHashedNeqNot;
import org.jamocha.rete.query.QueryLIANode;
import org.jamocha.rete.query.QueryNotJoin;
import org.jamocha.rete.query.QueryNotJoinFrst;
import org.jamocha.rete.query.QueryObjTypeNode;
import org.jamocha.rete.query.QueryZeroJoin;
import org.jamocha.rule.AndLiteralConstraint;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.Defquery;
import org.jamocha.rule.LiteralConstraint;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.OrLiteralConstraint;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Query;
import org.jamocha.rule.Rule;

public class ObjectConditionCompiler
extends AbstractConditionCompiler {
    public ObjectConditionCompiler(RuleCompiler ruleCompiler) {
        this.ruleCompiler = (DefaultRuleCompiler)ruleCompiler;
    }

    public ObjectConditionCompiler(QueryCompiler queryCompiler) {
        this.queryCompiler = (DefaultQueryCompiler)queryCompiler;
    }

    public void compile(Condition condition, int position, Rule util, boolean alphaMemory) {
        ObjectCondition cond = (ObjectCondition)condition;
        ObjectTypeNode otn = this.ruleCompiler.findObjectTypeNode(cond.getTemplateName());
        if (otn != null) {
            BaseAlpha2 first = null;
            BaseAlpha2 previous = null;
            BaseAlpha current = null;
            Template templ = cond.getTemplate();
            Constraint[] constrs = cond.getConstraints();
            int idx = 0;
            while (idx < constrs.length) {
                Constraint cnstr = constrs[idx];
                if (cnstr instanceof LiteralConstraint) {
                    current = this.ruleCompiler.compileConstraint((LiteralConstraint)cnstr, templ, util);
                } else if (cnstr instanceof AndLiteralConstraint) {
                    current = this.ruleCompiler.compileConstraint((AndLiteralConstraint)cnstr, templ, util);
                } else if (cnstr instanceof OrLiteralConstraint) {
                    current = this.ruleCompiler.compileConstraint((OrLiteralConstraint)cnstr, templ, util);
                } else if (cnstr instanceof BoundConstraint) {
                    BoundConstraint bc = (BoundConstraint)cnstr;
                    BaseAlpha2 ifn = this.ruleCompiler.compileConstraint(bc, templ, util, position);
                    if (ifn != null) {
                        current = ifn;
                    }
                } else if (cnstr instanceof PredicateConstraint) {
                    PredicateConstraint pcon = (PredicateConstraint)cnstr;
                    current = this.ruleCompiler.compileConstraint(pcon, templ, util, position);
                    if (pcon.isPredicateJoin()) {
                        cond.setHasPredicateJoin(true);
                    }
                }
                if (first == null) {
                    if (current != null) {
                        first = current;
                        previous = current;
                    }
                } else if (current != null && current != previous) {
                    try {
                        previous.addSuccessorNode(current, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
                        previous = current;
                    }
                    catch (AssertException assertException) {
                        // empty catch block
                    }
                }
                ++idx;
            }
            if (first != null) {
                this.attachAlphaNode(otn, first, cond);
            }
        }
    }

    public void compile(Condition condition, int position, Query query) {
        ObjectCondition cond = (ObjectCondition)condition;
        ObjectTypeNode otn = this.queryCompiler.findObjectTypeNode(cond.getTemplateName());
        QueryObjTypeNode queryOTN = this.queryCompiler.findQueryObjTypeNode(cond.getTemplate());
        if (otn != null) {
            QueryBaseAlpha first = null;
            QueryBaseAlpha previous = null;
            QueryBaseAlpha current = null;
            Template templ = cond.getTemplate();
            Constraint[] constrs = cond.getConstraints();
            int idx = 0;
            while (idx < constrs.length) {
                Constraint cnstr = constrs[idx];
                if (cnstr instanceof LiteralConstraint) {
                    current = this.queryCompiler.compileConstraint((LiteralConstraint)cnstr, templ, query);
                } else if (cnstr instanceof AndLiteralConstraint) {
                    current = this.queryCompiler.compileConstraint((AndLiteralConstraint)cnstr, templ, query);
                } else if (cnstr instanceof OrLiteralConstraint) {
                    current = this.queryCompiler.compileConstraint((OrLiteralConstraint)cnstr, templ, query);
                } else if (cnstr instanceof BoundConstraint) {
                    current = this.queryCompiler.compileConstraint((BoundConstraint)cnstr, templ, query, position);
                } else if (cnstr instanceof PredicateConstraint) {
                    PredicateConstraint pcon = (PredicateConstraint)cnstr;
                    current = this.queryCompiler.compileConstraint(pcon, templ, query, position);
                }
                if (first == null) {
                    if (current != null) {
                        first = current;
                        previous = current;
                    }
                } else if (current != null && current != previous) {
                    try {
                        previous.addSuccessorNode(current, this.queryCompiler.getEngine(), null);
                        previous = current;
                    }
                    catch (AssertException assertException) {
                        // empty catch block
                    }
                }
                ++idx;
            }
            if (first != null) {
                try {
                    queryOTN.addSuccessorNode(first, this.queryCompiler.getEngine(), null);
                    cond.addNewAlphaNodes(first);
                }
                catch (AssertException assertException) {
                    // empty catch block
                }
            }
        }
    }

    protected void attachAlphaNode(BaseAlpha existing, BaseAlpha alpha, Condition cond) {
        if (alpha != null) {
            try {
                BaseAlpha share = null;
                share = this.shareAlphaNode(existing, alpha);
                if (share == null) {
                    existing.addSuccessorNode(alpha, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
                    cond.addNewAlphaNodes(alpha);
                } else if (existing != alpha) {
                    share.incrementUseCount();
                    cond.addNode(share);
                    this.ruleCompiler.getMemory().removeAlphaMemory(alpha);
                    if (alpha.successorCount() == 1 && alpha.getSuccessorNodes()[0] instanceof BaseAlpha) {
                        BaseAlpha nnext = (BaseAlpha)alpha.getSuccessorNodes()[0];
                        this.attachAlphaNode(share, nnext, cond);
                    }
                }
            }
            catch (AssertException e) {
                CompileEvent ce = new CompileEvent(this, 11);
                ce.setMessage(alpha.toPPString());
                this.ruleCompiler.notifyListener(ce);
            }
        }
    }

    private BaseAlpha shareAlphaNode(BaseAlpha existing, BaseAlpha alpha) {
        Object[] scc = existing.getSuccessorNodes();
        int idx = 0;
        while (idx < scc.length) {
            BaseAlpha baseAlpha;
            Object next = scc[idx];
            if (next instanceof BaseAlpha && (baseAlpha = (BaseAlpha)next).hashString().equals(alpha.hashString())) {
                return baseAlpha;
            }
            ++idx;
        }
        return null;
    }

    public void compileFirstJoin(Condition condition, Rule rule) throws AssertException {
        ObjectCondition cond = (ObjectCondition)condition;
        ObjectTypeNode otn = this.ruleCompiler.findObjectTypeNode(cond.getTemplateName());
        LIANode node = new LIANode(this.ruleCompiler.getEngine().nextNodeId());
        if (cond.getNodes().size() == 0) {
            LIANode existingLIANode = this.ruleCompiler.findLIANode(otn);
            if (existingLIANode == null) {
                otn.addSuccessorNode(node, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
                cond.addNode(node);
            } else {
                existingLIANode.incrementUseCount();
                cond.addNode(existingLIANode);
            }
        } else {
            BaseAlpha old = (BaseAlpha)cond.getLastNode();
            BaseNode[] successors = (BaseNode[])old.getSuccessorNodes();
            int i = 0;
            while (i < successors.length) {
                if (successors[i] instanceof LIANode) {
                    cond.addNode(successors[i]);
                    return;
                }
                ++i;
            }
            if (!(old instanceof LIANode)) {
                old.addSuccessorNode(node, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
                cond.addNode(node);
            }
        }
    }

    public void compileFirstJoin(Condition condition, Query query) throws AssertException {
        Defquery dquery = (Defquery)query;
        ObjectCondition cond = (ObjectCondition)condition;
        Template template = this.queryCompiler.getEngine().findTemplate(cond.getTemplateName());
        QueryObjTypeNode queryotn = dquery.getQueryRootNode().findQueryObjTypeNode(template);
        QueryLIANode node = new QueryLIANode(this.queryCompiler.getEngine().nextNodeId());
        if (cond.getNodes().size() == 0) {
            QueryLIANode existingLIANode = this.queryCompiler.findQueryLIANode(queryotn);
            if (existingLIANode == null) {
                queryotn.addSuccessorNode(node, this.queryCompiler.getEngine(), null);
                cond.addNode(node);
            } else {
                existingLIANode.incrementUseCount();
                cond.addNode(existingLIANode);
            }
        } else {
            BaseAlpha old = (BaseAlpha)cond.getLastNode();
            BaseNode[] successors = (BaseNode[])old.getSuccessorNodes();
            int i = 0;
            while (i < successors.length) {
                if (successors[i] instanceof LIANode) {
                    cond.addNode(successors[i]);
                    return;
                }
                ++i;
            }
            if (!(old instanceof LIANode)) {
                old.addSuccessorNode(node, this.queryCompiler.getEngine(), null);
                cond.addNode(node);
            }
        }
    }

    public BaseJoin compileJoin(Condition condition, int position, Rule rule, Condition previousCond) {
        Binding[] binds = this.getBindings(condition, rule, position);
        ObjectCondition oc = (ObjectCondition)condition;
        BaseJoin joinNode = null;
        if (!oc.getNegated()) {
            if (binds.length > 0 && oc.isHasPredicateJoin()) {
                joinNode = new PredicateBNode(this.ruleCompiler.getEngine().nextNodeId());
            } else if (binds.length > 0 && oc.isHasNotEqual()) {
                joinNode = new HashedNotEqBNode(this.ruleCompiler.getEngine().nextNodeId());
            } else if (binds.length > 0) {
                joinNode = new HashedEqBNode(this.ruleCompiler.getEngine().nextNodeId());
            } else if (binds.length == 0) {
                joinNode = new ZJBetaNode(this.ruleCompiler.getEngine().nextNodeId());
            }
        }
        if (oc.getNegated()) {
            joinNode = binds.length > 0 && oc.isHasPredicateJoin() ? new NotJoin(this.ruleCompiler.getEngine().nextNodeId()) : (oc.isHasNotEqual() ? new HashedNotEqNJoin(this.ruleCompiler.getEngine().nextNodeId()) : new HashedEqNJoin(this.ruleCompiler.getEngine().nextNodeId()));
        }
        joinNode.setBindings(binds);
        return joinNode;
    }

    public QueryBaseJoin compileJoin(Condition condition, int position, Query query, Condition previousCond) {
        Binding[] binds = this.getBindings(condition, query, position);
        ObjectCondition oc = (ObjectCondition)condition;
        QueryBaseJoin joinNode = null;
        if (!oc.getNegated()) {
            if (binds.length > 0 && oc.isHasPredicateJoin()) {
                joinNode = new QueryFuncJoin(this.queryCompiler.getEngine().nextNodeId());
            } else if (binds.length > 0 && oc.isHasNotEqual()) {
                joinNode = new QueryHashedNeqJoin(this.queryCompiler.getEngine().nextNodeId());
            } else if (binds.length > 0) {
                joinNode = new QueryHashedEqJoin(this.queryCompiler.getEngine().nextNodeId());
            } else if (binds.length == 0) {
                joinNode = new QueryZeroJoin(this.queryCompiler.getEngine().nextNodeId());
            }
        }
        if (oc.getNegated()) {
            joinNode = binds.length > 0 && oc.isHasPredicateJoin() ? new QueryNotJoin(this.queryCompiler.getEngine().nextNodeId()) : (oc.isHasNotEqual() ? new QueryHashedNeqNot(this.queryCompiler.getEngine().nextNodeId()) : new QueryHashedEqNot(this.queryCompiler.getEngine().nextNodeId()));
        }
        joinNode.setBindings(binds);
        return joinNode;
    }

    ObjectCondition getObjectCondition(Condition condition) {
        return (ObjectCondition)condition;
    }

    public void compileSingleCE(Rule rule) throws AssertException {
        Condition[] conds = rule.getConditions();
        ObjectCondition oc = (ObjectCondition)conds[0];
        if (oc.getNegated()) {
            ObjectTypeNode otn = (ObjectTypeNode)this.ruleCompiler.getInputnodes().get(this.ruleCompiler.getEngine().getInitFact());
            LIANode lianode = this.ruleCompiler.findLIANode(otn);
            NotJoinFrst njoin = new NotJoinFrst(this.ruleCompiler.getEngine().nextNodeId());
            njoin.setBindings(new Binding[0]);
            lianode.addSuccessorNode(njoin, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
            rule.addJoinNode(njoin);
            oc.getLastNode().addSuccessorNode(njoin, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
        } else if (oc.getNodes().size() == 0) {
            ObjectTypeNode otn = this.ruleCompiler.findObjectTypeNode(oc.getTemplateName());
            LIANode lianode = new LIANode(this.ruleCompiler.getEngine().nextNodeId());
            otn.addSuccessorNode(lianode, this.ruleCompiler.getEngine(), this.ruleCompiler.getMemory());
            rule.getConditions()[0].addNode(lianode);
        }
    }

    public void compileSingleCE(Query query) throws AssertException {
        Condition[] conds = query.getConditions();
        ObjectCondition oc = (ObjectCondition)conds[0];
        Defquery dquery = (Defquery)query;
        if (oc.getNegated()) {
            Template template = this.queryCompiler.getEngine().findTemplate(this.queryCompiler.getEngine().getInitFact().getName());
            QueryObjTypeNode queryotn = dquery.getQueryRootNode().findQueryObjTypeNode(template);
            QueryLIANode querylianode = this.queryCompiler.findQueryLIANode(queryotn);
            QueryNotJoinFrst njoin = new QueryNotJoinFrst(this.queryCompiler.getEngine().nextNodeId());
            njoin.setBindings(new Binding[0]);
            querylianode.addSuccessorNode(njoin, this.queryCompiler.getEngine(), null);
            query.addJoinNode(njoin);
            oc.getLastNode().addSuccessorNode(njoin, this.queryCompiler.getEngine(), null);
        } else if (oc.getNodes().size() == 0) {
            Template template = this.queryCompiler.getEngine().findTemplate(this.queryCompiler.getEngine().getInitFact().getName());
            QueryObjTypeNode queryotn = dquery.getQueryRootNode().findQueryObjTypeNode(template);
            QueryLIANode lianode = new QueryLIANode(this.queryCompiler.getEngine().nextNodeId());
            queryotn.addSuccessorNode(lianode, this.queryCompiler.getEngine(), null);
            query.getConditions()[0].addNode(lianode);
        }
    }
}

