/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.compiler;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.CubeDimension;
import org.jamocha.rete.CubeQueryBNode;
import org.jamocha.rete.CubeTemplate;
import org.jamocha.rete.DefaultQueryCompiler;
import org.jamocha.rete.DefaultRuleCompiler;
import org.jamocha.rete.DimensionSlot;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Template;
import org.jamocha.rete.compiler.AbstractConditionCompiler;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryCubeQueryJoin;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.CubeQueryCondition;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Query;
import org.jamocha.rule.Rule;

public class CubeQueryConditionCompiler
extends AbstractConditionCompiler {
    public CubeQueryConditionCompiler(RuleCompiler ruleCompiler) {
        this.ruleCompiler = (DefaultRuleCompiler)ruleCompiler;
    }

    public CubeQueryConditionCompiler(QueryCompiler queryCompiler) {
        this.queryCompiler = (DefaultQueryCompiler)queryCompiler;
    }

    public void compile(Condition condition, int position, Rule rule, boolean alphaMemory) {
        ObjectCondition cond = (ObjectCondition)condition;
        CubeTemplate templ = (CubeTemplate)cond.getTemplate();
        Constraint[] constrs = cond.getConstraints();
        int idx = 0;
        while (idx < constrs.length) {
            Constraint cnstr = constrs[idx];
            if (cnstr instanceof BoundConstraint) {
                BoundConstraint bc = (BoundConstraint)cnstr;
                this.ruleCompiler.compileConstraint(bc, (Template)templ, rule, position);
            } else if (cnstr instanceof PredicateConstraint && rule.getBinding(((PredicateConstraint)cnstr).getVariableName()) == null) {
                PredicateConstraint pc = (PredicateConstraint)cnstr;
                int operator = ConversionUtils.getOperatorCode(pc.getFunctionName());
                Binding2 bind = new Binding2(operator);
                bind.setRightIndex(templ.getColumnIndex(pc.getName()));
                bind.setVarName(pc.getVariableName());
                Object val = pc.getValue();
                if (val instanceof BoundParam) {
                    BoundParam bp = (BoundParam)val;
                    Binding bd = rule.getBinding(bp.getVariableName());
                    bind.setLeftRow(bd.getLeftRow());
                    bind.setLeftIndex(bd.getLeftIndex());
                } else {
                    bind.setQueryValue(pc.getValue());
                }
                rule.addBinding(pc.getVariableName(), bind);
            }
            ++idx;
        }
    }

    public void compile(Condition condition, int position, Query query) {
        ObjectCondition cond = (ObjectCondition)condition;
        CubeTemplate templ = (CubeTemplate)cond.getTemplate();
        Constraint[] constrs = cond.getConstraints();
        int idx = 0;
        while (idx < constrs.length) {
            Constraint cnstr = constrs[idx];
            if (cnstr instanceof BoundConstraint) {
                BoundConstraint bc = (BoundConstraint)cnstr;
                this.queryCompiler.compileConstraint(bc, (Template)templ, query, position);
            } else if (cnstr instanceof PredicateConstraint && query.getBinding(((PredicateConstraint)cnstr).getVariableName()) == null) {
                PredicateConstraint pc = (PredicateConstraint)cnstr;
                int operator = ConversionUtils.getOperatorCode(pc.getFunctionName());
                Binding2 bind = new Binding2(operator);
                bind.setRightIndex(templ.getColumnIndex(pc.getName()));
                bind.setVarName(pc.getVariableName());
                Object val = pc.getValue();
                if (val instanceof BoundParam) {
                    BoundParam bp = (BoundParam)val;
                    Binding bd = query.getBinding(bp.getVariableName());
                    bind.setLeftRow(bd.getLeftRow());
                    bind.setLeftIndex(bd.getLeftIndex());
                } else {
                    bind.setQueryValue(pc.getValue());
                }
                query.addBinding(pc.getVariableName(), bind);
            }
            ++idx;
        }
    }

    protected void attachAlphaNode(BaseAlpha existing, BaseAlpha alpha, Condition cond) {
    }

    public void compileFirstJoin(Condition condition, Rule rule) throws AssertException {
    }

    public void compileFirstJoin(Condition condition, Query query) throws AssertException {
    }

    public BaseJoin compileJoin(Condition condition, int position, Rule rule, Condition previousCond) {
        ArrayList dbindings = new ArrayList();
        ArrayList mbindings = new ArrayList();
        this.getCubeBindings(condition, rule, position, dbindings, mbindings);
        ObjectCondition oc = (ObjectCondition)condition;
        CubeQueryBNode joinNode = null;
        if (!oc.getNegated()) {
            joinNode = new CubeQueryBNode(this.ruleCompiler.getEngine().nextNodeId());
        }
        Binding[] binds = this.getLeftBindings(condition, rule, position);
        Binding[] nbinds = this.getNumericBindings(condition, rule, position);
        CubeBinding[] dmnBindings = new CubeBinding[dbindings.size()];
        dmnBindings = dbindings.toArray(dmnBindings);
        CubeBinding[] msrBindings = new CubeBinding[mbindings.size()];
        msrBindings = mbindings.toArray(msrBindings);
        joinNode.setBindings(binds);
        joinNode.setNumericBindings(nbinds);
        joinNode.setDimensionBindings(dmnBindings);
        joinNode.setMeasureBindings(msrBindings);
        return joinNode;
    }

    public QueryBaseJoin compileJoin(Condition condition, int position, Query rule, Condition previousCond) {
        ArrayList dbindings = new ArrayList();
        ArrayList mbindings = new ArrayList();
        this.getCubeBindings(condition, rule, position, dbindings, mbindings);
        ObjectCondition oc = (ObjectCondition)condition;
        QueryCubeQueryJoin joinNode = null;
        if (!oc.getNegated()) {
            joinNode = new QueryCubeQueryJoin(this.queryCompiler.getEngine().nextNodeId());
        }
        Binding[] binds = this.getLeftBindings(condition, rule, position);
        Binding[] nbinds = this.getNumericBindings(condition, rule, position);
        CubeBinding[] dmnBindings = new CubeBinding[dbindings.size()];
        dmnBindings = dbindings.toArray(dmnBindings);
        CubeBinding[] msrBindings = new CubeBinding[mbindings.size()];
        msrBindings = mbindings.toArray(msrBindings);
        joinNode.setBindings(binds);
        joinNode.setNumericBindings(nbinds);
        joinNode.setDimensionBindings(dmnBindings);
        joinNode.setMeasureBindings(msrBindings);
        return joinNode;
    }

    ObjectCondition getObjectCondition(Condition condition) {
        return (ObjectCondition)condition;
    }

    public void compileSingleCE(Rule rule) throws AssertException {
    }

    public void compileSingleCE(Query query) throws AssertException {
    }

    public Binding[] getLeftBindings(Condition condition, Rule rule, int position) {
        CubeQueryCondition cqcond = (CubeQueryCondition)this.getObjectCondition(condition);
        List Constraints = cqcond.getQueryConstraints();
        Template tmpl = cqcond.getTemplate();
        ArrayList<Binding> bindlist = new ArrayList<Binding>();
        int idz = 0;
        while (idz < Constraints.size()) {
            BoundConstraint bc;
            Binding cpy;
            Object cst = Constraints.get(idz);
            if (cst instanceof BoundConstraint && (cpy = rule.copyBinding((bc = (BoundConstraint)cst).getVariableName())) != null) {
                if (cpy.getLeftRow() >= position) break;
                bindlist.add(cpy);
                int rinx = tmpl.getColumnIndex(bc.getName());
                tmpl.incrementColumnUseCount(bc.getName());
                cpy.setRightIndex(rinx);
                cpy.setNegated(bc.getNegated());
                if (bc.getNegated()) {
                    cqcond.setHasNotEqual(true);
                }
            }
            ++idz;
        }
        Binding[] binds = new Binding[bindlist.size()];
        binds = bindlist.toArray(binds);
        return binds;
    }

    public Binding[] getLeftBindings(Condition condition, Query query, int position) {
        CubeQueryCondition cqcond = (CubeQueryCondition)this.getObjectCondition(condition);
        List Constraints = cqcond.getQueryConstraints();
        Template tmpl = cqcond.getTemplate();
        ArrayList<Binding> bindlist = new ArrayList<Binding>();
        int idz = 0;
        while (idz < Constraints.size()) {
            BoundConstraint bc;
            Binding cpy;
            Object cst = Constraints.get(idz);
            if (cst instanceof BoundConstraint && (cpy = query.copyBinding((bc = (BoundConstraint)cst).getVariableName())) != null) {
                if (cpy.getLeftRow() >= position) break;
                bindlist.add(cpy);
                int rinx = tmpl.getColumnIndex(bc.getName());
                tmpl.incrementColumnUseCount(bc.getName());
                cpy.setRightIndex(rinx);
                cpy.setNegated(bc.getNegated());
                if (bc.getNegated()) {
                    cqcond.setHasNotEqual(true);
                }
            }
            ++idz;
        }
        Binding[] binds = new Binding[bindlist.size()];
        binds = bindlist.toArray(binds);
        return binds;
    }

    public Binding[] getNumericBindings(Condition condition, Rule rule, int position) {
        CubeQueryCondition cqcond = (CubeQueryCondition)this.getObjectCondition(condition);
        List Constraints = cqcond.getQueryConstraints();
        Template tmpl = cqcond.getTemplate();
        ArrayList<Binding> bindlist = new ArrayList<Binding>();
        int idz = 0;
        while (idz < Constraints.size()) {
            Object cst = Constraints.get(idz);
            if (cst instanceof PredicateConstraint) {
                PredicateConstraint pc = (PredicateConstraint)cst;
                int operator = ConversionUtils.getOperatorCode(pc.getFunctionName());
                if (pc.reverseOperator()) {
                    operator = ConversionUtils.getOppositeOperatorCode(operator);
                }
                Binding cpy = rule.copyPredicateBinding(pc.getVariableName(), operator);
                int rinx = tmpl.getColumnIndex(pc.getName());
                tmpl.incrementColumnUseCount(pc.getName());
                cpy.setRightIndex(rinx);
                bindlist.add(cpy);
                BaseSlot bslot = tmpl.getSlot(pc.getName());
                if (bslot instanceof DimensionSlot) {
                    ((DimensionSlot)bslot).getDimension().setAutoIndex(true);
                }
            }
            ++idz;
        }
        Binding[] binds = new Binding[bindlist.size()];
        binds = bindlist.toArray(binds);
        return binds;
    }

    public Binding[] getNumericBindings(Condition condition, Query query, int position) {
        CubeQueryCondition cqcond = (CubeQueryCondition)this.getObjectCondition(condition);
        List Constraints = cqcond.getQueryConstraints();
        Template tmpl = cqcond.getTemplate();
        ArrayList<Binding> bindlist = new ArrayList<Binding>();
        int idz = 0;
        while (idz < Constraints.size()) {
            Object cst = Constraints.get(idz);
            if (cst instanceof PredicateConstraint) {
                PredicateConstraint pc = (PredicateConstraint)cst;
                int operator = ConversionUtils.getOperatorCode(pc.getFunctionName());
                if (pc.reverseOperator()) {
                    operator = ConversionUtils.getOppositeOperatorCode(operator);
                }
                Binding cpy = query.copyPredicateBinding(pc.getVariableName(), operator);
                int rinx = tmpl.getColumnIndex(pc.getName());
                tmpl.incrementColumnUseCount(pc.getName());
                cpy.setRightIndex(rinx);
                bindlist.add(cpy);
                BaseSlot bslot = tmpl.getSlot(pc.getName());
                if (bslot instanceof DimensionSlot) {
                    ((DimensionSlot)bslot).getDimension().setAutoIndex(true);
                }
            }
            ++idz;
        }
        Binding[] binds = new Binding[bindlist.size()];
        binds = bindlist.toArray(binds);
        return binds;
    }

    public void getCubeBindings(Condition condition, Rule rule, int position, ArrayList dimensionBinding, ArrayList measureBinding) {
        CubeQueryCondition cqcondition = (CubeQueryCondition)condition;
        Cube cube = this.ruleCompiler.getEngine().getCube(cqcondition.getTemplateName());
        Constraint[] constraints = cqcondition.getConstraints();
        int idx = 0;
        while (idx < constraints.length) {
            if (constraints[idx] instanceof BoundConstraint) {
                CubeBinding cbind;
                BoundConstraint bc = (BoundConstraint)constraints[idx];
                CubeDimension dimen = cube.getDimension(bc.getName());
                if (dimen != null) {
                    cbind = (CubeBinding)dimen.getBinding();
                    if (cbind.isMeasure()) {
                        measureBinding.add(cbind);
                    } else {
                        dimensionBinding.add(cbind);
                        CubeDimension dimension = cube.getDimension(bc.getName());
                        if (dimension != null) {
                            dimension.setAutoIndex(true);
                        }
                    }
                } else if (!bc.getIsObjectBinding()) {
                    cbind = cube.getBindingBySlot(bc.getName());
                    measureBinding.add(cbind);
                }
            }
            ++idx;
        }
    }

    public void getCubeBindings(Condition condition, Query query, int position, ArrayList dimensionBinding, ArrayList measureBinding) {
        CubeQueryCondition cqcondition = (CubeQueryCondition)condition;
        Cube cube = this.queryCompiler.getEngine().getCube(cqcondition.getTemplateName());
        Constraint[] constraints = cqcondition.getConstraints();
        int idx = 0;
        while (idx < constraints.length) {
            if (constraints[idx] instanceof BoundConstraint) {
                CubeBinding cbind;
                BoundConstraint bc = (BoundConstraint)constraints[idx];
                CubeDimension dimen = cube.getDimension(bc.getName());
                if (dimen != null) {
                    cbind = (CubeBinding)dimen.getBinding();
                    if (cbind.isMeasure()) {
                        measureBinding.add(cbind);
                    } else {
                        dimensionBinding.add(cbind);
                        CubeDimension dimension = cube.getDimension(bc.getName());
                        if (dimension != null) {
                            dimension.setAutoIndex(true);
                        }
                    }
                } else {
                    cbind = cube.getBindingBySlot(bc.getName());
                    measureBinding.add(cbind);
                }
            }
            ++idx;
        }
    }
}

