/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.compiler;

import java.util.List;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.DefaultQueryCompiler;
import org.jamocha.rete.DefaultRuleCompiler;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.Rete;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Template;
import org.jamocha.rete.compiler.ConditionCompiler;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryObjTypeNode;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Query;
import org.jamocha.rule.Rule;

public abstract class AbstractConditionCompiler
implements ConditionCompiler {
    protected DefaultRuleCompiler ruleCompiler;
    protected DefaultQueryCompiler queryCompiler;

    public final RuleCompiler getRuleCompiler() {
        return this.ruleCompiler;
    }

    public final QueryCompiler getQueryCompiler() {
        return this.queryCompiler;
    }

    public final void connectJoinNode(Condition previousCondition, Condition condition, BaseJoin previousJoinNode, BaseJoin joinNode) throws AssertException {
        if (previousJoinNode != null) {
            this.ruleCompiler.attachJoinNode(previousJoinNode, joinNode);
        } else {
            this.ruleCompiler.attachJoinNode(previousCondition.getLastNode(), joinNode);
        }
        ObjectCondition oc = this.getObjectCondition(condition);
        ObjectTypeNode otn = this.ruleCompiler.findObjectTypeNode(oc.getTemplateName());
        if (oc.getNodes().size() > 0) {
            this.ruleCompiler.attachJoinNode(oc.getLastNode(), joinNode);
        } else {
            otn.addSuccessorNode(joinNode, this.ruleCompiler.getEngine(), this.ruleCompiler.getEngine().getWorkingMemory());
        }
    }

    public final void connectJoinNode(Condition previousCondition, Condition condition, QueryBaseJoin previousJoinNode, QueryBaseJoin joinNode) throws AssertException {
        if (previousJoinNode != null) {
            this.queryCompiler.attachJoinNode((BaseNode)previousJoinNode, joinNode);
        } else {
            this.queryCompiler.attachJoinNode(previousCondition.getLastNode(), joinNode);
        }
        ObjectCondition oc = this.getObjectCondition(condition);
        Template template = this.queryCompiler.getEngine().findTemplate(oc.getTemplateName());
        QueryObjTypeNode qotn = this.queryCompiler.findQueryObjTypeNode(template);
        if (oc.getNodes().size() > 0) {
            this.queryCompiler.attachJoinNode(oc.getLastNode(), joinNode);
        } else {
            qotn.addSuccessorNode(joinNode, this.queryCompiler.getEngine(), this.queryCompiler.getEngine().getWorkingMemory());
        }
    }

    abstract ObjectCondition getObjectCondition(Condition var1);

    final Binding[] getBindings(Condition condition, Rule rule, int position) {
        ObjectCondition oc = this.getObjectCondition(condition);
        List Constraints = oc.getBindConstraints();
        Template tmpl = oc.getTemplate();
        Binding[] binds = new Binding[Constraints.size()];
        int idz = 0;
        while (idz < Constraints.size()) {
            Object cst = Constraints.get(idz);
            if (cst instanceof BoundConstraint) {
                BoundConstraint bc = (BoundConstraint)cst;
                Binding cpy = rule.copyBinding(bc.getVariableName());
                if (cpy.getLeftRow() >= position) {
                    binds = new Binding[]{};
                    break;
                }
                binds[idz] = cpy;
                int rinx = tmpl.getColumnIndex(bc.getName());
                tmpl.incrementColumnUseCount(bc.getName());
                binds[idz].setRightIndex(rinx);
                binds[idz].setNegated(bc.getNegated());
                if (bc.getNegated()) {
                    oc.setHasNotEqual(true);
                }
            } else if (cst instanceof PredicateConstraint) {
                PredicateConstraint pc = (PredicateConstraint)cst;
                if (pc.getValue() instanceof BoundParam) {
                    oc.setHasPredicateJoin(true);
                    BoundParam bpm = (BoundParam)pc.getValue();
                    String var = bpm.getVariableName();
                    int op = ConversionUtils.getOperatorCode(pc.getFunctionName());
                    if (op != 13) {
                        if (pc.getParameters().get(0) != bpm) {
                            op = ConversionUtils.getOppositeOperatorCode(op);
                        }
                        binds[idz] = rule.copyPredicateBinding(var, op);
                        ((Binding2)binds[idz]).setRightVariable(pc.getVariableName());
                    } else {
                        Binding2 b2 = (Binding2)rule.copyPredicateBinding(var, op);
                        binds[idz] = b2;
                        b2.setFunction(this.ruleCompiler.getEngine().findFunction(pc.getFunctionName()));
                        Parameter[] params = new Parameter[pc.getParameters().size()];
                        params = pc.getParameters().toArray(params);
                        b2.setParams(params);
                        int px = 0;
                        while (px < params.length) {
                            if (params[px] instanceof FunctionParam2) {
                                this.configureNestedFunctionParam((FunctionParam2)params[px], this.ruleCompiler.getEngine(), rule);
                            } else if (params[px] instanceof BoundParam) {
                                BoundParam bp = (BoundParam)params[px];
                                Binding binding = rule.getBinding(bp.getVariableName());
                                bp.setRow(binding.getLeftRow());
                                bp.setColumn(binding.getLeftIndex());
                            }
                            ++px;
                        }
                    }
                    binds[idz].setPredJoin(true);
                    int rinx = tmpl.getColumnIndex(pc.getName());
                    tmpl.incrementColumnUseCount(pc.getName());
                    binds[idz].setRightIndex(rinx);
                } else if (pc.getFunctionName() != null) {
                    Binding2 bind2 = new Binding2(9);
                    binds[idz] = bind2;
                    Function f = this.ruleCompiler.getEngine().findFunction(pc.getFunctionName());
                    bind2.setFunction(f);
                    bind2.setPredJoin(true);
                    Parameter[] params = new Parameter[pc.getParameters().size()];
                    params = pc.getParameters().toArray(params);
                    bind2.setParams(params);
                    int px = 0;
                    while (px < params.length) {
                        if (params[px] instanceof FunctionParam2) {
                            this.configureNestedFunctionParam((FunctionParam2)params[px], this.ruleCompiler.getEngine(), rule);
                        }
                        ++px;
                    }
                }
            }
            ++idz;
        }
        return binds;
    }

    final Binding[] getBindings(Condition condition, Query query, int position) {
        ObjectCondition oc = this.getObjectCondition(condition);
        List Constraints = oc.getBindConstraints();
        Template tmpl = oc.getTemplate();
        Binding[] binds = new Binding[Constraints.size()];
        int idz = 0;
        while (idz < Constraints.size()) {
            Object cst = Constraints.get(idz);
            if (cst instanceof BoundConstraint) {
                BoundConstraint bc = (BoundConstraint)cst;
                Binding cpy = query.copyBinding(bc.getVariableName());
                if (cpy.getLeftRow() >= position) {
                    binds = new Binding[]{};
                    break;
                }
                binds[idz] = cpy;
                int rinx = tmpl.getColumnIndex(bc.getName());
                tmpl.incrementColumnUseCount(bc.getName());
                binds[idz].setRightIndex(rinx);
                binds[idz].setNegated(bc.getNegated());
                if (bc.getNegated()) {
                    oc.setHasNotEqual(true);
                }
            } else if (cst instanceof PredicateConstraint) {
                PredicateConstraint pc = (PredicateConstraint)cst;
                if (pc.getValue() instanceof BoundParam) {
                    oc.setHasPredicateJoin(true);
                    BoundParam bpm = (BoundParam)pc.getValue();
                    String var = bpm.getVariableName();
                    int op = ConversionUtils.getOperatorCode(pc.getFunctionName());
                    if (op != 13) {
                        if (pc.getParameters().get(0) != bpm) {
                            op = ConversionUtils.getOppositeOperatorCode(op);
                        }
                        binds[idz] = query.copyPredicateBinding(var, op);
                        ((Binding2)binds[idz]).setRightVariable(pc.getVariableName());
                    } else {
                        binds[idz] = query.copyPredicateBinding(var, op);
                        ((Binding2)binds[idz]).setFunction(this.queryCompiler.getEngine().findFunction(pc.getFunctionName()));
                    }
                    binds[idz].setPredJoin(true);
                    int rinx = tmpl.getColumnIndex(pc.getName());
                    tmpl.incrementColumnUseCount(pc.getName());
                    binds[idz].setRightIndex(rinx);
                } else if (pc.getFunctionName() != null) {
                    Binding2 bind2 = new Binding2(9);
                    binds[idz] = bind2;
                    Function f = this.queryCompiler.getEngine().findFunction(pc.getFunctionName());
                    bind2.setFunction(f);
                    bind2.setPredJoin(true);
                    Parameter[] params = new Parameter[pc.getParameters().size()];
                    params = pc.getParameters().toArray(params);
                    bind2.setParams(params);
                    int px = 0;
                    while (px < params.length) {
                        if (params[px] instanceof FunctionParam2) {
                            this.configureNestedFunctionParam((FunctionParam2)params[px], this.queryCompiler.getEngine(), query);
                        }
                        ++px;
                    }
                }
            }
            ++idz;
        }
        return binds;
    }

    protected void configureNestedFunctionParam(FunctionParam2 functionParam, Rete engine, Rule util) {
        functionParam.configure(engine, util);
    }

    protected void configureNestedFunctionParam(FunctionParam2 functionParam, Rete engine, Query util) {
        functionParam.configure(engine, util);
    }
}

