/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Map;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.LinkedActivation;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TemporalDeffact;
import org.jamocha.rete.TemporalFact;
import org.jamocha.rete.TerminalNode2;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rule.Rule;

public class TemporalTNode
extends TerminalNode2 {
    private boolean temporal = false;

    public TemporalTNode(int id, Rule rl) {
        super(id, rl);
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public void setTemporal(boolean temporal) {
        this.temporal = temporal;
    }

    public void assertFacts(Index inx, Rete engine, WorkingMemory mem) {
        if (this.checkFacts(inx, engine, mem)) {
            LinkedActivation act = new LinkedActivation(this.theRule, inx);
            act.setTerminalNode(this);
            if (this.temporal) {
                engine.fireActivation(act);
            } else {
                Map tmem = (Map)mem.getTerminalMemory(this);
                tmem.put(inx, act);
                engine.getAgenda().addActivation(act);
            }
        }
    }

    protected boolean checkFacts(Index inx, Rete engine, WorkingMemory mem) {
        Fact[] facts = inx.getFacts();
        boolean fresh = true;
        long current = System.currentTimeMillis();
        int idx = 0;
        while (idx < facts.length) {
            TemporalDeffact tf;
            if (facts[idx] instanceof TemporalFact && (tf = (TemporalDeffact)facts[idx]).getExpirationTime() < current) {
                fresh = false;
                try {
                    engine.retractFact(tf);
                }
                catch (RetractException retractException) {
                    // empty catch block
                }
            }
            ++idx;
        }
        return fresh;
    }
}

