/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamocha.rete.AbstractTemporalNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Index;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.TemporalHashedAlphaMem;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.util.NodeUtils;

public class TemporalIntervalNode
extends AbstractTemporalNode {
    private int interval = 0;
    private long lastTime = 0L;
    private long nextTime = 0L;
    private Map partialMatches = null;
    private Function function = null;
    private BigDecimal count = new BigDecimal(0);
    private ValueParam p1 = new ValueParam();
    private Parameter[] params = null;

    public TemporalIntervalNode(int id, Rete engine) {
        super(id);
        this.partialMatches = engine.newLinkedHashmap(String.valueOf(this.getNodeId()));
        this.lastTime = System.currentTimeMillis();
        this.nextTime = this.lastTime + (long)this.interval;
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        long time = this.getRightTime();
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.put(linx, linx);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        Iterator itr = rightmem.iterator(inx);
        if (itr != null) {
            while (itr.hasNext()) {
                Fact vl = (Fact)itr.next();
                if (vl == null) continue;
                if (vl.timeStamp() > time) {
                    Index newindx = linx.add(vl);
                    this.partialMatches.put(newindx, newindx);
                    continue;
                }
                this.removeFromPartialMatches(vl);
                rightmem.removePartialMatch(inx, vl);
            }
        }
        this.propogateAssert(engine, mem);
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        long time = this.getLeftTime();
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        rightmem.addPartialMatch(inx, rfact, engine);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (Index linx : leftmem.values()) {
            if (this.evaluate(linx.getFacts(), rfact, time)) {
                Index newindx = linx.add(rfact);
                this.partialMatches.put(newindx, newindx);
                continue;
            }
            this.removeFromPartialMatches(linx);
            leftmem.remove(linx);
        }
        this.propogateAssert(engine, mem);
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.remove(linx);
        EqHashIndex eqinx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        Iterator itr = rightmem.iterator(eqinx);
        if (itr != null) {
            while (itr.hasNext()) {
                this.propogateRetract(linx.add((Fact)itr.next()), engine, mem);
            }
        }
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        long time = this.getLeftTime();
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        rightmem.removePartialMatch(inx, rfact);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact, time)) continue;
            this.propogateRetract(linx.add(rfact), engine, mem);
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right, Rete engine) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd instanceof Binding2 ? ((Binding2)bnd).evaluate(leftlist, right, engine) : bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    protected void propogateAssert(Rete engine, WorkingMemory mem) throws AssertException {
        long now = System.currentTimeMillis();
        if (now > this.nextTime) {
            List proplist = new ArrayList();
            if (this.function != null) {
                ((ValueParam)this.params[1]).setValue(new ArrayList(this.partialMatches.values()));
                ReturnVector rv = this.function.executeFunction(engine, this.params);
                proplist = (List)rv.firstReturnValue().getValue();
            }
            if (proplist.size() > 0) {
                int idx = 0;
                while (idx < proplist.size()) {
                    this.propogateAssert((Index)proplist.get(idx), engine, mem);
                    ++idx;
                }
            }
            proplist.clear();
            this.partialMatches.clear();
            this.lastTime = now;
            this.nextTime = now + (long)this.interval;
        }
    }

    protected void removeFromPartialMatches(Index index) {
        Collection c = this.partialMatches.values();
        for (Index pindex : c) {
            if (!pindex.partialMatch(index)) continue;
            this.partialMatches.remove(pindex);
        }
    }

    protected void removeFromPartialMatches(Fact fact) {
        Collection c = this.partialMatches.values();
        for (Index pindex : c) {
            if (!pindex.partialMatch(fact)) continue;
            this.partialMatches.remove(pindex);
        }
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TemporalIntervalNode-" + this.nodeID + "> ");
        buf.append("interval " + this.interval / 1000 + " s, ");
        buf.append("left=" + this.leftElapsedTime / 1000 + " s, right=" + this.rightElapsedTime / 1000 + " s - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TemporalIntervalNode-" + this.nodeID + "> ");
        buf.append("interval " + this.interval + " ms, ");
        buf.append("left=" + this.leftElapsedTime + " ms, right=" + this.rightElapsedTime + " ms - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
        this.params = new Parameter[2];
        ValueParam p2 = new ValueParam();
        this.params[0] = this.p1;
        this.params[1] = p2;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public BigDecimal getCount() {
        return this.count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
        this.p1.setValue(this.count);
    }
}

