/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.AbstractTemporalNode;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TemporalHashedAlphaMem;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.util.NodeUtils;

public class TemporalEqNode
extends AbstractTemporalNode {
    private static final long serialVersionUID = 1L;

    public TemporalEqNode(int id) {
        super(id);
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        long time = this.getRightTime();
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.put(linx, linx);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        Iterator itr = rightmem.iterator(inx);
        if (itr != null) {
            try {
                while (itr.hasNext()) {
                    Fact vl = (Fact)itr.next();
                    if (vl == null) continue;
                    if (vl.timeStamp() > time) {
                        this.propogateAssert(linx.add(vl), engine, mem);
                        continue;
                    }
                    rightmem.removePartialMatch(inx, vl);
                    this.propogateRetract(linx.add(vl), engine, mem);
                }
            }
            catch (RetractException retractException) {
                // empty catch block
            }
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        long time = this.getLeftTime();
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        rightmem.addPartialMatch(inx, rfact, engine);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        Iterator itr = leftmem.values().iterator();
        try {
            while (itr.hasNext()) {
                Index linx = (Index)itr.next();
                if (this.evaluate(linx.getFacts(), rfact, time)) {
                    this.propogateAssert(linx.add(rfact), engine, mem);
                    continue;
                }
                this.propogateRetract(linx.add(rfact), engine, mem);
            }
        }
        catch (RetractException retractException) {
            // empty catch block
        }
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.remove(linx);
        EqHashIndex eqinx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        Iterator itr = rightmem.iterator(eqinx);
        if (itr != null) {
            while (itr.hasNext()) {
                this.propogateRetract(linx.add((Fact)itr.next()), engine, mem);
            }
        }
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        long time = this.getLeftTime();
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        TemporalHashedAlphaMem rightmem = (TemporalHashedAlphaMem)mem.getBetaRightMemory(this);
        rightmem.removePartialMatch(inx, rfact);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact, time)) continue;
            this.propogateRetract(linx.add(rfact), engine, mem);
        }
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TemporalEqNode-" + this.nodeID + "> ");
        buf.append("left=" + this.leftElapsedTime / 1000 + " s, right=" + this.rightElapsedTime / 1000 + " s - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TemporalEqNode-" + this.nodeID + "> ");
        buf.append("left=" + this.leftElapsedTime / 1000 + " s, right=" + this.rightElapsedTime / 1000 + " s - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }
}

