/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.TemporalFact;

public class TemporalDeffact
extends Deffact
implements TemporalFact {
    private static final long serialVersionUID = 1L;
    protected long effectiveTime = 0L;
    protected long expirationTime = 0L;
    protected String sourceURL = null;
    protected String serviceType = null;
    protected int validity;

    public TemporalDeffact(Deftemplate template, Object instance, BaseSlot[] values, long id) {
        super(template, instance, values, id);
    }

    public long getEffectiveTime() {
        return this.effectiveTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getSource() {
        return this.sourceURL;
    }

    public int getValidity() {
        return this.validity;
    }

    public void setEffectiveTime(long time) {
        this.effectiveTime = time;
    }

    public void setExpirationTime(long time) {
        this.expirationTime = time;
    }

    public void setServiceType(String type) {
        this.serviceType = type;
    }

    public void setSource(String url) {
        this.sourceURL = url;
    }

    public void setValidity(int valid) {
        this.validity = valid;
    }

    public String toFactString() {
        StringBuffer buf = new StringBuffer();
        buf.append("f-" + this.id + " (" + this.deftemplate.getName());
        if (this.slots.length > 0) {
            buf.append(" ");
        }
        int idx = 0;
        while (idx < this.slots.length) {
            buf.append("(" + this.slots[idx].getName() + " " + ConversionUtils.formatSlot(this.slots[idx].value) + ") ");
            ++idx;
        }
        buf.append("(effective-time " + this.effectiveTime + ")");
        buf.append("(expiration-time " + this.expirationTime + ")");
        buf.append("(service-type " + this.serviceType + ")");
        buf.append("(source " + this.sourceURL + ")");
        buf.append("(validity " + this.validity + ")");
        buf.append(")");
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.deftemplate.getName());
        if (this.slots.length > 0) {
            buf.append(" ");
        }
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].value instanceof BoundParam) {
                BoundParam bp = (BoundParam)this.slots[idx].value;
                buf.append("(" + this.slots[idx].getName() + " ?" + bp.getVariableName() + ") ");
            } else {
                buf.append("(" + this.slots[idx].getName() + " " + ConversionUtils.formatSlot(this.slots[idx].value) + ") ");
            }
            ++idx;
        }
        buf.append("(effective-time " + this.effectiveTime + ")");
        buf.append("(expiration-time " + this.expirationTime + ")");
        buf.append("(service-type " + this.serviceType + ")");
        buf.append("(source " + this.sourceURL + ")");
        buf.append("(validity " + this.validity + ") ");
        buf.append(")");
        return buf.toString();
    }
}

