/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.ArrayList;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.MessageRouter;
import org.jamocha.messagerouter.StreamChannel;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Rete;

public class Shell {
    public static final String CHANNELNAME = "Shell";
    private MessageRouter router;
    private StreamChannel channel;

    public Shell(Rete engine) {
        this.router = engine.getMessageRouter();
        this.channel = this.router.openChannel(CHANNELNAME, System.in);
        engine.getMessageRouter().setCurrentChannelId(this.channel.getChannelId());
    }

    public void run() {
        ArrayList<MessageEvent> msgEvents = new ArrayList<MessageEvent>();
        boolean printPrompt = false;
        System.out.println(Constants.PROJECT_MESSAGE);
        System.out.println(Constants.SHELL_MESSAGE);
        System.out.print(Constants.SHELL_PROMPT);
        while (true) {
            this.channel.fillEventList(msgEvents);
            if (!msgEvents.isEmpty()) {
                for (MessageEvent event : msgEvents) {
                    if (event.getType() == 2 || event.getType() == -1 || event.getType() == 102) {
                        printPrompt = true;
                    }
                    if (event.getType() == -1) {
                        System.out.println(this.exceptionToString((Exception)event.getMessage()).trim());
                    }
                    if (event.getType() == 101 || event.getMessage().toString().equals("")) continue;
                    System.out.print(event.getMessage().toString());
                }
                msgEvents.clear();
                if (printPrompt) {
                    System.out.print(Constants.SHELL_PROMPT);
                }
                printPrompt = false;
                continue;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private String exceptionToString(Exception exception) {
        StringBuilder res = new StringBuilder();
        StackTraceElement[] str = exception.getStackTrace();
        int i = 0;
        while (i < str.length) {
            res.append(str[i] + System.getProperty("line.separator"));
            ++i;
        }
        return res.toString();
    }
}

