/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.util.Map;
import org.jamocha.rete.Fact;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Template;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.query.QueryRootNode;

public class RootNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map inputNodes = null;

    public RootNode(Rete engine) {
        this.inputNodes = engine.newMap();
    }

    public void addObjectTypeNode(ObjectTypeNode node) {
        if (!this.inputNodes.containsKey(node.getDeftemplate())) {
            this.inputNodes.put(node.getDeftemplate(), node);
        }
    }

    public void removeObjectTypeNode(ObjectTypeNode node) {
        this.inputNodes.remove(node.getDeftemplate());
    }

    public Map getObjectTypeNodes() {
        return this.inputNodes;
    }

    public synchronized void assertObject(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        ObjectTypeNode otn = (ObjectTypeNode)this.inputNodes.get(fact.getDeftemplate());
        if (otn != null) {
            otn.assertFact(fact, engine, mem);
        }
        if (fact.getDeftemplate().getParent() != null) {
            this.assertObjectParent(fact, fact.getDeftemplate().getParent(), engine, mem);
        }
    }

    public synchronized void assertObjectParent(Fact fact, Template template, Rete engine, WorkingMemory mem) throws AssertException {
        ObjectTypeNode otn = (ObjectTypeNode)this.inputNodes.get(template);
        if (otn != null) {
            otn.assertFact(fact, engine, mem);
        }
        if (template.getParent() != null) {
            this.assertObjectParent(fact, template.getParent(), engine, mem);
        }
    }

    public synchronized void retractObject(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        ObjectTypeNode otn = (ObjectTypeNode)this.inputNodes.get(fact.getDeftemplate());
        if (otn != null) {
            otn.retractFact(fact, engine, mem);
        }
        if (fact.getDeftemplate().getParent() != null) {
            this.retractObjectParent(fact, fact.getDeftemplate().getParent(), engine, mem);
        }
    }

    public synchronized void retractObjectParent(Fact fact, Template template, Rete engine, WorkingMemory mem) throws RetractException {
        ObjectTypeNode otn = (ObjectTypeNode)this.inputNodes.get(template);
        if (otn != null) {
            otn.retractFact(fact, engine, mem);
        }
        if (template.getParent() != null) {
            this.retractObjectParent(fact, template.getParent(), engine, mem);
        }
    }

    public synchronized void clear() {
        for (ObjectTypeNode otn : this.inputNodes.values()) {
            otn.clearSuccessors();
        }
        this.inputNodes.clear();
    }

    public QueryRootNode createQueryRoot(Rete engine) {
        QueryRootNode queryRoot = new QueryRootNode(engine, this);
        for (ObjectTypeNode otn : this.inputNodes.values()) {
            queryRoot.addQueryObjTypeNode(otn.createQueryObjTypeNode(engine));
        }
        return queryRoot;
    }
}

