/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.MessageRouter;
import org.jamocha.rete.Activation;
import org.jamocha.rete.ActivationList;
import org.jamocha.rete.Agenda;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.CompileEvent;
import org.jamocha.rete.CompilerListener;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Cube;
import org.jamocha.rete.DefaultQueryCompiler;
import org.jamocha.rete.DefaultRuleCompiler;
import org.jamocha.rete.DefaultWM;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.DefglobalMap;
import org.jamocha.rete.Defmodule;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.EngineEventListener;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionGroup;
import org.jamocha.rete.InitialFact;
import org.jamocha.rete.Module;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.RootNode;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Scope;
import org.jamocha.rete.Strategy;
import org.jamocha.rete.Template;
import org.jamocha.rete.TemporalFact;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.ExecuteException;
import org.jamocha.rete.exception.FunctionException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.exception.TemplateAssociationException;
import org.jamocha.rete.functions.BooleanFunctions;
import org.jamocha.rete.functions.DeffunctionGroup;
import org.jamocha.rete.functions.IfFunction;
import org.jamocha.rete.functions.InterpretedFunction;
import org.jamocha.rete.functions.LoadFunctionsFunction;
import org.jamocha.rete.functions.RuleEngineFunctions;
import org.jamocha.rete.functions.UserDefinedFunctions;
import org.jamocha.rete.functions.agent.AgentFunctions;
import org.jamocha.rete.functions.analysis.AnalysisFunctions;
import org.jamocha.rete.functions.bit.BitFunctions;
import org.jamocha.rete.functions.cube.CubeFunctions;
import org.jamocha.rete.functions.io.BatchFunction;
import org.jamocha.rete.functions.io.IOFunctions;
import org.jamocha.rete.functions.java.JavaFunctions;
import org.jamocha.rete.functions.list.ListFunctions;
import org.jamocha.rete.functions.macro.MacroFunctions;
import org.jamocha.rete.functions.math.MathFunctions;
import org.jamocha.rete.functions.memory.MemoryFunctions;
import org.jamocha.rete.functions.messaging.MessagingFunctions;
import org.jamocha.rete.functions.query.QueryFunctions;
import org.jamocha.rete.functions.string.StringFunctions;
import org.jamocha.rete.functions.temporal.TemporalFunctions;
import org.jamocha.rete.functions.time.TimeFunctions;
import org.jamocha.rete.measures.AggregateGroup;
import org.jamocha.rete.measures.Measure;
import org.jamocha.rete.measures.MeasureGroup;
import org.jamocha.rete.util.FactUtils;
import org.jamocha.rete.util.ProfileStats;
import org.jamocha.rule.Defquery;
import org.jamocha.rule.Query;
import org.jamocha.rule.Rule;

public class Rete
implements PropertyChangeListener,
CompilerListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int WATCH_ACTIVATIONS = 1;
    public static final int WATCH_ALL = 2;
    public static final int WATCH_FACTS = 3;
    public static final int WATCH_RULES = 4;
    public static final int PROFILE_ADD_ACTIVATION = 101;
    public static final int PROFILE_ASSERT = 102;
    public static final int PROFILE_ALL = 103;
    public static final int PROFILE_FIRE = 104;
    public static final int PROFILE_RETRACT = 105;
    public static final int PROFILE_RM_ACTIVATION = 106;
    protected boolean halt = true;
    protected int firingcount = 0;
    protected boolean prettyPrint = false;
    protected WorkingMemory workingMem = null;
    protected Map defclass = new HashMap();
    protected Map defclassByName = new HashMap();
    protected Map templateToDefclass = new HashMap();
    protected Map classToTemplate = new HashMap();
    protected Map functions = new HashMap();
    protected Map measures = new HashMap();
    protected Map outputStreams = new HashMap();
    protected ArrayList listeners = new ArrayList();
    private ArrayList functionGroups = new ArrayList();
    private ArrayList measureGroups = new ArrayList();
    private long lastFactId = 1L;
    private int lastNodeId = 0;
    private InterpretedFunction intrFunction = null;
    private Logger log = null;
    private MessageRouter router = new MessageRouter(this);
    protected Deftemplate initFact = new InitialFact();
    private DeffunctionGroup deffunctions = new DeffunctionGroup();
    private RootNode root = new RootNode(this);
    private RuleCompiler compiler = null;
    private Map rulesFired = new HashMap();
    private QueryCompiler queryCompiler = null;
    private Map queries = new HashMap();

    public Rete() {
        this.log = LogFactory.createLogger(Rete.class);
        this.compiler = new DefaultRuleCompiler(this, this.root.getObjectTypeNodes());
        this.queryCompiler = new DefaultQueryCompiler(this, this.root.getObjectTypeNodes());
        this.workingMem = new DefaultWM(this, this.root, this.compiler);
        this.init();
        this.startLog();
    }

    public Rete(Logger logger) {
        this.log = logger;
        this.compiler = new DefaultRuleCompiler(this, this.root.getObjectTypeNodes());
        this.workingMem = new DefaultWM(this, this.root, this.compiler);
        this.init();
        this.startLog();
    }

    protected void init() {
        this.loadBuiltInFunctions();
        this.loadBuiltInMeasures();
        this.declareInitialFact();
        this.compiler.addListener(this);
    }

    protected void loadBuiltInFunctions() {
        AgentFunctions agentfuncs = new AgentFunctions();
        this.declareFunctionGroup(agentfuncs);
        AnalysisFunctions analysis = new AnalysisFunctions();
        this.declareFunctionGroup(analysis);
        BitFunctions bitfs = new BitFunctions();
        this.declareFunctionGroup(bitfs);
        BooleanFunctions boolfs = new BooleanFunctions();
        this.declareFunctionGroup(boolfs);
        CubeFunctions cubefunctions = new CubeFunctions();
        this.declareFunctionGroup(cubefunctions);
        IOFunctions iof = new IOFunctions();
        this.declareFunctionGroup(iof);
        ListFunctions listf = new ListFunctions();
        this.declareFunctionGroup(listf);
        JavaFunctions jfuncs = new JavaFunctions();
        this.declareFunctionGroup(jfuncs);
        MathFunctions mathf = new MathFunctions();
        this.declareFunctionGroup(mathf);
        MemoryFunctions memfuncs = new MemoryFunctions();
        this.declareFunctionGroup(memfuncs);
        MessagingFunctions msgfuncs = new MessagingFunctions();
        this.declareFunctionGroup(msgfuncs);
        RuleEngineFunctions rulefs = new RuleEngineFunctions();
        this.declareFunctionGroup(rulefs);
        QueryFunctions queryfs = new QueryFunctions();
        this.declareFunctionGroup(queryfs);
        StringFunctions strfs = new StringFunctions();
        this.declareFunctionGroup(strfs);
        TemporalFunctions tempfuncs = new TemporalFunctions();
        this.declareFunctionGroup(tempfuncs);
        TimeFunctions timefs = new TimeFunctions();
        this.declareFunctionGroup(timefs);
        MacroFunctions macros = new MacroFunctions();
        this.declareFunctionGroup(macros);
        this.declareFunction(new IfFunction());
        this.functionGroups.add(this.deffunctions);
        UserDefinedFunctions udfs = new UserDefinedFunctions();
        this.functionGroups.add(udfs);
        LoadFunctionsFunction lff = (LoadFunctionsFunction)this.functions.get("load-function");
        lff.setUserDefinedFunctions(udfs);
    }

    protected void loadBuiltInMeasures() {
        AggregateGroup aggrGrp = new AggregateGroup();
        aggrGrp.loadMeasures(this);
        this.measureGroups.add(aggrGrp);
    }

    protected void clearBuiltInFunctions() {
        this.functions.clear();
    }

    protected void clearBuiltInMeasures() {
        this.measureGroups.clear();
        this.measures.clear();
    }

    protected void startLog() {
        this.log.info("Morendo started");
    }

    protected void declareInitialFact() {
        this.declareTemplate(this.initFact);
        Deffact ifact = (Deffact)this.initFact.createFact(null, null, this.nextFactId());
        try {
            this.assertFact(ifact);
        }
        catch (AssertException e) {
            this.log.info(e);
        }
    }

    public void clearObjects() {
        this.workingMem.clearObjects();
    }

    public void clearFacts() {
        this.workingMem.clearFacts();
    }

    public synchronized void clearRules() {
        Collection modules = this.workingMem.getModules();
        for (Defmodule mod : modules) {
            mod.removeAllRules(this, this.workingMem);
        }
    }

    public void clearAll() {
        this.workingMem.getDynamicFacts().clear();
        this.workingMem.getStaticFacts().clear();
        this.workingMem.getDeffactMap().clear();
        this.workingMem.clear();
        this.clearDefclass();
        ProfileStats.reset();
        this.lastFactId = 1L;
        this.lastNodeId = 1;
        this.clearBuiltInFunctions();
        this.loadBuiltInFunctions();
        this.clearBuiltInMeasures();
        this.loadBuiltInMeasures();
        FactUtils.reset();
        this.declareInitialFact();
    }

    public void clearDefclass() {
        for (Defclass dclass : this.defclass.values()) {
            dclass.clear();
        }
        this.defclass.clear();
        this.defclassByName.clear();
    }

    public void close() {
        this.workingMem.clear();
        this.defclass.clear();
        this.workingMem.getDeffactMap().clear();
        this.workingMem.getDynamicFacts().clear();
        this.functions.clear();
        this.workingMem.getInitialFacts().clear();
        this.listeners.clear();
        this.workingMem.getStaticFacts().clear();
    }

    protected void addRuleFired(Rule r) {
        this.rulesFired.put(r, null);
    }

    public int fire(int count) throws ExecuteException {
        int counter = 0;
        if (this.workingMem.getCurrentFocus().getActivationCount() > 0) {
            Activation actv = null;
            if (this.workingMem.profileFire()) {
                ProfileStats.startFire();
            }
            while ((actv = this.workingMem.getCurrentFocus().nextActivation(this)) != null && counter < count) {
                try {
                    if (this.workingMem.watchRules()) {
                        this.writeMessage("==> fire: " + actv.toPPString() + "\r\n", "t");
                    }
                    this.pushScope(actv.getRule());
                    actv.executeActivation(this);
                    actv.clear();
                    this.popScope();
                    ++counter;
                    this.addRuleFired(actv.getRule());
                }
                catch (ExecuteException e) {
                    this.log.debug(e);
                    break;
                }
            }
            if (this.workingMem.profileFire()) {
                ProfileStats.endFire();
            }
        }
        return counter;
    }

    public int fire() {
        if (this.workingMem.getCurrentFocus().getActivationCount() > 0) {
            this.firingcount = 0;
            Activation actv = null;
            if (this.workingMem.profileFire()) {
                ProfileStats.startFire();
            }
            while ((actv = this.workingMem.getCurrentFocus().nextActivation(this)) != null) {
                try {
                    if (this.workingMem.watchRules()) {
                        this.writeMessage("==> fire: " + actv.toPPString() + "\r\n", "t");
                    }
                    this.pushScope(actv.getRule());
                    actv.executeActivation(this);
                    actv.clear();
                    this.popScope();
                    ++this.firingcount;
                    this.addRuleFired(actv.getRule());
                }
                catch (ExecuteException e) {
                    this.log.debug(e);
                }
            }
            if (this.workingMem.profileFire()) {
                ProfileStats.endFire();
            }
            return this.firingcount;
        }
        return 0;
    }

    protected void fireActivation(Activation act) {
        if (act != null) {
            if (this.workingMem.watchRules()) {
                this.writeMessage("==> fire: " + act.toPPString() + "\r\n", "t");
            }
            try {
                this.pushScope(act.getRule());
                act.executeActivation(this);
                act.clear();
                this.popScope();
                ++this.firingcount;
                this.addRuleFired(act.getRule());
            }
            catch (ExecuteException e) {
                this.log.debug(e);
            }
        }
    }

    public List getRulesFired() {
        ArrayList list = new ArrayList();
        list.addAll(this.rulesFired.keySet());
        return list;
    }

    public int getRulesFiredCount() {
        return this.firingcount;
    }

    public Module getCurrentFocus() {
        return this.workingMem.getCurrentFocus();
    }

    public boolean addModule(String name) {
        return this.workingMem.addModule(name) != null;
    }

    public Module addModule(String name, boolean setfocus) {
        Module mod = this.workingMem.addModule(name);
        if (setfocus) {
            this.workingMem.setCurrentModule(mod);
        }
        return mod;
    }

    public Module removeModule(String name) {
        return this.workingMem.removeModule(name);
    }

    public Module findModule(String name) {
        return this.workingMem.findModule(name);
    }

    public void addCube(Cube cube) {
        this.workingMem.addCube(cube);
    }

    public Cube getCube(String name) {
        return this.workingMem.getCube(name);
    }

    public Cube removeCube(String name) {
        return this.workingMem.removeCube(name);
    }

    public List getCubes() {
        return this.workingMem.getCubes();
    }

    public Function findFunction(String name) {
        return (Function)this.functions.get(name);
    }

    public Template findTemplate(String name) {
        Template tmpl = null;
        for (Object val : this.workingMem.getAgenda().modules.values()) {
            if (val != this.workingMem.getMain()) {
                tmpl = ((Defmodule)val).getTemplate(name);
            }
            if (tmpl != null) break;
        }
        if (tmpl == null) {
            tmpl = this.workingMem.getMain().getTemplate(name);
        }
        return tmpl;
    }

    public void declareObject(String className, String templateName, String parent) throws ClassNotFoundException {
        try {
            Class<?> clzz = Class.forName(className);
            this.declareObject(clzz, templateName, parent);
        }
        catch (ClassNotFoundException e) {
            this.log.debug(e);
            throw e;
        }
    }

    public void declareObject(Class obj) {
        this.declareObject(obj, null, null);
    }

    public void declareObject(Class obj, String templateName) {
        this.declareObject(obj, templateName, null);
    }

    public void declareObject(Class obj, String templateName, String parent) {
        if (!this.defclass.containsKey(obj)) {
            Defclass dclass = new Defclass(obj);
            this.defclassByName.put(obj.getName(), dclass);
            this.defclass.put(obj, dclass);
            if (templateName == null) {
                templateName = obj.getName();
            }
            this.templateToDefclass.put(templateName, dclass);
            if (!this.getCurrentFocus().containsTemplate(dclass)) {
                Template dtemp = null;
                if (parent != null) {
                    Template ptemp = this.workingMem.getCurrentFocus().findParentTemplate(parent);
                    if (ptemp != null) {
                        dtemp = dclass.createDeftemplate(templateName, ptemp);
                        dtemp.setParent(ptemp);
                    }
                } else {
                    dtemp = dclass.createDeftemplate(templateName);
                }
                this.classToTemplate.put(obj, dtemp);
                this.getCurrentFocus().addTemplate(dtemp, this, this.workingMem);
                this.writeMessage(String.valueOf(dtemp.getName()) + Constants.LINEBREAK, "t");
            }
        }
    }

    public boolean removeObjectType(Class clzz) {
        Template template = (Template)this.classToTemplate.get(clzz);
        if (template.getSlotsUsed() == 0) {
            this.defclass.remove(clzz);
            this.defclassByName.remove(clzz.getName());
            this.templateToDefclass.remove(clzz.getName());
            this.classToTemplate.remove(clzz);
            return true;
        }
        return false;
    }

    public void declareCube(Cube cube) {
        if (!this.defclass.containsKey(cube)) {
            Defclass dclass = new Defclass(cube.getClass());
            this.defclass.put(cube, dclass);
            this.templateToDefclass.put(cube.getName(), dclass);
            Template dtemp = dclass.createCubeTemplate(cube);
            this.classToTemplate.put(cube, dtemp);
            this.getCurrentFocus().addTemplate(dtemp, this, this.workingMem);
            this.writeMessage(String.valueOf(dtemp.getName()) + Constants.LINEBREAK, "t");
        }
    }

    public Deftemplate findDeftemplate(Class clazz) {
        Defclass dclass = (Defclass)this.defclass.get(clazz);
        if (dclass != null) {
            return (Deftemplate)this.classToTemplate.get(clazz);
        }
        return null;
    }

    public Defclass findDeclassByTemplate(String templateName) {
        return (Defclass)this.templateToDefclass.get(templateName);
    }

    public void addAssociation(Class clazz, Deftemplate template) throws TemplateAssociationException {
        if (this.defclass.containsKey(clazz)) {
            throw new TemplateAssociationException(String.valueOf(clazz.getName()) + " has already been declared. Cannot add association");
        }
        Defclass dclass = (Defclass)this.templateToDefclass.get(template.getName());
        this.defclass.put(clazz, dclass);
        this.classToTemplate.put(clazz, template);
    }

    public void addAssociation(Class clazz, String templateName) throws TemplateAssociationException {
        Defclass dclass = (Defclass)this.templateToDefclass.get(templateName);
        if (dclass == null) {
            throw new TemplateAssociationException(String.valueOf(templateName) + " not found. Cound not add association");
        }
        this.addAssociation(clazz, this.findDeftemplate(dclass.getClassObject()));
    }

    public Defclass findDefclass(Class clazz) {
        return (Defclass)this.defclass.get(clazz);
    }

    public Defclass findDefclassByTemplate(String templateName) {
        return (Defclass)this.templateToDefclass.get(templateName);
    }

    public Set getDefclasses() {
        return this.defclass.entrySet();
    }

    public Defclass findDefclass(Object key) {
        return (Defclass)this.defclass.get(key.getClass());
    }

    public Defclass findDefclassByName(String key) {
        return (Defclass)this.defclassByName.get(key);
    }

    public void declareTemplate(Template temp) {
        if (!this.getCurrentFocus().containsTemplate(temp.getName())) {
            this.getCurrentFocus().addTemplate(temp, this, this.workingMem);
        }
    }

    public void declareFunction(Function func) {
        this.functions.put(func.getName(), func);
        if (func instanceof InterpretedFunction) {
            this.deffunctions.addFunction(func);
        }
    }

    public void declareFunction(String alias, Function func) throws FunctionException {
        if (this.functions.containsKey(alias)) {
            throw new FunctionException(String.valueOf(alias) + " is already in use. Please use a different alias for the function.");
        }
        this.functions.put(alias, func);
    }

    public Function declareFunction(String name) throws ClassNotFoundException {
        try {
            Class<?> fclaz = Class.forName(name);
            Function func = (Function)fclaz.newInstance();
            this.declareFunction(func);
            return func;
        }
        catch (ClassNotFoundException e) {
            this.log.debug(e);
            throw e;
        }
        catch (IllegalAccessException e) {
            this.log.debug(e);
        }
        catch (InstantiationException e) {
            this.log.debug(e);
        }
        return null;
    }

    public void removeFunction(Function function) {
        this.functions.remove(function.getName());
    }

    public void declareFunctionGroup(String name) throws ClassNotFoundException {
        try {
            Class<?> fclaz = Class.forName(name);
            FunctionGroup group = (FunctionGroup)fclaz.newInstance();
            this.declareFunctionGroup(group);
        }
        catch (ClassNotFoundException e) {
            this.log.debug(e);
            throw e;
        }
        catch (IllegalAccessException e) {
            this.log.debug(e);
        }
        catch (InstantiationException e) {
            this.log.debug(e);
        }
    }

    public void declareFunctionGroup(FunctionGroup functionGroup) {
        functionGroup.loadFunctions(this);
        this.functionGroups.add(functionGroup);
    }

    public void removeFunctionGroup(FunctionGroup functionGroup) {
        for (Function func : functionGroup.listFunctions()) {
            this.functions.remove(func.getName());
        }
        this.functionGroups.remove(functionGroup);
    }

    public List getFunctionGroups() {
        return this.functionGroups;
    }

    public Collection getAllFunctions() {
        return this.functions.values();
    }

    public void declareDefquery(Query query) {
        if (!this.queries.containsKey(query.getName())) {
            this.queries.put(query.getName(), query);
        }
    }

    public Query getDefquery(String name) {
        return ((Defquery)this.queries.get(name)).clone(this);
    }

    public Query removeDefquery(String name) {
        return (Query)this.queries.remove(name);
    }

    public List getAllMeasures() {
        return new ArrayList(this.measures.values());
    }

    public Measure findMeasure(String name) {
        return (Measure)this.measures.get(name);
    }

    public void declareMeasure(Measure measure) {
        if (!this.measures.containsKey(measure.getMeasureName())) {
            this.measures.put(measure.getMeasureName(), measure);
        }
    }

    public void declareMeasureGroup(MeasureGroup measureGroup) {
        if (!this.measureGroups.contains(measureGroup)) {
            this.measureGroups.add(measureGroup);
            measureGroup.loadMeasures(this);
        }
    }

    public void loadRuleset(String filename) {
        BatchFunction bf = (BatchFunction)this.functions.get("batch");
        Parameter[] params = new Parameter[]{new ValueParam(11, filename)};
        bf.executeFunction(this, params);
    }

    public void loadRuleset(InputStream ins) {
        if (ins != null) {
            BatchFunction bf = (BatchFunction)this.functions.get("batch");
            bf.parse(this, ins, null);
        }
    }

    public RootNode getRootNode() {
        return this.root;
    }

    public void declareDefglobal(String name, Object value) {
        this.workingMem.getDefglobals().declareDefglobal(name, value);
    }

    public Object getDefglobalValue(String name) {
        return this.workingMem.getDefglobals().getValue(name);
    }

    public DefglobalMap getDefglobalMap() {
        return this.workingMem.getDefglobals();
    }

    public void removeDefglobal(String name) {
        this.workingMem.getDefglobals().removeDefglobal(name);
    }

    public void build(String text) {
        Function f = this.findFunction("build");
        ValueParam p = new ValueParam(11, text);
        Parameter[] params = new Parameter[]{p};
        f.executeFunction(this, params);
    }

    public Object getBinding(String name) {
        return this.workingMem.getBinding(name);
    }

    public void setBindingValue(String key, Object value) {
        this.workingMem.setBindingValue(key, value);
    }

    public void pushScope(Scope s) {
        this.workingMem.pushScope(s);
    }

    public void popScope() {
        this.workingMem.popScope();
    }

    public void setInterpretedFunction(InterpretedFunction f) {
        this.intrFunction = f;
    }

    public void setFocus(String moduleName) {
        Module mod = this.workingMem.findModule(moduleName);
        if (mod != null) {
            this.workingMem.setCurrentModule(mod);
        }
    }

    public void setWatch(int type) {
        if (type == 1) {
            this.workingMem.getAgenda().setWatch(true);
        } else if (type == 2) {
            this.workingMem.getAgenda().setWatch(true);
            this.workingMem.setWatchFact(true);
            this.workingMem.setWatchRules(true);
        } else if (type == 3) {
            this.workingMem.setWatchFact(true);
        } else if (type == 4) {
            this.workingMem.setWatchRules(true);
        }
    }

    public void setUnWatch(int type) {
        if (type == 1) {
            this.workingMem.getAgenda().setWatch(false);
        } else if (type == 2) {
            this.workingMem.getAgenda().setWatch(false);
            this.workingMem.setWatchFact(false);
            this.workingMem.setWatchRules(false);
        } else if (type == 3) {
            this.workingMem.setWatchFact(false);
        } else if (type == 4) {
            this.workingMem.setWatchRules(false);
        }
    }

    public void setWatchQuery(String name) {
        Query q = (Query)this.queries.get(name);
        if (q != null) {
            q.setWatch(true);
        }
    }

    public void setUnWatchQuery(String name) {
        Query q = (Query)this.queries.get(name);
        if (q != null) {
            q.setWatch(false);
        }
    }

    public void setQueryTime(String name, long time) {
        Query q = (Query)this.queries.get(name);
        if (q != null) {
            ((Defquery)q).setElapsedTime(time);
        }
    }

    public long getQueryTime(String name) {
        Query q = (Query)this.queries.get(name);
        if (q != null) {
            return ((Defquery)q).getElapsedTime();
        }
        return 0L;
    }

    public void setProfile(int type) {
        if (type == 101) {
            this.workingMem.getAgenda().setProfileAdd(true);
        } else if (type == 102) {
            this.workingMem.setProfileAssert(true);
        } else if (type == 103) {
            this.workingMem.getAgenda().setProfileAdd(true);
            this.workingMem.setProfileAssert(true);
            this.workingMem.setProfileFire(true);
            this.workingMem.setProfileRetract(true);
            this.workingMem.getAgenda().setProfileRemove(true);
        } else if (type == 104) {
            this.workingMem.setProfileFire(true);
        } else if (type == 105) {
            this.workingMem.setProfileRetract(true);
        } else if (type == 106) {
            this.workingMem.getAgenda().setProfileRemove(true);
        }
    }

    public void setProfileOff(int type) {
        if (type == 101) {
            this.workingMem.getAgenda().setProfileAdd(false);
        } else if (type == 102) {
            this.workingMem.setProfileAssert(false);
        } else if (type == 103) {
            this.workingMem.getAgenda().setProfileAdd(false);
            this.workingMem.setProfileAssert(false);
            this.workingMem.setProfileFire(false);
            this.workingMem.setProfileRetract(false);
            this.workingMem.getAgenda().setProfileRemove(false);
        } else if (type == 104) {
            this.workingMem.setProfileFire(false);
        } else if (type == 105) {
            this.workingMem.setProfileRetract(false);
        } else if (type == 106) {
            this.workingMem.getAgenda().setProfileRemove(false);
        }
    }

    public List getAllFacts() {
        return this.workingMem.getAllFacts();
    }

    public List getObjects() {
        return this.workingMem.getObjects();
    }

    public List getDeffacts() {
        return this.workingMem.getDeffacts();
    }

    public int getDeffactCount() {
        return this.workingMem.getDeffactMap().size();
    }

    public Fact getShadowFact(Object key) {
        Fact f = (Fact)this.workingMem.getDynamicFacts().get(key);
        if (f == null) {
            f = (Fact)this.workingMem.getStaticFacts().get(key);
        }
        return f;
    }

    public Fact getFactById(long id) {
        return this.workingMem.getFactById(id);
    }

    public void addPrintWriter(String name, Writer writer) {
        this.outputStreams.put(name, writer);
    }

    public PrintWriter removePrintWriter(String name) {
        return (PrintWriter)this.outputStreams.remove(name);
    }

    public void writeMessage(String msg) {
        this.writeMessage(msg, "t");
    }

    public void writeMessage(String msg, String output) {
        MessageRouter router = this.getMessageRouter();
        router.postMessageEvent(new MessageEvent(103, msg, "t".equals(output) ? router.getCurrentChannelId() : output));
        if (this.outputStreams.size() > 0) {
            for (PrintWriter wr : this.outputStreams.values()) {
                wr.write(msg);
                wr.flush();
            }
        }
    }

    public void writeMessage(BaseNode node) {
    }

    public void assertObject(Object data, String template, boolean statc, boolean shadow) throws AssertException {
        this.workingMem.assertObject(data, template, statc, shadow);
    }

    public void assertTemporalObject(Object data, String template, Date effective, Date expiration, boolean statc) throws AssertException {
        this.workingMem.assertTemporalObject(data, template, effective, expiration, statc);
    }

    public void assertObjects(List objs) throws AssertException {
        this.workingMem.assertObjects(objs);
    }

    public void retractObject(Object data) throws RetractException {
        this.workingMem.retractObject(data);
    }

    public void modifyObject(Object data) throws AssertException, RetractException {
        this.workingMem.modifyObject(data);
    }

    public void assertFact(Fact fact) throws AssertException {
        this.workingMem.assertFact(fact);
    }

    public void assertFact(TemporalFact fact, Date effectiveTime, Date expirationTime) throws AssertException {
        this.workingMem.assertFact(fact, effectiveTime, expirationTime);
    }

    public void retractById(long id) throws RetractException {
        Iterator itr = this.workingMem.getDeffactMap().values().iterator();
        Fact ft = null;
        while (itr.hasNext()) {
            Fact f = (Fact)itr.next();
            if (f.getFactId() != id) continue;
            ft = f;
            break;
        }
        if (ft != null) {
            this.retractFact(ft);
        }
    }

    public void retractFact(Fact fact) throws RetractException {
        this.workingMem.retractFact(fact);
    }

    public void modifyFact(Fact old, Fact newfact) throws RetractException, AssertException {
        this.retractFact(old);
        this.assertFact(newfact);
    }

    public void resetAll() {
        ProfileStats.reset();
        this.resetObjects();
        this.resetFacts();
    }

    public void resetObjects() {
        try {
            this.workingMem.getAgenda().startReset();
            for (Fact ft : this.workingMem.getStaticFacts().values()) {
                this.workingMem.retractFact(ft);
            }
            for (Fact ft : this.workingMem.getDynamicFacts().values()) {
                this.workingMem.retractFact(ft);
            }
            this.workingMem.getAgenda().endReset();
            for (Fact ft : this.workingMem.getStaticFacts().values()) {
                this.workingMem.assertFact(ft);
            }
            for (Fact ft : this.workingMem.getDynamicFacts().values()) {
                this.workingMem.assertFact(ft);
            }
        }
        catch (RetractException e) {
            this.log.debug(e);
        }
        catch (AssertException e) {
            this.log.debug(e);
        }
    }

    public void resetFacts() {
        try {
            this.workingMem.getAgenda().startReset();
            ArrayList facts = new ArrayList(this.workingMem.getDeffactMap().values());
            for (Fact ft : facts) {
                this.workingMem.retractFact(ft);
            }
            this.workingMem.getAgenda().endReset();
            for (Fact ft : facts) {
                this.workingMem.assertFact(ft);
            }
        }
        catch (RetractException e) {
            this.log.debug(e);
        }
        catch (AssertException e) {
            this.log.debug(e);
        }
    }

    public long nextFactId() {
        return this.lastFactId++;
    }

    public Agenda getAgenda() {
        return this.workingMem.getAgenda();
    }

    public int nextNodeId() {
        return ++this.lastNodeId;
    }

    public int peakNextNodeId() {
        return this.lastNodeId + 1;
    }

    public RuleCompiler getRuleCompiler() {
        return this.workingMem.getRuleCompiler();
    }

    public QueryCompiler getQueryCompiler() {
        return this.queryCompiler;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMem;
    }

    public Strategy getStrategy() {
        return this.workingMem.getStrategy();
    }

    public ActivationList getActivationList() {
        return this.workingMem.getCurrentFocus().getAllActivations();
    }

    public int getObjectCount() {
        return this.workingMem.getDynamicFacts().size() + this.workingMem.getStaticFacts().size();
    }

    public void setValidateRules(boolean val) {
        this.workingMem.getRuleCompiler().setValidateRule(val);
    }

    public boolean getValidateRules() {
        return this.workingMem.getRuleCompiler().getValidateRule();
    }

    public Map newMap() {
        return new HashMap();
    }

    public Map newLocalMap() {
        return new HashMap();
    }

    public Map newAlphaMemoryMap(String name) {
        return new HashMap();
    }

    public Map newLinkedHashmap(String name) {
        return new LinkedHashMap();
    }

    public Map newBetaMemoryMap(String name) {
        return new HashMap();
    }

    public Map newTerminalMap() {
        return new HashMap();
    }

    public Map newClusterableMap(String name) {
        return new HashMap();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        try {
            this.modifyObject(source);
        }
        catch (RetractException e) {
            this.log.debug(e);
        }
        catch (AssertException e) {
            this.log.debug(e);
        }
    }

    public void addEngineEventListener(EngineEventListener listen) {
        if (!this.listeners.contains(listen)) {
            this.listeners.add(listen);
        }
    }

    public void removeEngineEventListener(EngineEventListener listen) {
        this.listeners.remove(listen);
    }

    public void ruleAdded(CompileEvent event) {
        this.log.info("added: " + event.getMessage());
    }

    public void ruleRemoved(CompileEvent event) {
        this.log.info("removed: " + event.getMessage());
    }

    public void compileError(CompileEvent event) {
        this.log.warn(event.getMessage());
    }

    public MessageRouter getMessageRouter() {
        return this.router;
    }

    public Deftemplate getInitFact() {
        return this.initFact;
    }
}

