/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.AlphaNode;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.CompositeIndex;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Template;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.query.QueryObjTypeNode;

public class ObjectTypeNode
extends BaseAlpha
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Template deftemplate = null;
    private Map nodeHashMap = null;
    protected BaseNode[] nonHashNodes = new BaseNode[0];
    private boolean useNodeHash = false;
    public static final int[] operators = new int[]{9, 11};

    public ObjectTypeNode(int id, Template deftemp, Rete engine) {
        super(id);
        this.deftemplate = deftemp;
        this.nodeHashMap = engine.newLocalMap();
    }

    public Template getDeftemplate() {
        return this.deftemplate;
    }

    public void clear(WorkingMemory mem) {
        AlphaMemory am = (AlphaMemory)mem.getAlphaMemory(this);
        am.clear();
    }

    public void clearSuccessors() {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            this.successorNodes[idx].removeAllSuccessors();
            ++idx;
        }
        this.successorNodes = new BaseNode[0];
        this.nonHashNodes = new BaseNode[0];
        this.nodeHashMap.clear();
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        ((AlphaMemory)mem.getAlphaMemory(this)).addPartialMatch(fact);
        if (this.useNodeHash) {
            this.assertWithHash(fact, engine, mem);
        } else {
            this.assertAllSuccessors(fact, engine, mem);
        }
    }

    public void assertWithHash(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        BaseSlot[] slots = this.deftemplate.getAllSlots();
        int idx = 0;
        while (idx < slots.length) {
            if (slots[idx].getNodeCount() > 0) {
                CompositeIndex compIndex;
                BaseNode node;
                Object slotValue = fact.getSlotValue(idx);
                if (slotValue == null) {
                    slotValue = "nil";
                }
                if ((node = (BaseNode)this.nodeHashMap.get(compIndex = new CompositeIndex(slots[idx].getName(), 9, slotValue))) != null) {
                    if (node instanceof BaseAlpha) {
                        ((BaseAlpha)node).assertFact(fact, engine, mem);
                    } else if (node instanceof BaseJoin) {
                        ((BaseJoin)node).assertRight(fact, engine, mem);
                    } else if (node instanceof TerminalNode) {
                        Index inx = new Index(new Fact[]{fact});
                        ((TerminalNode)node).assertFacts(inx, engine, mem);
                    }
                }
            }
            ++idx;
        }
        idx = 0;
        while (idx < this.nonHashNodes.length) {
            BaseNode node = this.nonHashNodes[idx];
            if (node instanceof BaseAlpha) {
                ((BaseAlpha)node).assertFact(fact, engine, mem);
            } else if (node instanceof BaseJoin) {
                ((BaseJoin)node).assertRight(fact, engine, mem);
            } else if (node instanceof TerminalNode) {
                Index inx = new Index(new Fact[]{fact});
                ((TerminalNode)node).assertFacts(inx, engine, mem);
            }
            ++idx;
        }
    }

    public void assertAllSuccessors(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode node = this.successorNodes[idx];
            if (node instanceof BaseAlpha) {
                ((BaseAlpha)node).assertFact(fact, engine, mem);
            } else if (node instanceof BaseJoin) {
                ((BaseJoin)node).assertRight(fact, engine, mem);
            } else if (node instanceof TerminalNode) {
                Index inx = new Index(new Fact[]{fact});
                ((TerminalNode)node).assertFacts(inx, engine, mem);
            }
            ++idx;
        }
    }

    public void retractFact(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        if (fact.getDeftemplate() == this.deftemplate) {
            ((AlphaMemory)mem.getAlphaMemory(this)).removePartialMatch(fact);
            int idx = 0;
            while (idx < this.successorNodes.length) {
                BaseNode node = this.successorNodes[idx];
                if (node instanceof BaseAlpha) {
                    ((BaseAlpha)node).retractFact(fact, engine, mem);
                } else if (node instanceof BaseJoin) {
                    ((BaseJoin)node).retractRight(fact, engine, mem);
                }
                ++idx;
            }
        }
    }

    public int getSuccessorCount() {
        return this.successorNodes.length;
    }

    public int getStandardCostValue() {
        int cost = 0;
        cost = this.successorNodes.length;
        int idx = 0;
        while (idx < this.successorNodes.length) {
            cost = this.successorNodes[idx] instanceof BaseJoin ? (cost += 4) : ++cost;
            ++idx;
        }
        return cost;
    }

    public int getOptimizedCostValue() {
        if (this.useNodeHash) {
            int cost = 1;
            int idx = 0;
            while (idx < this.nonHashNodes.length) {
                cost = this.nonHashNodes[idx] instanceof BaseJoin ? (cost += 4) : ++cost;
                ++idx;
            }
            return cost;
        }
        return this.getStandardCostValue();
    }

    public void addSuccessorNode(BaseNode node, Rete engine, WorkingMemory mem) throws AssertException {
        AlphaMemory alpha;
        if (node instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)node;
            if (alphaNode.getOperator() == 9) {
                this.nodeHashMap.put(alphaNode.getHashIndex(), alphaNode);
                this.deftemplate.getSlot(alphaNode.slot.getId()).incrementNodeCount();
            }
        } else if (!this.containsNode(this.nonHashNodes, node)) {
            this.nonHashNodes = ConversionUtils.add(this.nonHashNodes, node);
        }
        if (!this.containsNode(this.successorNodes, node)) {
            this.addNode(node);
        }
        if (this.successorNodes.length > this.deftemplate.getSlotsUsed() * 2) {
            this.useNodeHash = true;
        }
        if ((alpha = (AlphaMemory)mem.getAlphaMemory(this)).size() > 0) {
            Iterator itr = alpha.iterator();
            while (itr.hasNext()) {
                BaseNode next;
                Fact f = (Fact)itr.next();
                if (node instanceof BaseAlpha) {
                    next = (BaseAlpha)node;
                    ((BaseAlpha)next).assertFact(f, engine, mem);
                    continue;
                }
                if (node instanceof BaseJoin) {
                    next = (BaseJoin)node;
                    ((BaseJoin)next).assertRight(f, engine, mem);
                    continue;
                }
                if (!(node instanceof TerminalNode)) continue;
                TerminalNode t = (TerminalNode)node;
                Index inx = new Index(new Fact[]{f});
                t.assertFacts(inx, engine, mem);
            }
        }
    }

    public boolean removeNode(BaseNode n) {
        boolean rem = super.removeNode(n);
        ConversionUtils.remove(this.nonHashNodes, n);
        if (n instanceof AlphaNode) {
            this.nodeHashMap.remove(((AlphaNode)n).getHashIndex());
        }
        return rem;
    }

    public String hashString() {
        return this.toString();
    }

    public String toString() {
        return "ObjectTypeNode( " + this.deftemplate.getName() + " ) -";
    }

    public String toPPString() {
        return " Template( " + this.deftemplate.getName() + " )";
    }

    public Object[] getSuccessorNodes() {
        return this.successorNodes;
    }

    public QueryObjTypeNode createQueryObjTypeNode(Rete engine) {
        QueryObjTypeNode clone = new QueryObjTypeNode(engine, this);
        clone.successorNodes = new BaseNode[0];
        clone.useCount = 0;
        return clone;
    }
}

