/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.BetaMemoryImpl;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class NotJoinFrst
extends BaseJoin {
    private static final long serialVersionUID = 1L;

    public NotJoinFrst(int id) {
        super(id);
    }

    public void clear(WorkingMemory mem) {
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        Map leftmem = (Map)mem.getBetaRightMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        BetaMemoryImpl bmem = new BetaMemoryImpl(linx, engine);
        leftmem.put(bmem.getIndex(), bmem);
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        int prevCount = bmem.matchCount();
        for (Fact rfcts : rightmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfcts, engine)) continue;
            bmem.addMatch(rfcts);
        }
        if (bmem.matchCount() == 0) {
            Index newIndex = new Index(new Fact[0]);
            this.propogateAssert(newIndex, engine, mem);
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        Index linx = new Index(new Fact[0]);
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        rightmem.put(rfact, rfact);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (BetaMemory bmem : leftmem.values()) {
            int prevCount = bmem.matchCount();
            if (this.evaluate(linx.getFacts(), rfact, engine)) {
                bmem.addMatch(rfact);
            }
            if (prevCount != 0 || bmem.matchCount() == 0) continue;
            linx = new Index(new Fact[0]);
            try {
                this.propogateRetract(linx, engine, mem);
            }
            catch (RetractException e) {
                throw new AssertException("NotJion - " + e.getMessage());
            }
        }
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        BetaMemory bmem = (BetaMemory)leftmem.remove(linx);
        if (bmem != null) {
            linx = new Index(new Fact[0]);
            this.propogateRetract(linx, engine, mem);
        }
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        Index linx = new Index(new Fact[0]);
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        if (rightmem.remove(rfact) != null) {
            Map leftmem = (Map)mem.getBetaLeftMemory(this);
            for (BetaMemory bmem : leftmem.values()) {
                int prevCount = bmem.matchCount();
                if (!bmem.matched(rfact)) continue;
                bmem.removeMatch(rfact);
                if (prevCount == 0 || bmem.matchCount() != 0) continue;
                try {
                    this.propogateAssert(new Index(new Fact[0]), engine, mem);
                }
                catch (AssertException e) {
                    throw new RetractException("NotJion - " + e.getMessage());
                }
            }
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right, Rete engine) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd instanceof Binding ? ((Binding2)bnd).evaluate(leftlist, right, engine) : bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public boolean evaluate(Fact left, int leftId, Fact right, int rightId, int opr) {
        if (opr == 10) {
            return Evaluate.evaluateNotEqual(left.getSlotValue(leftId), right.getSlotValue(rightId));
        }
        return Evaluate.evaluateEqual(left.getSlotValue(leftId), right.getSlotValue(rightId));
    }

    public void addSuccessorNode(TerminalNode node, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.addNode(node)) {
            Map leftmem = (Map)mem.getBetaLeftMemory(this);
            for (Object omem : leftmem.values()) {
                BetaMemory bmem;
                if (!(omem instanceof BetaMemory) || (bmem = (BetaMemory)omem).matchCount() != 0) continue;
                node.assertFacts(new Index(new Fact[0]), engine, mem);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NOT CE - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("node-" + this.nodeID + "> NOT CE - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toPPString());
            ++idx;
        }
        return buf.toString();
    }
}

