/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import org.jamocha.rete.BindValue;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.HashIndex;

public class NotEqHashIndex
implements HashIndex,
Serializable {
    private static final long serialVersionUID = 1L;
    private BindValue[] values = null;
    private int eqhashCode;
    private EqHashIndex negindex;

    public NotEqHashIndex(BindValue[] thevalues) {
        this.values = thevalues;
        this.calculateHash();
    }

    private void calculateHash() {
        Object[] neg = new Object[this.values.length];
        int z = 0;
        if (this.values != null && this.values.length > 0) {
            int idx = 0;
            while (idx < this.values.length) {
                if (this.values[idx] != null && !this.values[idx].negated()) {
                    this.eqhashCode += this.values[idx].getValue().hashCode();
                } else {
                    neg[z] = this.values[idx].getValue();
                    ++z;
                }
                ++idx;
            }
        }
        Object[] neg2 = new Object[z];
        System.arraycopy(neg, 0, neg2, 0, z);
        this.negindex = new EqHashIndex(neg2);
        neg = null;
        neg2 = null;
    }

    public void clear() {
        this.negindex.clear();
        this.values = null;
    }

    public EqHashIndex getSubIndex() {
        return this.negindex;
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        if (val == null || !(val instanceof NotEqHashIndex)) {
            return false;
        }
        NotEqHashIndex eval = (NotEqHashIndex)val;
        boolean eq = true;
        int idx = 0;
        while (idx < this.values.length) {
            if (!this.values[idx].negated() && !eval.values[idx].getValue().equals(this.values[idx].getValue())) {
                eq = false;
                break;
            }
            ++idx;
        }
        return eq;
    }

    public int hashCode() {
        return this.eqhashCode;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NotEqHashIndex2: ");
        buf.append(this.negindex.toPPString());
        return buf.toString();
    }
}

