/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BetaMemoryImpl;
import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam;
import org.jamocha.rete.Index;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.functions.ShellFunction;

public class NTestNode
extends BaseJoin {
    private static final long serialVersionUID = 1L;
    protected Function func = null;
    protected Parameter[] params = null;
    private String ppstring = null;

    public NTestNode(int id, Function func, Parameter[] parameters) {
        super(id);
        this.func = func;
        this.params = parameters;
    }

    public void lookUpFunction(Rete engine) {
        if (this.func instanceof ShellFunction) {
            ShellFunction sf = (ShellFunction)this.func;
            sf.lookUpFunction(engine);
            if (sf.getFunction() != null) {
                this.func = sf.getFunction();
            }
        }
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        if (!leftmem.containsKey(linx)) {
            this.setParameters(linx.getFacts());
            ReturnVector rv = this.func.executeFunction(engine, this.params);
            if (!rv.firstReturnValue().getBooleanValue()) {
                BetaMemoryImpl bmem = new BetaMemoryImpl(linx, engine);
                leftmem.put(bmem.getIndex(), bmem);
            }
            if (leftmem.size() == 0) {
                this.propogateAssert(linx, engine, mem);
            }
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) {
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        int prev = leftmem.size();
        if (leftmem.containsKey(linx)) {
            leftmem.remove(linx);
        }
        if (prev != 0 && leftmem.size() == 0) {
            this.propogateRetract(linx, engine, mem);
        }
    }

    public void setBindings(Binding[] binds) {
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) {
    }

    public void clear(WorkingMemory mem) {
        ((Map)mem.getBetaLeftMemory(this)).clear();
    }

    protected void setParameters(Fact[] facts) {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx] instanceof BoundParam) {
                ((BoundParam)this.params[idx]).setFact(facts);
            } else if (this.params[idx] instanceof FunctionParam) {
                ((FunctionParam)this.params[idx]).setFacts(facts);
            }
            ++idx;
        }
    }

    public String toString() {
        return "(test (" + this.func.getName() + ") )";
    }

    public String toPPString() {
        if (this.ppstring == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("TestNode-" + this.nodeID + "> (test (" + this.func.getName());
            int idx = 0;
            while (idx < this.params.length) {
                if (this.params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)this.params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (this.params[idx] instanceof ValueParam) {
                    ValueParam vp = (ValueParam)this.params[idx];
                    buf.append(" " + vp.getStringValue());
                }
                ++idx;
            }
            buf.append(") )");
            this.ppstring = buf.toString();
        }
        return this.ppstring;
    }
}

