/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.EqualityIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;

public class NSFact
implements Fact,
Serializable {
    private Deftemplate deftemplate = null;
    private Defclass dclazz = null;
    private Object objInstance;
    private Slot[] slots = null;
    private long id;
    private long timeStamp = 0L;

    public NSFact(Deftemplate template, Defclass clazz, Object instance, Slot[] values, long id) {
        this.deftemplate = template;
        this.dclazz = clazz;
        this.objInstance = instance;
        this.slots = values;
        this.id = id;
        this.timeStamp = System.currentTimeMillis();
    }

    public Object getSlotValue(int id) {
        return this.dclazz.getSlotValue(id, this.objInstance);
    }

    public int getSlotId(String name) {
        int col = -1;
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getName().equals(name)) {
                col = idx;
                break;
            }
            ++idx;
        }
        return col;
    }

    public Object getObjectInstance() {
        return this.objInstance;
    }

    public String toFactString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.deftemplate.getName() + " ");
        int idx = 0;
        while (idx < this.slots.length) {
            buf.append("(" + this.slots[idx].getName() + " ");
            Object value = this.dclazz.getSlotValue(idx, this.objInstance);
            if (value != null) {
                buf.append(value.toString());
            } else {
                buf.append("NIL");
            }
            buf.append(") ");
            ++idx;
        }
        buf.append(")");
        return buf.toString();
    }

    public long getFactId() {
        return this.id;
    }

    public void updateSlots(Rete engine, BaseSlot[] updates) {
    }

    public Deftemplate getDeftemplate() {
        return this.deftemplate;
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    public void clear() {
        this.slots = null;
        this.objInstance = null;
        this.deftemplate = null;
        this.id = 0L;
    }

    public EqualityIndex equalityIndex() {
        return null;
    }

    public int slotHash() {
        return this.objInstance.hashCode();
    }

    public void resetID(Fact fact) {
        this.id = fact.getFactId();
    }

    public void setFactId(Rete engine) {
        if (this.id == -1L) {
            this.id = engine.nextFactId();
        }
    }

    public boolean slotEquals(Fact fact) {
        if (fact instanceof NSFact) {
            return ((NSFact)fact).objInstance == this.objInstance;
        }
        return false;
    }
}

