/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Map;
import org.jamocha.rete.Index;
import org.jamocha.rete.LinkedActivation;
import org.jamocha.rete.ModificationActivation;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TerminalNode2;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rule.Rule;

public class MLTerminalNode
extends TerminalNode2 {
    private static final long serialVersionUID = 1L;
    private boolean noAgenda = false;

    public MLTerminalNode(int id, Rule rl) {
        super(id, rl);
        this.theRule = rl;
    }

    public void assertFacts(Index inx, Rete engine, WorkingMemory mem) {
        long time = System.currentTimeMillis();
        boolean add = true;
        if (this.theRule.getEffectiveDate() > 0L && this.theRule.getExpirationDate() > 0L && (time < this.theRule.getEffectiveDate() || time > this.theRule.getExpirationDate())) {
            add = false;
        }
        if (add) {
            LinkedActivation act = new LinkedActivation(this.theRule, inx);
            if (!this.noAgenda) {
                act.setTerminalNode(this);
                Map tmem = (Map)mem.getTerminalMemory(this);
                tmem.put(act.getIndex(), act);
                engine.getAgenda().addActivation(act);
            } else {
                engine.fireActivation(act);
            }
        }
    }

    public void retractFacts(Index inx, Rete engine, WorkingMemory mem) {
        long time = System.currentTimeMillis();
        Map tmem = (Map)mem.getTerminalMemory(this);
        LinkedActivation act = (LinkedActivation)tmem.remove(inx);
        if (act != null) {
            engine.getAgenda().removeActivation(act);
        } else {
            ModificationActivation modact = new ModificationActivation(this.theRule, inx);
            modact.setTerminalNode(this);
            tmem.put(modact.getIndex(), modact);
            engine.getAgenda().addActivation(modact);
        }
    }

    public void setNoAgenda(boolean noAgenda) {
        this.noAgenda = noAgenda;
    }

    public boolean getNoAgenda() {
        return this.noAgenda;
    }
}

