/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AbstractActivationList;
import org.jamocha.rete.Activation;
import org.jamocha.rete.ActivationList;
import org.jamocha.rete.LinkedActivation;

public class LinkedActivationList
extends AbstractActivationList {
    private static final long serialVersionUID = 1L;
    private int count = 0;
    private LinkedActivation first = null;
    private LinkedActivation last = null;

    public Activation nextActivation() {
        if (this.lazy) {
            if (this.count == 0) {
                return null;
            }
            LinkedActivation left = this.last;
            LinkedActivation right = this.last.getPrevious();
            while (right != null) {
                if (this.stratey.compare(left, right) < 1) {
                    left = right;
                }
                right = right.getPrevious();
            }
            if (left == this.first) {
                this.first = left.getNext();
            } else if (left == this.last) {
                this.last = left.getPrevious();
            }
            left.remove();
            --this.count;
            return left;
        }
        if (this.count > 1) {
            LinkedActivation r = this.last;
            this.last = r.getPrevious();
            --this.count;
            r.remove();
            return r;
        }
        if (this.count == 1) {
            LinkedActivation r = this.last;
            this.last = null;
            this.first = null;
            --this.count;
            return r;
        }
        return null;
    }

    public void addActivation(Activation act) {
        if (act instanceof LinkedActivation) {
            LinkedActivation newact = (LinkedActivation)act;
            if (this.lazy) {
                if (this.count == 0) {
                    this.first = newact;
                    this.last = newact;
                } else {
                    this.last.setNext(newact);
                    this.last = newact;
                }
                ++this.count;
            } else {
                if (this.count > 0) {
                    this.quickSort(newact);
                } else if (this.count == 0) {
                    this.first = newact;
                    this.last = newact;
                }
                ++this.count;
            }
        }
    }

    public void quickSort(LinkedActivation newact) {
        if (this.stratey.compare(newact, this.last) >= 0) {
            this.last.setNext(newact);
            this.last = newact;
        } else if (this.stratey.compare(newact, this.first) < 0) {
            newact.setNext(this.first);
            this.first = newact;
        } else {
            int counter = this.count / 2;
            LinkedActivation cur = this.goUp(counter, this.last);
            boolean added = false;
            while (!added) {
                if (counter <= 1) {
                    if (this.stratey.compare(newact, cur) < 0) {
                        newact.setPrevious(cur.getPrevious());
                        newact.setNext(cur);
                    } else {
                        newact.setNext(cur.getNext());
                        newact.setPrevious(cur);
                    }
                    added = true;
                    continue;
                }
                cur = this.stratey.compare(newact, cur) >= 0 ? this.goDown(counter /= 2, cur) : this.goUp(counter /= 2, cur);
            }
        }
    }

    protected LinkedActivation goUp(int count, LinkedActivation start) {
        LinkedActivation rt = start;
        int idx = 0;
        while (idx < count) {
            rt = rt.getPrevious();
            ++idx;
        }
        return rt;
    }

    protected LinkedActivation goDown(int count, LinkedActivation start) {
        LinkedActivation rt = start;
        int idx = 0;
        while (idx < count) {
            rt = rt.getNext();
            ++idx;
        }
        return rt;
    }

    public Activation removeActivation(Activation act) {
        if (act instanceof LinkedActivation) {
            LinkedActivation lact = (LinkedActivation)act;
            if (this.first == lact) {
                this.first = lact.getNext();
            }
            if (this.last == lact) {
                this.last = lact.getPrevious();
            }
            --this.count;
            lact.remove();
        }
        return act;
    }

    public boolean isAscendingOrder() {
        return true;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object o) {
        boolean contain = false;
        LinkedActivation act = this.first;
        while (act != null) {
            if (o == act) {
                contain = true;
                break;
            }
            act = act.getNext();
        }
        return contain;
    }

    public void clear() {
        while (this.first != null) {
            LinkedActivation la = this.first;
            this.first = la.getNext();
            la.remove();
        }
        this.last = null;
        this.count = 0;
    }

    public Object set(int index, Object activation) {
        if (index < this.count && activation != null) {
            LinkedActivation act = this.first;
            int idx = 0;
            while (idx <= this.count) {
                act = act.getNext();
                ++idx;
            }
            LinkedActivation pre = act.getPrevious();
            LinkedActivation nxt = act.getNext();
            pre.setNext((LinkedActivation)activation);
            nxt.setPrevious((LinkedActivation)activation);
            act.remove();
        }
        return activation;
    }

    public int indexOf(Object activation) {
        int index = -1;
        LinkedActivation la = this.first;
        LinkedActivation match = null;
        while (la != null) {
            ++index;
            if (la == activation) {
                match = la;
                break;
            }
            la = la.getNext();
        }
        if (match != null) {
            return index;
        }
        return -1;
    }

    public ActivationList clone() {
        LinkedActivationList la = new LinkedActivationList();
        la.count = this.count;
        la.first = this.first.clone();
        la.lazy = this.lazy;
        la.stratey = this.stratey;
        LinkedActivation current = this.first;
        LinkedActivation newcurr = la.first;
        while (current != null) {
            newcurr.setNext(current.getNext().clone());
            current = current.getNext();
            newcurr = newcurr.getNext();
        }
        return la;
    }
}

