/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.Activation;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TerminalNode2;
import org.jamocha.rete.exception.ExecuteException;
import org.jamocha.rule.Action;
import org.jamocha.rule.Rule;

public class LinkedActivation
implements Activation {
    private static final long serialVersionUID = 1L;
    private LinkedActivation prev = null;
    private LinkedActivation next = null;
    private Rule theRule;
    private Index index;
    private long aggreTime = -1L;
    private TerminalNode2 tnode = null;

    public LinkedActivation(Rule rule, Index inx) {
        this.theRule = rule;
        this.index = inx;
    }

    protected void calculateTime(Fact[] facts) {
        int idx = 0;
        while (idx < facts.length) {
            this.aggreTime += facts[idx].timeStamp() + facts[idx].getFactId();
            ++idx;
        }
    }

    public long getAggregateTime() {
        if (this.aggreTime == -1L) {
            this.calculateTime(this.index.getFacts());
        }
        return this.aggreTime;
    }

    public Fact[] getFacts() {
        return this.index.getFacts();
    }

    public Index getIndex() {
        return this.index;
    }

    public Rule getRule() {
        return this.theRule;
    }

    public void setPrevious(LinkedActivation previous) {
        this.prev = previous;
        if (previous != null) {
            previous.next = this;
        }
    }

    public LinkedActivation getPrevious() {
        return this.prev;
    }

    public void setNext(LinkedActivation next) {
        this.next = next;
        if (next != null) {
            next.prev = this;
        }
    }

    public LinkedActivation getNext() {
        return this.next;
    }

    public void setTerminalNode(TerminalNode2 node) {
        this.tnode = node;
    }

    public TerminalNode2 getTerminalNode() {
        return this.tnode;
    }

    public boolean compare(Activation act) {
        if (act == this) {
            return true;
        }
        return act.getRule() == this.theRule && act.getIndex().equals(this.index);
    }

    public void remove() {
        if (this.prev != null && this.next != null) {
            this.prev.setNext(this.next);
        } else if (this.prev != null && this.next == null) {
            this.prev.setNext(null);
        } else if (this.prev == null && this.next != null) {
            this.next.setPrevious(null);
        }
        this.prev = null;
        this.next = null;
    }

    protected void remove(Rete engine) {
        if (this.tnode != null) {
            this.tnode.removeActivation(engine.getWorkingMemory(), this);
        }
    }

    public void executeActivation(Rete engine) throws ExecuteException {
        this.remove(engine);
        this.theRule.setTriggerFacts(this.index.getFacts());
        Action[] actions = this.theRule.getActions();
        int idx = 0;
        while (idx < actions.length) {
            if (actions[idx] == null) {
                throw new ExecuteException("Could not execute the action. The action was NULL");
            }
            actions[idx].executeAction(engine, this.index.getFacts());
            ++idx;
        }
    }

    public void clear() {
        this.theRule = null;
        this.tnode = null;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Activation: " + this.theRule.getName());
        Fact[] facts = this.index.getFacts();
        int idx = 0;
        while (idx < facts.length) {
            buf.append(", id-" + facts[idx].getFactId());
            ++idx;
        }
        buf.append(" AggrTime-" + this.aggreTime);
        return buf.toString();
    }

    public LinkedActivation clone() {
        LinkedActivation la = new LinkedActivation(this.theRule, this.index);
        return la;
    }
}

