/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class LIANode
extends BaseAlpha {
    private static final long serialVersionUID = 1L;

    public LIANode(int id) {
        super(id);
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        this.propogateAssert(fact, engine, mem);
    }

    protected void propogateAssert(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode nNode = this.successorNodes[idx];
            if (nNode instanceof BaseJoin) {
                BaseJoin next = (BaseJoin)nNode;
                Fact[] newf = new Fact[]{fact};
                next.assertLeft(new Index(newf), engine, mem);
            } else if (nNode instanceof TerminalNode) {
                Fact[] newf = new Fact[]{fact};
                TerminalNode tn = (TerminalNode)nNode;
                tn.assertFacts(new Index(newf), engine, mem);
            }
            ++idx;
        }
    }

    public void retractFact(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        this.propogateRetract(fact, engine, mem);
    }

    protected void propogateRetract(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            Fact[] newf;
            BaseNode next;
            BaseNode nNode = this.successorNodes[idx];
            if (nNode instanceof BaseJoin) {
                next = (BaseJoin)nNode;
                newf = new Fact[]{fact};
                ((BaseJoin)next).retractLeft(new Index(newf), engine, mem);
            } else if (nNode instanceof TerminalNode) {
                next = (TerminalNode)nNode;
                newf = new Fact[]{fact};
                ((TerminalNode)next).retractFacts(new Index(newf), engine, mem);
            }
            ++idx;
        }
    }

    public void addSuccessorNode(BaseNode node, Rete engine, WorkingMemory mem) throws AssertException {
        AlphaMemory alpha;
        if (this.addNode(node) && (alpha = (AlphaMemory)mem.getAlphaMemory(this)).size() > 0) {
            Iterator itr = alpha.iterator();
            while (itr.hasNext()) {
                BaseNode next;
                if (node instanceof BaseAlpha) {
                    next = (BaseAlpha)node;
                    ((BaseAlpha)next).assertFact((Fact)itr.next(), engine, mem);
                    continue;
                }
                if (!(node instanceof BaseJoin)) continue;
                next = (BaseJoin)node;
                Index inx = new Index(new Fact[]{(Fact)itr.next()});
                ((BaseJoin)next).assertLeft(inx, engine, mem);
            }
        }
    }

    public String hashString() {
        return this.toString();
    }

    public String toString() {
        return "";
    }

    public String toPPString() {
        return "";
    }
}

