/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class IntraFactNode
extends BaseAlpha2 {
    private static final long serialVersionUID = 1L;
    private Slot leftSlot = null;
    private Slot rightSlot = null;
    protected String hashstring = null;

    public IntraFactNode(int id) {
        super(id);
    }

    public void setOperator(int opr) {
        this.operator = opr;
    }

    public void setSlot(Slot sl) {
        this.leftSlot = sl;
    }

    public void setRightSlot(Slot sl) {
        this.rightSlot = sl;
    }

    public void assertFact(Fact factInstance, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(factInstance)) {
            AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
            alpha.addPartialMatch(factInstance);
            this.propogateAssert(factInstance, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance) {
        return Evaluate.evaluate(this.operator, factInstance.getSlotValue(this.leftSlot.getId()), factInstance.getSlotValue(this.rightSlot.getId()));
    }

    public String hashString() {
        if (this.hashstring == null) {
            this.hashstring = String.valueOf(this.leftSlot.getName()) + ":" + this.operator + ":" + this.rightSlot.getName();
        }
        return this.hashstring;
    }

    public void retractFact(Fact factInstance, Rete engine, WorkingMemory mem) throws RetractException {
        AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
        if (alpha.removePartialMatch(factInstance) != null) {
            this.propogateRetract(factInstance, engine, mem);
        }
    }

    public String toPPString() {
        return String.valueOf(this.leftSlot.getName()) + " " + ConversionUtils.getPPOperator(this.operator) + " " + this.rightSlot.getName() + " - useCount=" + this.useCount;
    }

    public String toString() {
        return String.valueOf(this.leftSlot.getName()) + " " + ConversionUtils.getPPOperator(this.operator) + " " + this.rightSlot.getName() + " - useCount=" + this.useCount;
    }
}

