/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashIndex;

public final class Index
implements Serializable,
HashIndex {
    private static final long serialVersionUID = 1L;
    private Fact[] facts = null;
    private int hashCode;

    public Index(Fact[] facts) {
        this.facts = facts;
        this.calculateHash();
    }

    private Index(Fact[] facts, int hashCode) {
        this.facts = facts;
        this.hashCode = hashCode;
    }

    private void calculateHash() {
        int hash = 0;
        int idx = 0;
        while (idx < this.facts.length) {
            hash += this.facts[idx].hashCode();
            ++idx;
        }
        this.hashCode = hash;
    }

    public Fact[] getFacts() {
        return this.facts;
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        boolean equal = false;
        Index otherIndex = (Index)val;
        Fact[] otherFact = otherIndex.facts;
        if (this.facts.length == otherIndex.facts.length) {
            equal = true;
            int idx = 0;
            while (idx < this.facts.length) {
                if (!this.facts[idx].equals(otherFact[idx])) {
                    equal = false;
                    break;
                }
                ++idx;
            }
        }
        return equal;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void clear() {
        this.facts = null;
        this.hashCode = 0;
    }

    public Index add(Fact fact) {
        Fact[] facts = new Fact[this.facts.length + 1];
        System.arraycopy(this.facts, 0, facts, 0, this.facts.length);
        facts[this.facts.length] = fact;
        return new Index(facts, this.hashCode + fact.hashCode());
    }

    public Index addAll(Index index) {
        Fact[] facts = new Fact[this.facts.length + index.facts.length];
        System.arraycopy(this.facts, 0, facts, 0, this.facts.length);
        System.arraycopy(index.facts, 0, facts, this.facts.length, index.facts.length);
        return new Index(facts, this.hashCode + index.hashCode);
    }

    public boolean partialMatch(Index index) {
        boolean match = true;
        Fact[] compfacts = index.facts;
        if (this.facts.length > compfacts.length) {
            int idx = 0;
            while (idx < compfacts.length) {
                if (compfacts[idx] != this.facts[idx]) {
                    match = false;
                    break;
                }
                ++idx;
            }
        } else {
            int idx = 0;
            while (idx < this.facts.length) {
                if (compfacts[idx] != this.facts[idx]) {
                    match = false;
                    break;
                }
                ++idx;
            }
        }
        return match;
    }

    public boolean partialMatch(Fact f) {
        return this.facts[this.facts.length - 1].getFactId() == f.getFactId();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < this.facts.length) {
            if (idx > 0) {
                buf.append(",");
            }
            buf.append(this.facts[idx].getFactId());
            ++idx;
        }
        return buf.toString();
    }
}

