/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedNeqAlphaMemory;
import org.jamocha.rete.Index;
import org.jamocha.rete.NotEqHashIndex;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.util.NodeUtils;

public class HashedNotEqNJoin
extends BaseJoin {
    public HashedNotEqNJoin(int id) {
        super(id);
    }

    public void clear(WorkingMemory mem) {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        HashedNeqAlphaMemory rightmem = (HashedNeqAlphaMemory)mem.getBetaRightMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.put(linx, linx);
        NotEqHashIndex inx = new NotEqHashIndex(NodeUtils.getLeftBindValues(this.binds, linx.getFacts()));
        HashedNeqAlphaMemory rightmem = (HashedNeqAlphaMemory)mem.getBetaRightMemory(this);
        if (rightmem.zeroMatch(inx)) {
            this.propogateAssert(linx, engine, mem);
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        HashedNeqAlphaMemory rightmem = (HashedNeqAlphaMemory)mem.getBetaRightMemory(this);
        NotEqHashIndex inx = new NotEqHashIndex(NodeUtils.getRightBindValues(this.binds, rfact));
        rightmem.addPartialMatch(inx, rfact, engine);
        boolean zm = rightmem.zeroMatch(inx);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact) || zm) continue;
            try {
                this.propogateRetract(linx, engine, mem);
            }
            catch (RetractException e) {
                throw new AssertException("NotJion - " + e.getMessage());
            }
        }
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.remove(linx);
        this.propogateRetract(linx, engine, mem);
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        NotEqHashIndex inx = new NotEqHashIndex(NodeUtils.getRightBindValues(this.binds, rfact));
        HashedNeqAlphaMemory rightmem = (HashedNeqAlphaMemory)mem.getBetaRightMemory(this);
        rightmem.removePartialMatch(inx, rfact);
        boolean zm = rightmem.zeroMatch(inx);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact) || !zm) continue;
            try {
                this.propogateAssert(linx, engine, mem);
            }
            catch (AssertException e) {
                throw new RetractException("NotJion - " + e.getMessage());
            }
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashedNotEqNJoin-" + this.nodeID + "> ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }
}

