/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.NotEqHashIndex;
import org.jamocha.rete.Rete;

public class HashedNeqAlphaMemory
extends HashedAlphaMemoryImpl {
    public HashedNeqAlphaMemory(String name, Rete engine) {
        super(name, engine);
    }

    public int addPartialMatch(NotEqHashIndex index, Fact fact, Rete engine) {
        Map matches = (Map)this.memory.get(index);
        int count = 0;
        if (matches == null) {
            count = this.addNewPartialMatch(index, fact, engine);
        } else {
            Map submatch = (Map)matches.get(index.getSubIndex());
            if (submatch == null) {
                submatch = engine.newMap();
                submatch.put(fact, fact);
                matches.put(index.getSubIndex(), submatch);
                count = matches.size();
            } else {
                submatch.put(fact, fact);
                count = submatch.size();
            }
        }
        ++this.counter;
        return count;
    }

    public int addNewPartialMatch(NotEqHashIndex index, Fact fact, Rete engine) {
        Map matches = engine.newMap();
        Map submatch = engine.newMap();
        submatch.put(fact, fact);
        matches.put(index.getSubIndex(), submatch);
        this.memory.put(index, matches);
        return 1;
    }

    public void clear() {
        for (Object key : this.memory.keySet()) {
            Map matches = (Map)this.memory.get(key);
            for (Object subkey : matches.keySet()) {
                Map submatch = (Map)matches.get(subkey);
                submatch.clear();
            }
            matches.clear();
        }
        this.memory.clear();
    }

    public boolean isPartialMatch(NotEqHashIndex index, Fact fact) {
        Map match = (Map)this.memory.get(index);
        if (match != null) {
            Map submatch = (Map)match.get(index.getSubIndex());
            if (submatch != null) {
                return submatch.containsKey(fact);
            }
            return false;
        }
        return false;
    }

    public int removePartialMatch(NotEqHashIndex index, Fact fact) {
        Map match = (Map)this.memory.get(index);
        if (match != null) {
            Map submatch = (Map)match.get(index.getSubIndex());
            submatch.remove(fact);
            if (submatch.size() == 0) {
                match.remove(index.getSubIndex());
            }
            --this.counter;
            return submatch.size();
        }
        return -1;
    }

    public int size() {
        Iterator itr = this.memory.keySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map matches = (Map)this.memory.get(itr.next());
            for (EqHashIndex ehi : matches.keySet()) {
                Map submatch = (Map)matches.get(ehi);
                count += submatch.size();
            }
        }
        return count;
    }

    public int bucketCount() {
        return this.memory.size();
    }

    public Object[] iterator(NotEqHashIndex index) {
        Map matches = (Map)this.memory.get(index);
        Object[] list = new Object[this.counter];
        Object[] trim = null;
        int idz = 0;
        if (matches != null) {
            for (Object key : matches.keySet()) {
                if (!index.getSubIndex().equals(key)) {
                    Map submatch = (Map)matches.get(key);
                    Iterator itr2 = submatch.keySet().iterator();
                    while (itr2.hasNext()) {
                        list[idz] = itr2.next();
                        ++idz;
                    }
                }
                trim = new Object[idz];
                System.arraycopy(list, 0, trim, 0, idz);
            }
            list = null;
            return trim;
        }
        return null;
    }

    public boolean zeroMatch(NotEqHashIndex index) {
        Map matches = (Map)this.memory.get(index);
        int idz = 0;
        if (matches != null) {
            for (Object key : matches.keySet()) {
                if (!index.getSubIndex().equals(key)) {
                    Map submatch = (Map)matches.get(key);
                    idz += submatch.size();
                }
                if (idz > 0) break;
            }
            return false;
        }
        return true;
    }

    public Object[] iterateAll() {
        Object[] facts = new Object[this.counter];
        Iterator itr = this.memory.keySet().iterator();
        int idx = 0;
        while (itr.hasNext()) {
            Map matches = (Map)this.memory.get(itr.next());
            Iterator itr2 = matches.keySet().iterator();
            while (itr2.hasNext()) {
                Map submatch = (Map)matches.get(itr2.next());
                Iterator itr3 = submatch.values().iterator();
                while (itr3.hasNext()) {
                    facts[idx] = itr3.next();
                    ++idx;
                }
            }
        }
        Object[] trim = new Object[idx];
        System.arraycopy(facts, 0, trim, 0, idx);
        facts = null;
        return trim;
    }
}

