/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Binding;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.util.NodeUtils;

public class HashedEqNJoin
extends BaseJoin {
    private static final long serialVersionUID = 1L;

    public HashedEqNJoin(int id) {
        super(id);
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.put(linx, linx);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
        if (rightmem.count(inx) == 0) {
            this.propogateAssert(linx, engine, mem);
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        rightmem.addPartialMatch(inx, rfact, engine);
        int after = rightmem.count(inx);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact) || after != 1) continue;
            try {
                this.propogateRetract(linx, engine, mem);
            }
            catch (RetractException e) {
                throw new AssertException("NotJion - " + e.getMessage());
            }
        }
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.remove(linx);
        this.propogateRetract(linx, engine, mem);
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        EqHashIndex inx;
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
        int after = rightmem.removePartialMatch(inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact)), rfact);
        if (after == 0) {
            Map leftmem = (Map)mem.getBetaLeftMemory(this);
            for (Index linx : leftmem.values()) {
                if (!this.evaluate(linx.getFacts(), rfact)) continue;
                try {
                    this.propogateAssert(linx, engine, mem);
                }
                catch (AssertException e) {
                    throw new RetractException("NotJion - " + e.getMessage());
                }
            }
            inx = null;
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public void addSuccessorNode(TerminalNode node, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.addNode(node)) {
            Map leftmem = (Map)mem.getBetaLeftMemory(this);
            for (Object omem : leftmem.values()) {
                if (!(omem instanceof BetaMemory)) continue;
                BetaMemory bmem = (BetaMemory)omem;
                EqHashIndex inx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, bmem.getLeftFacts()));
                HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
                if (rightmem.count(inx) != 0) continue;
                node.assertFacts(bmem.getIndex(), engine, mem);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashedEqNJoin- ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashedEqNJoin-" + this.nodeID + "> ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toPPString());
            ++idx;
        }
        return buf.toString();
    }
}

