/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashIndex;
import org.jamocha.rete.Rete;

public class HashedAlphaMemoryImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map memory = null;
    protected int counter = 0;

    public HashedAlphaMemoryImpl(String name, Rete engine) {
        this.memory = engine.newAlphaMemoryMap(name);
    }

    public int addPartialMatch(HashIndex index, Fact fact, Rete engine) {
        Map matches = (Map)this.memory.get(index);
        int count = 0;
        if (matches == null) {
            count = this.addNewPartialMatch(index, fact, engine);
        } else {
            matches.put(fact, fact);
            count = matches.size();
        }
        ++this.counter;
        return count;
    }

    public int addNewPartialMatch(HashIndex index, Fact fact, Rete engine) {
        Map matches = engine.newMap();
        matches.put(fact, fact);
        this.memory.put(index, matches);
        return 1;
    }

    public void clear() {
        Iterator itr = this.memory.values().iterator();
        while (itr.hasNext()) {
            ((Map)itr.next()).clear();
        }
        this.memory.clear();
    }

    public boolean isPartialMatch(HashIndex index, Fact fact) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            return list.containsKey(fact);
        }
        return false;
    }

    public int removePartialMatch(HashIndex index, Fact fact) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            list.remove(fact);
            if (list.size() == 0) {
                this.memory.remove(index);
            }
            --this.counter;
            return list.size();
        }
        return 0;
    }

    public int size() {
        Iterator itr = this.memory.keySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map matches = (Map)this.memory.get(itr.next());
            count += matches.size();
        }
        return count;
    }

    public int bucketCount() {
        return this.counter;
    }

    public Iterator iterator(HashIndex index) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            return list.values().iterator();
        }
        return null;
    }

    public int count(HashIndex index) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public Object[] iterateAll() {
        Object[] all = new Object[this.counter];
        Iterator itr = this.memory.keySet().iterator();
        int idx = 0;
        while (itr.hasNext()) {
            Map f = (Map)this.memory.get(itr.next());
            Iterator itr2 = f.values().iterator();
            while (itr2.hasNext()) {
                all[idx] = itr2.next();
                ++idx;
            }
        }
        return all;
    }
}

