/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rule.Query;
import org.jamocha.rule.Rule;

public class FunctionParam2
extends AbstractParam {
    private static final long serialVersionUID = 1L;
    protected Function func = null;
    protected String funcName = null;
    private Parameter[] params = null;
    private Rete engine = null;
    protected Fact[] facts;

    public void setFunctionName(String name) {
        this.funcName = name;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public void setEngine(Rete engine) {
        this.engine = engine;
    }

    public void configure(Rete engine, Rule util) {
        if (this.engine == null) {
            this.engine = engine;
        }
        int idx = 0;
        while (idx < this.params.length) {
            BoundParam bp;
            Binding b1;
            if (this.params[idx] instanceof BoundParam && (b1 = util.getBinding((bp = (BoundParam)this.params[idx]).getVariableName())) != null) {
                bp.setRow(b1.getLeftRow());
                bp.setColumn(b1.getLeftIndex());
                if (b1.getLeftIndex() == -1) {
                    bp.setObjectBinding(true);
                }
            }
            ++idx;
        }
    }

    public void configure(Rete engine, Query util) {
        if (this.engine == null) {
            this.engine = engine;
        }
        int idx = 0;
        while (idx < this.params.length) {
            BoundParam bp;
            Binding b1;
            if (this.params[idx] instanceof BoundParam && (b1 = util.getBinding((bp = (BoundParam)this.params[idx]).getVariableName())) != null) {
                bp.setRow(b1.getLeftRow());
                bp.setColumn(b1.getLeftIndex());
                if (b1.getLeftIndex() == -1) {
                    bp.setObjectBinding(true);
                }
            }
            ++idx;
        }
    }

    public void setParameters(Parameter[] params) {
        this.params = params;
    }

    public Parameter[] getParameters() {
        return this.params;
    }

    public boolean hasBoundParameter() {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx] instanceof BoundParam) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public void lookUpFunction() {
        this.func = this.engine.findFunction(this.funcName);
    }

    public int getValueType() {
        return this.func.getReturnType();
    }

    public Object getValue() {
        if (this.params != null) {
            if (this.facts != null) {
                this.setFact();
            }
            return this.func.executeFunction(this.engine, this.params);
        }
        return null;
    }

    protected void setFact() {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx] instanceof BoundParam) {
                ((BoundParam)this.params[idx]).setFact(this.facts);
            } else if (this.params[idx] instanceof FunctionParam) {
                ((FunctionParam)this.params[idx]).setFacts(this.facts);
            }
            ++idx;
        }
    }

    public Object getValue(Rete engine, int valueType) {
        if (this.params != null) {
            this.engine = engine;
            this.lookUpFunction();
            this.checkParameters();
            ReturnVector rval = this.func.executeFunction(engine, this.params);
            if (valueType == 22) {
                return rval.firstReturnValue().getBigDecimalValue();
            }
            if (valueType == 9 || valueType == 10) {
                return rval.firstReturnValue().getValue();
            }
            if (valueType == 14 || valueType == 1) {
                return rval.firstReturnValue().getIntValue();
            }
            if (valueType == 16 || valueType == 3) {
                return rval.firstReturnValue().getLongValue();
            }
            if (valueType == 17 || valueType == 4) {
                return Float.valueOf(rval.firstReturnValue().getFloatValue());
            }
            if (valueType == 18 || valueType == 5) {
                return rval.firstReturnValue().getDoubleValue();
            }
            return rval.firstReturnValue().getValue();
        }
        return null;
    }

    protected void checkParameters() {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx] instanceof BoundParam) {
                ((BoundParam)this.params[idx]).setFact(this.facts);
            }
            ++idx;
        }
    }

    public void reset() {
        this.engine = null;
        this.params = null;
    }

    public String toPPString() {
        this.lookUpFunction();
        return this.func.toPPString(this.params, 1);
    }

    public Fact[] getFacts() {
        return this.facts;
    }

    public void setFacts(Fact[] facts) {
        this.facts = facts;
    }

    public FunctionParam2 clone() {
        Parameter[] cloneParams = new Parameter[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            AbstractParam fp;
            if (this.params[i] instanceof BoundParam) {
                BoundParam bp = (BoundParam)this.params[i];
                cloneParams[i] = bp.clone();
            } else if (this.params[i] instanceof ValueParam) {
                ValueParam vp = (ValueParam)this.params[i];
                cloneParams[i] = vp.cloneParameter();
            } else if (this.params[i] instanceof FunctionParam) {
                fp = (FunctionParam)this.params[i];
                cloneParams[i] = ((FunctionParam)fp).clone();
            } else if (this.params[i] instanceof FunctionParam2) {
                fp = (FunctionParam2)this.params[i];
                cloneParams[i] = ((FunctionParam2)fp).clone();
            }
            ++i;
        }
        FunctionParam2 clone = new FunctionParam2();
        clone.engine = this.engine;
        clone.facts = this.facts;
        clone.func = this.func;
        clone.funcName = this.funcName;
        clone.objBinding = this.objBinding;
        clone.params = cloneParams;
        return clone;
    }
}

