/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class FunctionParam
extends AbstractParam {
    private static final long serialVersionUID = 1L;
    protected Function func = null;
    protected int valueType = -1;
    protected Object value = null;
    protected Fact[] facts;
    protected BoundParam[] params = null;
    protected Rete engine = null;

    public FunctionParam(Function func, Rete rete) {
        this.func = func;
        this.engine = rete;
    }

    public int getValueType() {
        return this.valueType;
    }

    public Object getValue() {
        this.initParams();
        this.value = this.func.executeFunction(this.engine, this.params);
        return this.value;
    }

    public Object getValue(Rete engine, int valueType) {
        this.initParams();
        ReturnVector rval = this.func.executeFunction(engine, this.params);
        return rval.firstReturnValue().getBigDecimalValue();
    }

    public void setFacts(Fact[] facts) {
        this.facts = facts;
    }

    protected void initParams() {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx].isObjectBinding()) {
                this.params[idx].setFact(this.facts);
            } else if (this.params[idx] instanceof BoundParam) {
                BoundParam bp = this.params[idx];
                Object val = this.engine.getDefglobalValue(bp.getVariableName());
                bp.setResolvedValue(val);
            }
            ++idx;
        }
    }

    public void reset() {
        this.facts = null;
        this.value = null;
    }

    public FunctionParam clone() {
        BoundParam[] cloneParam = new BoundParam[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            cloneParam[i] = this.params[i].clone();
            ++i;
        }
        FunctionParam clone = new FunctionParam(this.func, this.engine);
        clone.facts = this.facts;
        clone.objBinding = this.objBinding;
        clone.value = this.value;
        clone.valueType = this.valueType;
        clone.params = cloneParam;
        return clone;
    }
}

