/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.BetaMemoryImpl;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class ExistPredJoin
extends BaseJoin {
    private static final long serialVersionUID = 1L;

    public ExistPredJoin(int id) {
        super(id);
    }

    public void clear(WorkingMemory mem) {
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        Map leftmem = (Map)mem.getBetaRightMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        BetaMemoryImpl bmem = new BetaMemoryImpl(linx, engine);
        leftmem.put(linx, bmem);
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        Iterator itr = rightmem.keySet().iterator();
        if (itr != null) {
            while (itr.hasNext()) {
                Fact vl = (Fact)itr.next();
                if (vl == null || !this.evaluate(linx.getFacts(), vl, engine)) continue;
                bmem.addMatch(vl);
            }
        }
        if (bmem.matchCount() > 0) {
            this.propogateAssert(linx, engine, mem);
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        rightmem.put(rfact, rfact);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (BetaMemory bmem : leftmem.values()) {
            if (!this.evaluate(bmem.getLeftFacts(), rfact, engine)) continue;
            bmem.addMatch(rfact);
            if (bmem.matchCount() != 1) continue;
            this.propogateAssert(bmem.getIndex().add(rfact), engine, mem);
        }
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.remove(linx);
        this.propogateRetract(linx, engine, mem);
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        rightmem.remove(rfact);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (BetaMemory bmem : leftmem.values()) {
            if (!this.evaluate(bmem.getLeftFacts(), rfact, engine)) continue;
            bmem.removeMatch(rfact);
            if (bmem.matchCount() != 0) continue;
            this.propogateRetract(bmem.getIndex(), engine, mem);
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right, Rete engine) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd instanceof Binding2 ? ((Binding2)bnd).evaluate(leftlist, right, engine) : bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ExistPredJoin - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<node-" + this.nodeID + "> Exist - ");
        if (this.binds != null && this.binds.length > 0) {
            int idx = 0;
            while (idx < this.binds.length) {
                if (idx > 0) {
                    buf.append(" && ");
                }
                buf.append(this.binds[idx].toPPString());
                ++idx;
            }
        } else {
            buf.append(" no joins ");
        }
        return buf.toString();
    }
}

