/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Binding;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.util.NodeUtils;

public class ExistJoin
extends BaseJoin {
    private static final long serialVersionUID = 1L;

    public ExistJoin(int id) {
        super(id);
    }

    public void clear(WorkingMemory mem) {
        Map rightmem = (Map)mem.getBetaRightMemory(this);
        Map leftmem = (Map)mem.getBetaRightMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.put(linx, linx);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
        if (rightmem.count(inx) > 0) {
            this.propogateAssert(linx, engine, mem);
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        int after = rightmem.addPartialMatch(inx, rfact, engine);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact) || after != 1) continue;
            this.propogateAssert(linx, engine, mem);
        }
    }

    public void retractLeft(Index inx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.remove(inx);
        this.propogateRetract(inx, engine, mem);
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        EqHashIndex inx;
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
        int after = rightmem.removePartialMatch(inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact)), rfact);
        if (after == 0) {
            Map leftmem = (Map)mem.getBetaLeftMemory(this);
            for (Index linx : leftmem.values()) {
                if (!this.evaluate(linx.getFacts(), rfact)) continue;
                this.propogateRetract(linx, engine, mem);
            }
            inx = null;
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Exist - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<node-" + this.nodeID + "> Exist - ");
        if (this.binds != null && this.binds.length > 0) {
            int idx = 0;
            while (idx < this.binds.length) {
                if (idx > 0) {
                    buf.append(" && ");
                }
                buf.append(this.binds[idx].toPPString());
                ++idx;
            }
        } else {
            buf.append(" no joins ");
        }
        return buf.toString();
    }
}

