/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Module;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Template;
import org.jamocha.rete.TemporalDeffact;

public class Deftemplate
implements Template,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Slot[] slots;
    private boolean watch = false;
    private String templateName = null;
    private Template parent = null;
    private String defclass = null;
    private int temporalDistance = 0;
    private boolean nonTemporalRule = false;

    public Deftemplate(String name, String defclass, Slot[] slots) {
        this.templateName = name;
        this.defclass = defclass;
        this.slots = slots;
    }

    public Deftemplate(String name, String defclass, Slot[] slots, Template parent) {
        this(name, defclass, slots);
        this.parent = parent;
    }

    public Deftemplate(String name) {
        this.templateName = name;
    }

    public Deftemplate(String name, Template parent) {
        this.templateName = name;
        this.parent = parent;
    }

    public Deftemplate() {
    }

    public Module checkName(Rete engine) {
        if (this.templateName.indexOf("::") > 0) {
            String[] sp = this.templateName.split("::");
            this.templateName = sp[1];
            return engine.addModule(sp[0], false);
        }
        return null;
    }

    public Template getParent() {
        return this.parent;
    }

    public void setParent(Template parent) {
        this.parent = parent;
    }

    public boolean getWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public String getName() {
        return this.templateName;
    }

    public String getClassName() {
        return this.defclass;
    }

    public int getNumberOfSlots() {
        return this.slots.length;
    }

    public Slot[] getAllSlots() {
        return this.slots;
    }

    public int getSlotsUsed() {
        int used = 0;
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getNodeCount() > 0) {
                ++used;
            }
            ++idx;
        }
        return used;
    }

    public Slot getSlot(String name) {
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getName().equals(name)) {
                return this.slots[idx];
            }
            ++idx;
        }
        return null;
    }

    public Slot getSlot(int id) {
        return this.slots[id];
    }

    public int getColumnIndex(String name) {
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getName().equals(name)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public void incrementColumnUseCount(String name) {
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getName().equals(name)) {
                this.slots[idx].incrementNodeCount();
            }
            ++idx;
        }
    }

    public int getTemporalDistance() {
        return this.temporalDistance;
    }

    public void setTemporalDistance(int temporalDistance) {
        this.temporalDistance = temporalDistance;
    }

    public boolean getNonTemporalRules() {
        return this.nonTemporalRule;
    }

    public void setNonTemporalRules(boolean value) {
        this.nonTemporalRule = value;
    }

    public Fact createFact(Object data, Defclass clazz, long id) {
        BaseSlot[] values = this.cloneAllSlots();
        int idx = 0;
        while (idx < values.length) {
            Object val = clazz.getSlotValue(idx, data);
            values[idx].value = val == null ? "nil" : val;
            ++idx;
        }
        Deffact newfact = new Deffact(this, data, values, id);
        return newfact;
    }

    public Fact createTemporalFact(Object data, Defclass clazz, long id) {
        BaseSlot[] values = this.cloneAllSlots();
        int idx = 0;
        while (idx < values.length) {
            Object val = clazz.getSlotValue(idx, data);
            values[idx].value = val == null ? "nil" : val;
            ++idx;
        }
        TemporalDeffact newfact = new TemporalDeffact(this, data, values, id);
        return newfact;
    }

    public Fact createFact(List data, long id) {
        BaseSlot[] values = this.cloneAllSlots();
        for (Slot s : data) {
            int idx = 0;
            while (idx < values.length) {
                if (values[idx].getName().equals(s.getName())) {
                    values[idx].value = s.value == null ? "nil" : (values[idx].getValueType() == 11 && !(s.value instanceof BoundParam) ? s.value.toString() : s.value);
                }
                ++idx;
            }
        }
        Deffact newfact = new Deffact(this, null, values, id);
        newfact.equalityIndex();
        return newfact;
    }

    public Fact createFact(Object[] data, long id) {
        BaseSlot[] values = this.cloneAllSlots();
        ArrayList<Slot> bslots = new ArrayList<Slot>();
        boolean hasbinding = false;
        int idz = 0;
        while (idz < data.length) {
            Slot s = (Slot)data[idz];
            int idx = 0;
            while (idx < values.length) {
                if (values[idx].getName().equals(s.getName())) {
                    if (s instanceof MultiSlot) {
                        MultiSlot ms = (MultiSlot)s;
                        Object[] mvals = ms.getValue();
                        int mdx = 0;
                        while (mdx < mvals.length) {
                            if (mvals[mdx] instanceof BoundParam) {
                                bslots.add((MultiSlot)ms.clone());
                                hasbinding = true;
                                break;
                            }
                            ++mdx;
                        }
                        values[idx].value = s.value;
                        break;
                    }
                    if (s.value == null) {
                        values[idx].value = "nil";
                        break;
                    }
                    if (values[idx].getValueType() == 11 && !(s.value instanceof BoundParam)) {
                        values[idx].value = s.value.toString();
                        break;
                    }
                    if (s.value instanceof BoundParam) {
                        values[idx].value = s.value;
                        bslots.add((Slot)s.clone());
                        hasbinding = true;
                        break;
                    }
                    values[idx].value = s.value;
                    break;
                }
                ++idx;
            }
            ++idz;
        }
        Deffact newfact = new Deffact(this, null, values, id);
        if (hasbinding) {
            Slot[] slts2 = new Slot[bslots.size()];
            newfact.boundSlots = bslots.toArray(slts2);
            newfact.hasBinding = true;
        }
        newfact.equalityIndex();
        return newfact;
    }

    public Fact createTemporalFact(Object[] data, long id) {
        BaseSlot[] values = this.cloneAllSlots();
        long effective = 0L;
        long expire = 0L;
        String source = "";
        String service = "";
        int valid = 0;
        int idz = 0;
        while (idz < data.length) {
            block5: {
                Slot s;
                block3: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    s = (Slot)data[idz];
                                    if (!Deftemplate.isTemporalAttribute(s)) break block3;
                                    if (!s.getName().equals("effective-time")) break block4;
                                    effective = ((BigDecimal)s.getValue()).longValue();
                                    break block5;
                                }
                                if (!s.getName().equals("expiration-time")) break block6;
                                expire = ((BigDecimal)s.getValue()).longValue();
                                break block5;
                            }
                            if (!s.getName().equals("service-type")) break block7;
                            service = (String)s.getValue();
                            break block5;
                        }
                        if (!s.getName().equals("source")) break block8;
                        source = (String)s.getValue();
                        break block5;
                    }
                    if (!s.getName().equals("validity")) break block5;
                    valid = ((BigDecimal)s.getValue()).intValue();
                    break block5;
                }
                int idx = 0;
                while (idx < values.length) {
                    if (values[idx].getName().equals(s.getName())) {
                        values[idx].value = s.value == null ? "nil" : (values[idx].getValueType() == 11 && !(s.value instanceof BoundParam) ? s.value.toString() : (s.value instanceof BoundParam ? s.value : s.value));
                    }
                    ++idx;
                }
            }
            ++idz;
        }
        TemporalDeffact newfact = new TemporalDeffact(this, null, values, id);
        newfact.setEffectiveTime(effective);
        newfact.setExpirationTime(expire);
        newfact.setServiceType(service);
        newfact.setSource(source);
        newfact.setValidity(valid);
        newfact.equalityIndex();
        return newfact;
    }

    public static boolean isTemporalAttribute(Slot s) {
        return s.getName().equals("effective-time") || s.getName().equals("expiration-time") || s.getName().equals("service-type") || s.getName().equals("source") || s.getName().equals("validity");
    }

    public BaseSlot[] cloneAllSlots() {
        BaseSlot[] cloned = new Slot[this.slots.length];
        int idx = 0;
        while (idx < cloned.length) {
            cloned[idx] = (Slot)this.slots[idx].clone();
            ++idx;
        }
        return cloned;
    }

    public boolean inUse() {
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getNodeCount() > 0) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.templateName + " ");
        int idx = 0;
        while (idx < this.slots.length) {
            buf.append("(" + this.slots[idx].getName() + " (type " + ConversionUtils.getTypeName(this.slots[idx].getValueType()) + ") ) ");
            ++idx;
        }
        if (this.defclass != null) {
            buf.append("[" + this.defclass + "] ");
        }
        buf.append(")");
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.templateName + Constants.LINEBREAK);
        int idx = 0;
        while (idx < this.slots.length) {
            buf.append("  (" + this.slots[idx].getName() + " (type " + ConversionUtils.getTypeName(this.slots[idx].getValueType()) + ") " + "(distinct-count " + this.slots[idx].getDistinctCount() + ") )" + Constants.LINEBREAK);
            ++idx;
        }
        if (this.defclass != null) {
            buf.append("[" + this.defclass + "] ");
        }
        buf.append(")");
        if (this.temporalDistance > 0) {
            buf.append(" temporal distance: " + this.temporalDistance + " ms");
        }
        return buf.toString();
    }

    public Deftemplate cloneDeftemplate() {
        Deftemplate dt = new Deftemplate(this.templateName, this.defclass, this.slots);
        return dt;
    }
}

