/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jamocha.rete.Activation;
import org.jamocha.rete.ActivationList;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.LinkedActivation;
import org.jamocha.rete.LinkedActivationList;
import org.jamocha.rete.Module;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Strategy;
import org.jamocha.rete.Template;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.Rule;

public class Defmodule
implements Module,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int id;
    protected String name = null;
    protected Map rules = null;
    protected ActivationList activations = null;
    protected Map deftemplates = null;
    protected Map classToDeftemplates = null;
    private int templateCount = 0;
    private ClassLoader moduleClassLoader = null;
    private String workingDirectory = null;

    public Defmodule(String name, Rete engine) {
        this.name = name;
        this.rules = engine.newLocalMap();
        this.deftemplates = engine.newLocalMap();
        this.classToDeftemplates = engine.newLocalMap();
        this.activations = new LinkedActivationList();
        URL[] urls = new URL[1];
        this.workingDirectory = "./working_directory/" + this.name;
        File workingdir = new File(this.workingDirectory);
        workingdir.mkdirs();
        try {
            urls[0] = workingdir.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.moduleClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    public ActivationList getAllActivations() {
        return this.activations.clone();
    }

    public synchronized int getActivationCount() {
        return this.activations.size();
    }

    public void addActivation(Activation actv) {
        this.activations.addActivation(actv);
    }

    public Activation removeActivation(Activation actv) {
        return this.activations.removeActivation(actv);
    }

    public Activation nextActivation(Rete engine) {
        Activation act = this.activations.nextActivation();
        if (act instanceof LinkedActivation) {
            ((LinkedActivation)act).remove(engine);
        }
        return act;
    }

    public String getModuleName() {
        return this.name;
    }

    public void clear() {
        this.activations.clear();
        for (Defrule rl : this.rules.values()) {
            rl.clear();
        }
        this.rules.clear();
        this.deftemplates.clear();
        this.classToDeftemplates.clear();
    }

    public void addRule(Rule rl) {
        this.rules.put(rl.getName(), rl);
    }

    public void removeAllRules(Rete engine, WorkingMemory mem) {
        for (Defrule rl : this.rules.values()) {
            this.removeRule(rl, engine, mem);
        }
    }

    public void removeRule(Rule rl, Rete engine, WorkingMemory mem) {
        this.rules.remove(rl.getName());
        Condition[] cnds = rl.getConditions();
        int idx = 0;
        while (idx < cnds.length) {
            Condition cnd = cnds[idx];
            if (cnd instanceof ObjectCondition) {
                ObjectCondition oc = (ObjectCondition)cnd;
                String templ = oc.getTemplateName();
                Deftemplate temp = (Deftemplate)this.deftemplates.get(templ);
                ObjectTypeNode otn = mem.getRuleCompiler().getObjectTypeNode(temp);
                this.removeAlphaNodes(oc.getNodes(), otn);
            }
            ++idx;
        }
        List bjl = rl.getJoins();
        int idx2 = 0;
        while (idx2 < bjl.size()) {
            BaseJoin bjoin = (BaseJoin)bjl.get(idx2);
            Condition cnd = cnds[idx2 + 1];
            if (cnd instanceof ObjectCondition) {
                ObjectCondition oc = (ObjectCondition)cnd;
                String templ = oc.getTemplateName();
                Deftemplate temp = (Deftemplate)this.deftemplates.get(templ);
                ObjectTypeNode otn = mem.getRuleCompiler().getObjectTypeNode(temp);
                otn.removeNode(bjoin);
            }
            ++idx2;
        }
    }

    protected void removeAlphaNodes(List nodes, ObjectTypeNode otn) {
        BaseNode prev = otn;
        int idx = 0;
        while (idx < nodes.size()) {
            BaseNode node = (BaseNode)nodes.get(idx);
            if (node.useCount > 1) {
                node.decrementUseCount();
            } else {
                ((BaseNode)prev).removeNode(node);
            }
            prev = node;
            ++idx;
        }
    }

    public boolean containsRule(Rule rl) {
        return this.rules.containsKey(rl.getName());
    }

    public Collection getAllRules() {
        return this.rules.values();
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public boolean containsTemplate(Object key) {
        if (key instanceof Defclass) {
            Defclass dc = (Defclass)key;
            return this.classToDeftemplates.containsKey(dc.getClassObject().getName());
        }
        return this.deftemplates.containsKey(key);
    }

    public Template getTemplate(Defclass key) {
        Template templ = (Template)this.deftemplates.get(key.getClassObject().getName());
        if (templ == null) {
            templ = (Template)this.classToDeftemplates.get(key.getClassObject().getName());
        }
        return templ;
    }

    public Template getTemplate(String key) {
        return (Template)this.deftemplates.get(key);
    }

    public Template findParentTemplate(String key) {
        Deftemplate tmpl = null;
        for (Object keyval : this.deftemplates.keySet()) {
            Deftemplate entry = (Deftemplate)this.deftemplates.get(keyval);
            if (!entry.getName().equals(key)) continue;
            tmpl = entry;
            break;
        }
        return tmpl;
    }

    public void addTemplate(Template temp, Rete engine, WorkingMemory mem) {
        if (!this.deftemplates.containsKey(temp.getName())) {
            if (temp.getClassName() != null) {
                this.deftemplates.put(temp.getName(), temp);
                this.classToDeftemplates.put(temp.getClassName(), temp);
                ++this.templateCount;
            } else {
                this.deftemplates.put(temp.getName(), temp);
                ++this.templateCount;
            }
            ObjectTypeNode otn = new ObjectTypeNode(engine.nextNodeId(), temp, engine);
            mem.getRuleCompiler().addObjectTypeNode(otn);
        }
    }

    public void removeTemplate(Template temp, Rete engine, WorkingMemory mem) {
        this.deftemplates.remove(temp.getName());
        if (temp.getClassName() != null) {
            this.classToDeftemplates.remove(temp.getClassName());
        }
        ObjectTypeNode otn = mem.getRuleCompiler().getObjectTypeNode(temp);
        mem.getRuleCompiler().removeObjectTypeNode(otn);
    }

    public Collection getTemplates() {
        return this.deftemplates.values();
    }

    public int getTemplateCount() {
        return this.templateCount;
    }

    public Rule findRule(String name) {
        return (Rule)this.rules.get(name);
    }

    public void setLazy(boolean lazy) {
        this.activations.setLazy(lazy);
    }

    public void setStrategy(Strategy strat) {
        this.activations.setStrategy(strat);
    }

    public Strategy getStrategy() {
        return this.activations.getStrategy();
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }
}

