/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.ArrayList;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.EqualityIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Template;
import org.jamocha.rule.Rule;

public class Deffact
implements Fact {
    private static final long serialVersionUID = 1L;
    protected Template deftemplate = null;
    protected Object objInstance;
    protected BaseSlot[] slots = null;
    protected BaseSlot[] boundSlots = null;
    protected long id;
    private long timeStamp = 0L;
    protected boolean hasBinding = false;
    private EqualityIndex Eindex = null;

    public Deffact(Template template, Object instance, BaseSlot[] values, long id) {
        this.deftemplate = template;
        this.objInstance = instance;
        this.slots = values;
        this.id = id;
        this.timeStamp = System.currentTimeMillis();
    }

    public void compileBinding(Rule util) {
        ArrayList<BaseSlot> list = new ArrayList<BaseSlot>();
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].value instanceof BoundParam) {
                this.hasBinding = true;
                list.add(this.slots[idx]);
                BoundParam bp = (BoundParam)this.slots[idx].value;
                Binding bd = util.getBinding(bp.getVariableName());
                if (bd != null) {
                    bp.rowId = bd.getLeftRow();
                    bp.column = bd.getLeftIndex();
                }
            }
            ++idx;
        }
        if (list.size() > 0) {
            this.boundSlots = list.toArray(new Slot[list.size()]);
        }
    }

    public boolean hasBinding() {
        return this.hasBinding;
    }

    public void resolveValues(Rete engine, Fact[] triggerFacts) {
        int idx = 0;
        while (idx < this.boundSlots.length) {
            if (this.boundSlots[idx] instanceof MultiSlot) {
                Object[] mvals = ((MultiSlot)this.boundSlots[idx]).getValue();
                int mdx = 0;
                while (mdx < mvals.length) {
                    if (mvals[mdx] instanceof BoundParam) {
                        BoundParam bp = (BoundParam)mvals[mdx];
                        bp.setResolvedValue(engine.getBinding(bp.getVariableName()));
                    }
                    ++mdx;
                }
            } else if (this.boundSlots[idx].value instanceof BoundParam) {
                BoundParam bp = (BoundParam)this.boundSlots[idx].value;
                if (bp.column > -1) {
                    bp.setFact(triggerFacts);
                } else {
                    bp.setResolvedValue(engine.getBinding(bp.getVariableName()));
                }
            }
            ++idx;
        }
    }

    public Object getSlotValue(int id) {
        return this.slots[id].value;
    }

    public int getSlotId(String name) {
        int col = -1;
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getName().equals(name)) {
                col = idx;
                break;
            }
            ++idx;
        }
        return col;
    }

    public Object getObjectInstance() {
        return this.objInstance;
    }

    public String toFactString() {
        StringBuffer buf = new StringBuffer();
        buf.append("f-" + this.id + " (" + this.deftemplate.getName());
        if (this.slots.length > 0) {
            buf.append(" ");
        }
        int idx = 0;
        while (idx < this.slots.length) {
            buf.append("(" + this.slots[idx].getName() + " " + ConversionUtils.formatSlot(this.slots[idx].value) + ") ");
            ++idx;
        }
        buf.append(")");
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.deftemplate.getName());
        if (this.slots.length > 0) {
            buf.append(" ");
        }
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].value instanceof BoundParam) {
                BoundParam bp = (BoundParam)this.slots[idx].value;
                buf.append("(" + this.slots[idx].getName() + " ?" + bp.getVariableName() + ") ");
            } else {
                buf.append("(" + this.slots[idx].getName() + " " + ConversionUtils.formatSlot(this.slots[idx].value) + ") ");
            }
            ++idx;
        }
        buf.append(")");
        return buf.toString();
    }

    public EqualityIndex equalityIndex() {
        if (this.Eindex == null) {
            this.Eindex = new EqualityIndex(this);
        }
        return this.Eindex;
    }

    public int slotHash() {
        int hash = 0;
        int idx = 0;
        while (idx < this.slots.length) {
            hash = this.slots[idx] instanceof MultiSlot ? (hash += this.slots[idx].getName().hashCode() + ((MultiSlot)this.slots[idx]).valueHash()) : (hash += this.slots[idx].getName().hashCode() + this.slots[idx].value.hashCode());
            ++idx;
        }
        return hash;
    }

    public long getFactId() {
        return this.id;
    }

    public void setFactId(Rete engine) {
        if (this.id == -1L) {
            this.id = engine.nextFactId();
        }
    }

    public void resetID(Fact fact) {
        this.id = fact.getFactId();
    }

    public void updateSlots(Rete engine, BaseSlot[] updates) {
        int idx = 0;
        while (idx < updates.length) {
            BaseSlot uslot = updates[idx];
            if (uslot.value instanceof BoundParam) {
                Object val;
                BoundParam bp = (BoundParam)uslot.value;
                this.slots[uslot.getId()].value = val = engine.getBinding(bp.getVariableName());
            } else {
                this.slots[uslot.getId()].value = uslot.value;
            }
            ++idx;
        }
        this.timeStamp = System.currentTimeMillis();
        this.Eindex = null;
    }

    public Template getDeftemplate() {
        return this.deftemplate;
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    public boolean slotEquals(Fact fact) {
        boolean eq = true;
        BaseSlot[] cslots = ((Deffact)fact).slots;
        int idx = 0;
        while (idx < this.slots.length) {
            if (!this.slots[idx].value.equals(cslots[idx].value)) {
                eq = false;
                break;
            }
            ++idx;
        }
        return eq;
    }

    public Deffact cloneFact() {
        Deffact newfact = new Deffact(this.deftemplate, this.objInstance, this.deftemplate.cloneAllSlots(), -1L);
        BaseSlot[] slts = newfact.slots;
        int idx = 0;
        while (idx < slts.length) {
            if (this.slots[idx] instanceof MultiSlot) {
                MultiSlot ms = (MultiSlot)this.slots[idx];
                Object[] sval = ms.getValue();
                Object[] mval = new Object[ms.getValue().length];
                int mdx = 0;
                while (mdx < mval.length) {
                    Object v = sval[mdx];
                    mval[mdx] = v instanceof BoundParam ? ((BoundParam)v).getValue() : v;
                    ++mdx;
                }
                slts[idx].value = mval;
            } else {
                slts[idx].value = this.slots[idx].value instanceof BoundParam ? (slts[idx].getValueType() == 11 ? ((BoundParam)this.slots[idx].value).getValue().toString() : ((BoundParam)this.slots[idx].value).getValue()) : this.slots[idx].value;
            }
            ++idx;
        }
        return newfact;
    }

    public void clear() {
        this.deftemplate = null;
        this.objInstance = null;
        this.slots = null;
        this.id = 0L;
        this.timeStamp = 0L;
    }
}

