/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamocha.rete.Binding;
import org.jamocha.rete.CubeDimension;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.util.ProfileStats;

public class Defdimension
implements CubeDimension {
    private static final long serialVersionUID = 1L;
    private String name;
    private boolean joined = false;
    private boolean autoIndex = false;
    private Binding binding = null;
    private List deftemplates = new ArrayList();
    private String variableName;
    private Map tokenIndex = null;
    private boolean profile = false;

    public Defdimension(Rete engine) {
        this.tokenIndex = engine.newLocalMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public void setJoined(boolean joined) {
        this.joined = joined;
    }

    public List getDeftemplates() {
        return this.deftemplates;
    }

    public void setDeftemplates(List deftemplates) {
        this.deftemplates = deftemplates;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    public void setAutoIndex(boolean autoIndex) {
        this.autoIndex = autoIndex;
    }

    public void indexData(Index index, Rete engine) {
        if (this.profile) {
            ProfileStats.startCubeIndex();
            Object key = index.getFacts()[this.binding.leftrow].getSlotValue(this.binding.leftIndex);
            Map value = (Map)this.tokenIndex.get(key);
            if (value == null) {
                value = engine.newLocalMap();
                this.tokenIndex.put(key, value);
            }
            value.put(index, index);
            ProfileStats.endCubeIndex();
        } else {
            Object key = index.getFacts()[this.binding.leftrow].getSlotValue(this.binding.leftIndex);
            Map value = (Map)this.tokenIndex.get(key);
            if (value == null) {
                value = engine.newLocalMap();
                this.tokenIndex.put(key, value);
            }
            value.put(index, index);
        }
    }

    public boolean profile() {
        return this.profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public Map getData(Object value, boolean negated) {
        if (!negated) {
            return (Map)this.tokenIndex.get(value);
        }
        HashMap results = new HashMap();
        for (String key : this.tokenIndex.keySet()) {
            if (key.equals(value)) continue;
            Map values = (Map)this.tokenIndex.get(key);
            results.putAll(values);
        }
        return results;
    }

    public Map getData(Object value, int operator) {
        if (value instanceof Number) {
            Number n = (Number)value;
            switch (operator) {
                case 5: {
                    return this.queryGreater(n);
                }
                case 6: {
                    return this.queryLesser(n);
                }
                case 7: {
                    return this.queryGreaterEqual(n);
                }
                case 8: {
                    return this.queryLesserEqual(n);
                }
                case 10: {
                    return this.getData(value, true);
                }
            }
            return this.getData(value, false);
        }
        return null;
    }

    protected Map queryGreater(Number value) {
        HashMap matches = new HashMap();
        for (Object key : this.tokenIndex.keySet()) {
            Number v;
            if (!(key instanceof Number) || !Evaluate.evaluateGreater(v = (Number)key, value)) continue;
            Map data = (Map)this.tokenIndex.get(key);
            matches.putAll(data);
        }
        if (matches.size() > 0) {
            return matches;
        }
        return null;
    }

    protected Map queryLesser(Number value) {
        HashMap matches = new HashMap();
        for (Object key : this.tokenIndex.keySet()) {
            Number v;
            if (!(key instanceof Number) || !Evaluate.evaluateLess(v = (Number)key, value)) continue;
            Map data = (Map)this.tokenIndex.get(key);
            matches.putAll(data);
        }
        if (matches.size() > 0) {
            return matches;
        }
        return null;
    }

    protected Map queryGreaterEqual(Number value) {
        HashMap matches = new HashMap();
        for (Object key : this.tokenIndex.keySet()) {
            Number v;
            if (!(key instanceof Number) || !Evaluate.evaluateGreaterEqual(v = (Number)key, value)) continue;
            Map data = (Map)this.tokenIndex.get(key);
            matches.putAll(data);
        }
        if (matches.size() > 0) {
            return matches;
        }
        return null;
    }

    protected Map queryLesserEqual(Number value) {
        HashMap matches = new HashMap();
        for (Object key : this.tokenIndex.keySet()) {
            Number v;
            if (!(key instanceof Number) || !Evaluate.evaluateLessEqual(v = (Number)key, value)) continue;
            Map data = (Map)this.tokenIndex.get(key);
            matches.putAll(data);
        }
        if (matches.size() > 0) {
            return matches;
        }
        return null;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("dimension " + this.name + " ?" + this.variableName);
        buf.append(" : autoIndex(" + this.autoIndex + ")");
        if (this.tokenIndex != null) {
            buf.append(" : index size(" + this.tokenIndex.size() + ")");
        } else {
            buf.append(" : index size(0)");
        }
        if (this.binding != null && this.binding.leftrow > -1) {
            buf.append(" : row(" + this.binding.leftrow + "), col(" + this.binding.leftIndex + ")");
        }
        return buf.toString();
    }
}

