/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.CubeDimension;
import org.jamocha.rete.Defmeasure;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.measures.Measure;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.FunctionAction;
import org.jamocha.rule.ObjectCondition;

public class Defcube
implements Cube {
    public static final String RULE_PREFIX = "generated_cube_rule_";
    private CubeDimension[] dimensions;
    private Defmeasure[] defmeasures;
    private Measure[] measures;
    private String description;
    private String name;
    private List objectConditionList = null;
    private Map bindings = null;
    private Map bindingsByName = null;
    private Deftemplate[] templates = null;
    private Map dataset = null;
    private Map dimensionMap = null;
    private Map dimensionMapByBinding = null;
    private Map measureMap = null;
    private Defrule updateRule = null;
    private boolean compileSuccessful = true;
    private boolean profile = false;
    private boolean profileIndex = false;

    public Defcube(Rete engine) {
        this.bindings = engine.newLocalMap();
        this.bindingsByName = engine.newLocalMap();
        this.dataset = engine.newMap();
        this.dimensionMap = engine.newLocalMap();
        this.dimensionMapByBinding = engine.newLocalMap();
        this.measureMap = engine.newLocalMap();
    }

    public CubeDimension[] getDimensions() {
        return this.dimensions;
    }

    public Measure[] getMeasures() {
        return this.measures;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String text) {
        this.description = text;
    }

    public void setDimensions(CubeDimension[] dimensions) {
        this.dimensions = dimensions;
    }

    public CubeDimension getDimension(String name) {
        return (CubeDimension)this.dimensionMap.get(name);
    }

    public void setMeasures(Measure[] measures) {
        this.measures = measures;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Defmeasure[] getDefmeasures() {
        return this.defmeasures;
    }

    public void setDefmeasures(Defmeasure[] defmeasures) {
        this.defmeasures = defmeasures;
    }

    public Defmeasure getMeasure(String name) {
        return (Defmeasure)this.measureMap.get(name);
    }

    public void setDimensions(List list) {
        CubeDimension[] dimens = new CubeDimension[list.size()];
        this.dimensions = list.toArray(dimens);
    }

    public void setDefmeasures(List list) {
        Defmeasure[] mrs = new Defmeasure[list.size()];
        this.defmeasures = list.toArray(mrs);
    }

    public void setDeftemplates(List list) {
        this.objectConditionList = list;
    }

    public void setProfileQuery(boolean profile) {
        this.profile = profile;
    }

    public boolean profileQuery() {
        return this.profile;
    }

    public void setProfileIndex(boolean profile) {
        this.profileIndex = profile;
        int idx = 0;
        while (idx < this.dimensions.length) {
            this.dimensions[idx].setProfile(profile);
            ++idx;
        }
    }

    public boolean profileIndex() {
        return this.profileIndex;
    }

    public void addData(Fact[] data, Rete engine) {
        Index index = new Index(data);
        this.dataset.put(index, index);
        this.indexData(data, engine);
    }

    public void removeData(Fact[] data) {
        Index index = new Index(data);
        this.dataset.remove(index);
    }

    protected void indexData(Fact[] data, Rete engine) {
        Index index = new Index(data);
        int idx = 0;
        while (idx < this.dimensions.length) {
            if (this.dimensions[idx].isAutoIndex()) {
                this.dimensions[idx].indexData(index, engine);
            }
            ++idx;
        }
    }

    public Defrule getUpdateRule() {
        return this.updateRule;
    }

    public boolean compileCube(Rete engine) {
        ArrayList<Deftemplate> templatelist = new ArrayList<Deftemplate>();
        int idx = 0;
        while (idx < this.objectConditionList.size()) {
            ObjectCondition oc = (ObjectCondition)this.objectConditionList.get(idx);
            Deftemplate templ = (Deftemplate)engine.getCurrentFocus().getTemplate(oc.getTemplateName());
            if (templ == null) {
                return false;
            }
            oc.setTemplate(templ);
            templatelist.add(templ);
            ++idx;
        }
        Deftemplate[] tpl = new Deftemplate[this.objectConditionList.size()];
        this.templates = templatelist.toArray(tpl);
        this.compileBindings(engine);
        if (this.compileSuccessful) {
            this.configureDimensions(engine);
        }
        if (this.compileSuccessful) {
            this.configureMeasures(engine);
        }
        if (this.compileSuccessful) {
            this.createUpdateRule(engine);
        }
        return this.compileSuccessful;
    }

    protected void compileBindings(Rete engine) {
        int counter = 0;
        int idx = 0;
        while (idx < this.objectConditionList.size()) {
            ObjectCondition oc = (ObjectCondition)this.objectConditionList.get(idx);
            Constraint[] constraints = oc.getConstraints();
            Deftemplate template = this.templates[idx];
            int cx = 0;
            while (cx < constraints.length) {
                if (constraints[cx] instanceof BoundConstraint) {
                    BoundConstraint bc = (BoundConstraint)constraints[cx];
                    CubeBinding binding = new CubeBinding();
                    binding.setTemplateName(template.getName());
                    binding.setVarName(bc.getVariableName());
                    Slot slot = template.getSlot(bc.getName());
                    binding.setLeftIndex(slot.getId());
                    binding.setLeftRow(idx);
                    binding.setSlotName(bc.getName());
                    this.addBinding(binding);
                }
                ++counter;
                ++cx;
            }
            ++idx;
        }
    }

    public CubeBinding getBinding(String variableName) {
        return (CubeBinding)this.bindings.get(variableName);
    }

    public CubeBinding getBindingBySlot(String slotName) {
        return (CubeBinding)this.bindingsByName.get(slotName);
    }

    protected void addBinding(CubeBinding binding) {
        CubeBinding b = (CubeBinding)this.bindings.get(binding.getVarName());
        if (b == null) {
            this.bindings.put(binding.getVarName(), binding);
            this.bindingsByName.put(binding.getSlotName(), binding);
        } else {
            b.setJoin(true);
        }
    }

    protected void addMeasureBinding(CubeBinding binding) {
        this.bindingsByName.put(binding.getSlotName(), binding);
    }

    protected void configureDimensions(Rete engine) {
        int idx = 0;
        while (idx < this.dimensions.length) {
            CubeDimension dimension = this.dimensions[idx];
            CubeBinding binding = (CubeBinding)this.bindings.get(dimension.getVariableName());
            if (binding == null) {
                this.compileSuccessful = false;
                engine.writeMessage("Dimension " + dimension.getName() + " has an invalid binding " + dimension.getVariableName() + Constants.LINEBREAK);
                break;
            }
            dimension.setBinding(binding);
            dimension.setJoined(binding.isJoin());
            binding.setRightIndex(idx);
            this.dimensionMap.put(dimension.getName(), dimension);
            this.dimensionMapByBinding.put(dimension.getVariableName(), dimension);
            ++idx;
        }
    }

    protected void configureMeasures(Rete engine) {
        int dimensionsize = this.dimensions.length;
        int idx = 0;
        while (idx < this.defmeasures.length) {
            Defmeasure dmeasure = this.defmeasures[idx];
            Measure msr = engine.findMeasure(dmeasure.getMeasureName());
            if (msr != null) {
                dmeasure.setMeasure(msr);
                CubeDimension dimension = (CubeDimension)this.dimensionMapByBinding.get(dmeasure.getVariableName());
                if (dimension != null) {
                    dmeasure.setDimension(dimension);
                }
            } else {
                this.compileSuccessful = false;
                engine.writeMessage("Measure " + dmeasure.getMeasureName() + " does not exist. Please double check." + Constants.LINEBREAK);
                break;
            }
            CubeBinding dbinding = (CubeBinding)this.bindings.get(dmeasure.getVariableName());
            CubeBinding binding = new CubeBinding();
            binding.setTemplateName(this.name);
            binding.setSlotName(dmeasure.getMeasureLabel());
            binding.setMeasure(true);
            binding.setRightIndex(idx + dimensionsize);
            binding.setLeftIndex(dbinding.leftIndex);
            binding.setLeftRow(dbinding.leftrow);
            this.measureMap.put(dmeasure.getMeasureLabel(), dmeasure);
            this.addMeasureBinding(binding);
            ++idx;
        }
    }

    protected void createUpdateRule(Rete engine) {
        this.updateRule = new Defrule();
        this.updateRule.setName(RULE_PREFIX + this.name);
        this.updateRule.setSalience(10000);
        this.updateRule.setNoAgenda(true);
        int idx = 0;
        while (idx < this.objectConditionList.size()) {
            Condition c = (Condition)this.objectConditionList.get(idx);
            this.updateRule.addCondition(c);
            ++idx;
        }
        FunctionAction functionAction = new FunctionAction();
        functionAction.setFunctionName("cube-add-data");
        ValueParam p1 = new ValueParam();
        p1.setValue(this.name);
        Parameter[] params = new Parameter[]{p1};
        functionAction.setParameters(params);
        this.updateRule.addAction(functionAction);
        FunctionAction functionAction2 = new FunctionAction();
        functionAction2.setFunctionName("cube-delete-data");
        ValueParam p2 = new ValueParam();
        p2.setValue(this.name);
        Parameter[] params2 = new Parameter[]{p2};
        functionAction2.setParameters(params2);
        this.updateRule.addModificationAction(functionAction2);
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.name + Constants.LINEBREAK);
        int idx = 0;
        while (idx < this.dimensions.length) {
            buf.append("  (" + this.dimensions[idx].toPPString() + ")" + Constants.LINEBREAK);
            ++idx;
        }
        idx = 0;
        while (idx < this.defmeasures.length) {
            buf.append("  (" + this.defmeasures[idx].toPPString() + ")" + Constants.LINEBREAK);
            ++idx;
        }
        buf.append(")" + Constants.LINEBREAK);
        buf.append("size - " + this.dataset.size() + Constants.LINEBREAK);
        return buf.toString();
    }
}

