/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeDimension;
import org.jamocha.rete.CubeTemplate;
import org.jamocha.rete.Defmeasure;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.DimensionSlot;
import org.jamocha.rete.MeasureSlot;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Template;
import org.jamocha.rete.macro.PropertyMacros;
import org.jamocha.rete.macro.ReadMacro;
import org.jamocha.rete.macro.WriteMacro;
import org.jamocha.rete.util.ReflectionUtil;

public class Defclass
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class OBJECT_CLASS = null;
    private BeanInfo INFO = null;
    private PropertyDescriptor[] PROPS = null;
    private boolean ISBEAN = false;
    private Method addListener = null;
    private Method removeListener = null;
    private Map methods = new HashMap();
    private Map callMethods = new HashMap();
    private PropertyMacros[] macros = null;
    private boolean useMacros = false;

    public Defclass(Class obj) {
        this.OBJECT_CLASS = obj;
        this.init();
    }

    public void init() {
        try {
            this.INFO = Introspector.getBeanInfo(this.OBJECT_CLASS);
            PropertyDescriptor[] pd = this.INFO.getPropertyDescriptors();
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
            int idx = 0;
            while (idx < pd.length) {
                if (!pd[idx].getName().equals("class")) {
                    this.methods.put(pd[idx].getName(), pd[idx]);
                    list.add(pd[idx]);
                }
                ++idx;
            }
            PropertyDescriptor[] newpd = new PropertyDescriptor[list.size()];
            this.PROPS = list.toArray(newpd);
            if (this.checkBean()) {
                this.ISBEAN = true;
            }
            list.clear();
            pd = null;
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public void clear() {
        this.methods.clear();
        this.callMethods.clear();
        this.macros = null;
        this.PROPS = null;
        this.OBJECT_CLASS = null;
        this.INFO = null;
    }

    protected boolean checkBean() {
        this.getUtilMethods();
        return this.addListener != null && this.removeListener != null;
    }

    protected void getUtilMethods() {
        try {
            this.addListener = this.OBJECT_CLASS.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            this.removeListener = this.OBJECT_CLASS.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public boolean checkParameter(MethodDescriptor desc) {
        boolean ispcl = false;
        if (desc.getMethod().getParameterTypes().length == 1 && desc.getMethod().getParameterTypes()[0] == PropertyChangeListener.class) {
            ispcl = true;
        }
        return ispcl;
    }

    public boolean isJavaBean() {
        return this.ISBEAN;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.PROPS;
    }

    public BeanInfo getBeanInfo() {
        return this.INFO;
    }

    public Class getClassObject() {
        return this.OBJECT_CLASS;
    }

    public Object getSlotValue(int col, Object data) {
        if (this.useMacros) {
            return this.macros[col].getReadMacro().getProperty(data);
        }
        try {
            if (this.PROPS[col].getReadMethod() != null) {
                return this.PROPS[col].getReadMethod().invoke(data, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public Template createDeftemplate(String tempName) {
        Slot[] st = new Slot[this.PROPS.length];
        int idx = 0;
        while (idx < st.length) {
            if (this.PROPS[idx].getPropertyType().isArray()) {
                st[idx] = new MultiSlot(this.PROPS[idx].getName());
                st[idx].setId(idx);
            } else {
                st[idx] = new Slot(this.PROPS[idx].getName());
                st[idx].setValueType(ConversionUtils.getTypeCode(this.PROPS[idx].getPropertyType()));
                st[idx].setId(idx);
            }
            ++idx;
        }
        Deftemplate temp = new Deftemplate(tempName, this.OBJECT_CLASS.getName(), st);
        return temp;
    }

    public Template createDeftemplate(String tempName, Template parent) {
        this.reOrderDescriptors(parent);
        return this.createDeftemplate(tempName);
    }

    public Template createCubeTemplate(Cube cube) {
        BaseSlot s;
        CubeDimension[] dimensions = cube.getDimensions();
        Defmeasure[] defmeasures = cube.getDefmeasures();
        BaseSlot[] slots = new BaseSlot[dimensions.length + defmeasures.length + 1];
        int counter = 0;
        int idx = 0;
        while (idx < dimensions.length) {
            s = new DimensionSlot(dimensions[idx]);
            s.setId(idx);
            slots[idx] = s;
            ++counter;
            ++idx;
        }
        idx = 0;
        while (idx < defmeasures.length) {
            s = new MeasureSlot(defmeasures[idx]);
            s.setId(counter);
            slots[counter] = s;
            ++counter;
            ++idx;
        }
        int lastslot = slots.length - 1;
        s = new Slot();
        s.setName("dataset");
        s.setId(lastslot);
        slots[lastslot] = s;
        CubeTemplate templ = new CubeTemplate(cube.getName(), this.OBJECT_CLASS.getName(), slots);
        return templ;
    }

    protected void reOrderDescriptors(Template parent) {
        ArrayList<String> desc = null;
        boolean add = false;
        PropertyDescriptor[] newprops = new PropertyDescriptor[this.PROPS.length];
        BaseSlot[] pslots = parent.getAllSlots();
        if (newprops.length > pslots.length) {
            desc = new ArrayList<String>();
            add = true;
        }
        int idx = 0;
        while (idx < pslots.length) {
            newprops[idx] = this.getDescriptor(pslots[idx].getName());
            if (add) {
                desc.add(pslots[idx].getName());
            }
            ++idx;
        }
        if (add) {
            ArrayList<PropertyDescriptor> newfields = new ArrayList<PropertyDescriptor>();
            int idz = 0;
            while (idz < this.PROPS.length) {
                if (!desc.contains(this.PROPS[idz].getName())) {
                    newfields.add(this.PROPS[idz]);
                }
                ++idz;
            }
            int c = 0;
            int n = pslots.length;
            while (n < newprops.length) {
                newprops[n] = (PropertyDescriptor)newfields.get(c);
                ++c;
                ++n;
            }
        }
        this.PROPS = newprops;
    }

    protected PropertyDescriptor getDescriptor(String name) {
        PropertyDescriptor pd = null;
        int idx = 0;
        while (idx < this.PROPS.length) {
            if (this.PROPS[idx].getName().equals(name)) {
                pd = this.PROPS[idx];
                break;
            }
            ++idx;
        }
        return pd;
    }

    public Method getAddListenerMethod() {
        return this.addListener;
    }

    public Method getRemoveListenerMethod() {
        return this.removeListener;
    }

    public Method getWriteMethod(String name) {
        Object method = this.methods.get(name);
        if (method != null) {
            return ((PropertyDescriptor)method).getWriteMethod();
        }
        return null;
    }

    public Method getReadMethod(String name) {
        Object method = this.methods.get(name);
        if (method != null) {
            return ((PropertyDescriptor)method).getReadMethod();
        }
        return null;
    }

    public Method getCallMethod(String name, Object[] parameters) {
        Method m;
        String key = String.valueOf(name) + "(";
        Object[] cparams = new Class[]{};
        if (parameters != null) {
            cparams = new Class[parameters.length];
            int idx = 0;
            while (idx < parameters.length) {
                if (idx > 0) {
                    key = String.valueOf(key) + ",";
                }
                key = String.valueOf(key) + parameters[idx].getClass();
                cparams[idx] = parameters[idx].getClass();
                ++idx;
            }
        }
        if ((m = (Method)this.callMethods.get(key = String.valueOf(key) + ")")) != null) {
            return m;
        }
        m = ReflectionUtil.findMethod(this, name, cparams);
        if (m != null) {
            this.callMethods.put(key, m);
        }
        return m;
    }

    public void loadMacros(ClassLoader cl) {
        String packageName = this.OBJECT_CLASS.getName().toLowerCase();
        ArrayList<PropertyMacros> macrolist = new ArrayList<PropertyMacros>();
        int idx = 0;
        while (idx < this.PROPS.length) {
            PropertyMacros macro = new PropertyMacros();
            try {
                String pname = this.PROPS[idx].getName();
                String formattedName = String.valueOf(pname.substring(0, 1).toUpperCase()) + pname.substring(1);
                String read = String.valueOf(packageName) + ".Read" + formattedName;
                Class<?> rclzz = cl.loadClass(read);
                ReadMacro rmacro = (ReadMacro)rclzz.newInstance();
                macro.setReadMacro(rmacro);
                String write = String.valueOf(packageName) + ".Write" + formattedName;
                Class<?> wclzz = cl.loadClass(write);
                WriteMacro wmacro = (WriteMacro)wclzz.newInstance();
                macro.setWriteMacro(wmacro);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            macrolist.add(macro);
            ++idx;
        }
        if (this.PROPS.length == macrolist.size()) {
            PropertyMacros[] allmacros = new PropertyMacros[this.PROPS.length];
            allmacros = macrolist.toArray(allmacros);
            this.macros = allmacros;
            this.useMacros = true;
        }
    }

    public Defclass cloneDefclass(Rete engine) {
        Defclass dcl = new Defclass(this.OBJECT_CLASS);
        dcl.addListener = this.addListener;
        dcl.INFO = this.INFO;
        dcl.ISBEAN = this.ISBEAN;
        dcl.PROPS = this.PROPS;
        dcl.removeListener = this.removeListener;
        dcl.methods = engine.newLocalMap();
        dcl.methods.putAll(this.methods);
        return dcl;
    }
}

