/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jamocha.rete.Agenda;
import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.AlphaMemoryImpl;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeHashMemoryImpl;
import org.jamocha.rete.CubeQueryBNode;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.DefglobalMap;
import org.jamocha.rete.Defmodule;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.ExistJoin;
import org.jamocha.rete.ExistNeqJoin;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.HashedEqBNode;
import org.jamocha.rete.HashedEqNJoin;
import org.jamocha.rete.HashedNeqAlphaMemory;
import org.jamocha.rete.HashedNotEqBNode;
import org.jamocha.rete.HashedNotEqNJoin;
import org.jamocha.rete.Index;
import org.jamocha.rete.Module;
import org.jamocha.rete.NSFact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.RootNode;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Scope;
import org.jamocha.rete.Strategy;
import org.jamocha.rete.Template;
import org.jamocha.rete.TemporalEqNode;
import org.jamocha.rete.TemporalFact;
import org.jamocha.rete.TemporalHashedAlphaMem;
import org.jamocha.rete.TemporalIntervalNode;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.query.QueryCubeQueryJoin;
import org.jamocha.rete.query.QueryExistJoin;
import org.jamocha.rete.query.QueryExistNeqJoin;
import org.jamocha.rete.query.QueryHashedEqJoin;
import org.jamocha.rete.query.QueryHashedEqNot;
import org.jamocha.rete.query.QueryHashedNeqJoin;
import org.jamocha.rete.query.QueryHashedNeqNot;
import org.jamocha.rete.strategies.Strategies;
import org.jamocha.rete.util.ProfileStats;

public class DefaultWM
implements WorkingMemory,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Rete engine = null;
    protected RootNode root = null;
    protected Map alphaMemories = null;
    protected Map betaLeftMemories = null;
    protected Map betaRightMemories = null;
    protected Map terminalMemories = null;
    protected Map queryLeftMemories = null;
    protected Map queryRightMemories = null;
    protected RuleCompiler compiler = null;
    protected Map staticFacts = null;
    protected Map dynamicFacts = null;
    protected Map deffactMap = null;
    protected DefglobalMap defglobals = null;
    protected ArrayList initialFacts = new ArrayList();
    private Agenda agenda = null;
    protected Map modules = null;
    protected Map cubes = null;
    protected Hashtable contexts = new Hashtable();
    protected ArrayList focusStack = new ArrayList();
    private Module main = null;
    private Module currentModule = null;
    private Strategy theStrat = null;
    private Stack scopes = new Stack();
    private boolean watchFact = false;
    private boolean watchRules = false;
    private boolean profileFire = false;
    private boolean profileAssert = false;
    private boolean profileRetract = false;

    public DefaultWM(Rete engine, RootNode node, RuleCompiler compiler) {
        this.engine = engine;
        this.alphaMemories = engine.newMap();
        this.betaLeftMemories = engine.newMap();
        this.betaRightMemories = engine.newMap();
        this.terminalMemories = engine.newMap();
        this.staticFacts = engine.newLocalMap();
        this.dynamicFacts = engine.newLocalMap();
        this.deffactMap = engine.newLocalMap();
        this.modules = engine.newLocalMap();
        this.cubes = engine.newLocalMap();
        this.defglobals = new DefglobalMap(engine);
        this.root = node;
        this.compiler = compiler;
        this.compiler.setWorkingMemory(this);
        this.agenda = new Agenda(engine);
        this.init();
    }

    protected void init() {
        this.theStrat = Strategies.DEPTH;
        this.main = new Defmodule("MAIN", this.engine);
        this.main.setStrategy(this.theStrat);
        this.addModule(this.main);
        this.currentModule = this.main;
    }

    public Module addModule(String name) {
        Module mod = this.findModule(name);
        if (mod == null) {
            mod = new Defmodule(name, this.engine);
            this.modules.put(mod.getModuleName(), mod);
            this.setCurrentModule(mod);
        }
        return mod;
    }

    public void addModule(Module mod) {
        if (mod != null) {
            this.modules.put(mod.getModuleName(), mod);
            this.setCurrentModule(mod);
        }
    }

    public Collection getModules() {
        return this.modules.values();
    }

    public void addCube(Cube cube) {
        if (!this.cubes.containsKey(cube.getName())) {
            this.cubes.put(cube.getName(), cube);
        }
    }

    public Cube getCube(String name) {
        return (Cube)this.cubes.get(name);
    }

    public Cube removeCube(String name) {
        return (Cube)this.cubes.remove(name);
    }

    public List getCubes() {
        return new ArrayList(this.cubes.keySet());
    }

    public void assertFact(Fact fact) throws AssertException {
        Fact f = fact;
        if (!this.containsFact(f)) {
            this.deffactMap.put(fact.equalityIndex(), f);
            f.setFactId(this.engine);
            if (this.profileAssert) {
                this.assertFactWProfile(f);
            } else {
                if (this.watchFact) {
                    this.engine.writeMessage("==> " + fact.toFactString() + Constants.LINEBREAK, "t");
                }
                this.root.assertObject(f, this.engine, this);
            }
        } else {
            f.resetID((Fact)this.deffactMap.get(fact.equalityIndex()));
        }
    }

    public void assertFact(TemporalFact fact, Date effectiveTime, Date expirationTime) throws AssertException {
        if (expirationTime != null) {
            fact.setEffectiveTime(effectiveTime.getTime());
            fact.setExpirationTime(expirationTime.getTime());
        }
        this.assertFact(fact);
    }

    public void assertObject(Object data, String template, boolean statc, boolean shadow) throws AssertException {
        Defclass dc = null;
        if (template == null) {
            dc = this.engine.findDefclass(data);
            if (data instanceof Cube) {
                dc = this.engine.findDefclassByTemplate(((Cube)data).getName());
            }
        } else {
            dc = this.engine.findDefclassByTemplate(template);
        }
        if (dc != null) {
            if (statc && !this.getStaticFacts().containsKey(data)) {
                Fact shadowfact = this.createFact(data, dc, template, this.engine.nextFactId(), false);
                this.getStaticFacts().put(data, shadowfact);
                this.assertFact(shadowfact);
            } else if (!this.getDynamicFacts().containsKey(data)) {
                if (shadow) {
                    if (dc.isJavaBean()) {
                        try {
                            dc.getAddListenerMethod().invoke(data, this.engine);
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    Fact shadowfact = this.createFact(data, dc, template, this.engine.nextFactId(), false);
                    this.getDynamicFacts().put(data, shadowfact);
                    this.assertFact(shadowfact);
                } else {
                    Fact nsfact = this.createNSFact(data, dc, this.engine.nextFactId());
                    this.getDynamicFacts().put(data, nsfact);
                    this.assertFact(nsfact);
                }
            }
        }
    }

    public void assertTemporalObject(Object data, String template, Date effective, Date expiration, boolean statc) throws AssertException {
        Defclass dc = null;
        dc = template == null ? this.engine.findDefclass(data) : this.engine.findDefclassByTemplate(template);
        if (dc != null) {
            if (statc && !this.getStaticFacts().containsKey(data)) {
                Fact shadowfact = this.createFact(data, dc, template, this.engine.nextFactId(), true);
                this.getStaticFacts().put(data, shadowfact);
                this.assertFact(shadowfact);
            } else if (!this.getDynamicFacts().containsKey(data)) {
                if (dc.isJavaBean()) {
                    try {
                        dc.getAddListenerMethod().invoke(data, this.engine);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                TemporalFact shadowfact = (TemporalFact)this.createFact(data, dc, template, this.engine.nextFactId(), true);
                shadowfact.setEffectiveTime(effective.getTime());
                shadowfact.setExpirationTime(expiration.getTime());
                this.getDynamicFacts().put(data, shadowfact);
                this.assertFact(shadowfact);
            }
        }
    }

    public void assertObjects(List objs) throws AssertException {
        for (Object fact : objs) {
            this.assertObject(fact, null, false, true);
        }
    }

    public void clear() {
        for (AlphaMemory am : this.alphaMemories.values()) {
            am.clear();
        }
        this.alphaMemories.clear();
        for (Object bval : this.betaLeftMemories.values()) {
            if (!(bval instanceof Map)) continue;
            Map lmem = (Map)bval;
            for (Object value : lmem.keySet()) {
                if (value instanceof Index) {
                    Index indx = (Index)value;
                    indx.clear();
                    continue;
                }
                if (!(value instanceof Map)) continue;
                ((Map)value).clear();
            }
            lmem.clear();
        }
        this.betaLeftMemories.clear();
        for (Object val : this.betaRightMemories.values()) {
            if (val instanceof HashedAlphaMemoryImpl) {
                ((HashedAlphaMemoryImpl)val).clear();
                continue;
            }
            if (val instanceof TemporalHashedAlphaMem) {
                ((TemporalHashedAlphaMem)val).clear();
                continue;
            }
            if (val instanceof CubeHashMemoryImpl) {
                ((CubeHashMemoryImpl)val).clear();
                continue;
            }
            Map mem = (Map)val;
            mem.clear();
        }
        this.betaRightMemories.clear();
        this.terminalMemories.clear();
        this.root.clear();
        this.focusStack.clear();
        this.contexts.clear();
        this.agenda.clear();
        this.main.clear();
        Collection mods = this.modules.values();
        Iterator mitr = mods.iterator();
        while (mitr.hasNext()) {
            ((Module)mitr.next()).clear();
        }
        this.cubes.clear();
        this.addModule(this.main);
    }

    public void clearFacts() {
        if (this.getDynamicFacts().size() > 0) {
            try {
                for (Object obj : this.getDynamicFacts().keySet()) {
                    if (!(obj instanceof Fact)) continue;
                    this.retractFact((Fact)obj);
                }
                this.getDynamicFacts().clear();
            }
            catch (RetractException itr) {
                // empty catch block
            }
        }
        if (this.getStaticFacts().size() > 0) {
            try {
                for (Object obj : this.getStaticFacts().keySet()) {
                    if (!(obj instanceof Fact)) continue;
                    this.retractFact((Fact)obj);
                }
                this.getStaticFacts().clear();
            }
            catch (RetractException retractException) {
                // empty catch block
            }
        }
    }

    public synchronized void clearObjects() {
        ArrayList objects2;
        if (this.getDynamicFacts().size() > 0) {
            try {
                objects2 = new ArrayList(this.dynamicFacts.keySet());
                for (Object obj : objects2) {
                    this.retractObject(obj);
                }
            }
            catch (RetractException objects2) {
                // empty catch block
            }
        }
        if (this.getStaticFacts().size() > 0) {
            try {
                objects2 = new ArrayList(this.getStaticFacts().keySet());
                for (Object obj : objects2) {
                    this.retractObject(obj);
                }
            }
            catch (RetractException retractException) {
                // empty catch block
            }
        }
    }

    protected Fact createFact(Object data, Defclass dclass, String template, long id, boolean temporal) throws AssertException {
        Fact ft = null;
        Template dft = null;
        dft = template == null ? (data instanceof Cube ? this.getCurrentFocus().getTemplate(((Cube)data).getName()) : this.getCurrentFocus().getTemplate(dclass.getClassObject().getName())) : this.getCurrentFocus().getTemplate(template);
        if (dft == null) {
            for (Module mod : this.modules.values()) {
                if (!mod.containsTemplate(dclass)) continue;
                dft = mod.getTemplate(dclass);
                break;
            }
            if (dft == null && this.main.containsTemplate(dclass)) {
                dft = this.main.getTemplate(dclass);
            }
            if (dft == null) {
                throw new AssertException("Could not find the template");
            }
        }
        ft = temporal ? dft.createTemporalFact(data, dclass, id) : dft.createFact(data, dclass, id);
        return ft;
    }

    protected Fact createNSFact(Object data, Defclass dclass, long id) {
        Deftemplate dft = (Deftemplate)this.getCurrentFocus().getTemplate(dclass);
        NSFact fact = new NSFact(dft, dclass, data, dft.getAllSlots(), id);
        return fact;
    }

    public Module findModule(String name) {
        return (Module)this.modules.get(name);
    }

    public Map getAllAlphaMemories() {
        return this.alphaMemories;
    }

    public Object getAlphaMemory(Object key) {
        Object m = this.alphaMemories.get(key);
        if (m == null) {
            String mname = "alphamem" + ((BaseNode)key).nodeID;
            m = new AlphaMemoryImpl(mname, this.engine);
            this.alphaMemories.put(key, m);
        }
        return m;
    }

    public Map getAllBetaLeftMemories() {
        return this.betaLeftMemories;
    }

    public Object getBetaLeftMemory(Object key) {
        Object m = this.betaLeftMemories.get(key);
        if (m == null) {
            String mname = "blmem" + ((BaseNode)key).nodeID;
            m = this.engine.newBetaMemoryMap(mname);
            this.betaLeftMemories.put(key, m);
        }
        return m;
    }

    public Object getQueryBetaMemory(Object key) {
        Object m = this.queryLeftMemories.get(key);
        if (m == null) {
            String mname = "query" + ((BaseNode)key).nodeID;
            m = this.engine.newBetaMemoryMap(mname);
            this.queryLeftMemories.put(key, m);
        }
        return m;
    }

    public Map getAllBetaRightMemories() {
        return this.betaRightMemories;
    }

    public Object getBetaRightMemory(Object key) {
        Object val = this.betaRightMemories.get(key);
        if (val != null) {
            return val;
        }
        if (key instanceof HashedEqBNode || key instanceof HashedEqNJoin || key instanceof ExistJoin) {
            String mname = "hnode" + ((BaseNode)key).nodeID;
            HashedAlphaMemoryImpl alpha = new HashedAlphaMemoryImpl(mname, this.engine);
            this.betaRightMemories.put(key, alpha);
            return alpha;
        }
        if (key instanceof HashedNotEqBNode || key instanceof HashedNotEqNJoin || key instanceof ExistNeqJoin) {
            String mname = "hneq" + ((BaseNode)key).nodeID;
            HashedNeqAlphaMemory alpha = new HashedNeqAlphaMemory(mname, this.engine);
            this.betaRightMemories.put(key, alpha);
            return alpha;
        }
        if (key instanceof TemporalEqNode || key instanceof TemporalIntervalNode) {
            String mname = "hnode" + ((BaseNode)key).nodeID;
            TemporalHashedAlphaMem alpha = new TemporalHashedAlphaMem(mname, this.engine);
            this.betaRightMemories.put(key, alpha);
            return alpha;
        }
        if (key instanceof CubeQueryBNode) {
            String mname = "cqbnode" + ((BaseNode)key).nodeID;
            CubeHashMemoryImpl alpha = new CubeHashMemoryImpl(mname, this.engine);
            this.betaRightMemories.put(key, alpha);
            return alpha;
        }
        String mname = "brmem" + ((BaseNode)key).nodeID;
        Map right = this.engine.newAlphaMemoryMap(mname);
        this.betaRightMemories.put(key, right);
        return right;
    }

    public Object getQueryRightMemory(Object key) {
        if (key instanceof QueryHashedEqJoin || key instanceof QueryHashedEqNot || key instanceof QueryExistJoin) {
            String mname = "hnode" + ((BaseNode)key).nodeID;
            HashedAlphaMemoryImpl alpha = new HashedAlphaMemoryImpl(mname, this.engine);
            this.queryRightMemories.put(key, alpha);
            return alpha;
        }
        if (key instanceof QueryHashedNeqJoin || key instanceof QueryHashedNeqNot || key instanceof QueryExistNeqJoin) {
            String mname = "hneq" + ((BaseNode)key).nodeID;
            HashedNeqAlphaMemory alpha = new HashedNeqAlphaMemory(mname, this.engine);
            this.queryRightMemories.put(key, alpha);
            return alpha;
        }
        if (key instanceof QueryCubeQueryJoin) {
            String mname = "cqbnode" + ((BaseNode)key).nodeID;
            CubeHashMemoryImpl alpha = new CubeHashMemoryImpl(mname, this.engine);
            this.queryRightMemories.put(key, alpha);
            return alpha;
        }
        String mname = "brmem" + ((BaseNode)key).nodeID;
        Map right = this.engine.newAlphaMemoryMap(mname);
        this.queryRightMemories.put(key, right);
        return right;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public Object getBinding(String name) {
        if (!this.scopes.isEmpty() && !name.startsWith("*")) {
            Object val = ((Scope)this.scopes.peek()).getBindingValue(name);
            return val;
        }
        return this.getDefglobals().getValue(name);
    }

    public Map getDeffactMap() {
        return this.deffactMap;
    }

    public DefglobalMap getDefglobals() {
        return this.defglobals;
    }

    public List getAllFacts() {
        ArrayList facts = new ArrayList();
        facts.addAll(this.getDeffacts());
        return facts;
    }

    public List getDeffacts() {
        ArrayList objects = new ArrayList();
        for (Object fact : this.getDeffactMap().values()) {
            objects.add(fact);
        }
        return objects;
    }

    public Fact getFactById(long id) {
        Fact df2 = null;
        for (Fact df2 : this.getDeffactMap().values()) {
            if (df2.getFactId() != id) continue;
            return df2;
        }
        if (df2 == null) {
            for (Fact df2 : this.getDynamicFacts().values()) {
                if (df2.getFactId() != id) continue;
                return df2;
            }
            if (df2 == null) {
                for (Fact df2 : this.getStaticFacts().values()) {
                    if (df2.getFactId() != id) continue;
                    return df2;
                }
            }
        }
        return null;
    }

    public List getObjects() {
        ArrayList objects = new ArrayList();
        for (Object key : this.getDynamicFacts().keySet()) {
            if (key instanceof Fact) continue;
            objects.add(key);
        }
        for (Object key : this.getStaticFacts().keySet()) {
            if (key instanceof Fact) continue;
            objects.add(key);
        }
        return objects;
    }

    public List getInitialFacts() {
        return this.initialFacts;
    }

    public Module getCurrentFocus() {
        return this.currentModule;
    }

    public Module getMain() {
        return this.main;
    }

    public Map getDynamicFacts() {
        return this.dynamicFacts;
    }

    public RuleCompiler getRuleCompiler() {
        return this.compiler;
    }

    public Map getStaticFacts() {
        return this.staticFacts;
    }

    public Strategy getStrategy() {
        return this.theStrat;
    }

    public Object getTerminalMemory(Object key) {
        Object m = this.terminalMemories.get(key);
        if (m == null) {
            m = this.engine.newTerminalMap();
            this.terminalMemories.put(key, m);
        }
        return m;
    }

    public void modifyObject(Object data) throws AssertException, RetractException {
        if (this.getDynamicFacts().containsKey(data)) {
            Defclass dc = this.engine.findDefclass(data);
            Fact ft = (Fact)this.getDynamicFacts().remove(data);
            boolean temporal = false;
            if (ft instanceof TemporalFact) {
                temporal = true;
            }
            String tname = ft.getDeftemplate().getName();
            long fid = ft.getFactId();
            this.retractFact(ft);
            ft = this.createFact(data, dc, tname, fid, temporal);
            this.getDynamicFacts().put(data, ft);
            this.assertFact(ft);
        }
    }

    public boolean profileAssert() {
        return this.profileAssert;
    }

    public boolean profileFire() {
        return this.profileFire;
    }

    public boolean profileRetract() {
        return this.profileRetract;
    }

    public boolean watchFact() {
        return this.watchFact;
    }

    public boolean watchRules() {
        return this.watchRules;
    }

    public void popScope() {
        this.scopes.pop();
    }

    public void pushScope(Scope s) {
        this.scopes.push(s);
    }

    public void removeAlphaMemory(Object key) {
        this.alphaMemories.remove(key);
    }

    public Module removeModule(String name) {
        return (Module)this.modules.remove(name);
    }

    public void retractFact(Fact fact) throws RetractException {
        this.deffactMap.remove(fact.equalityIndex());
        if (this.profileRetract) {
            this.retractFactWProfile(fact);
        } else {
            if (this.watchFact) {
                this.engine.writeMessage("<== " + fact.toFactString() + Constants.LINEBREAK, "t");
            }
            this.root.retractObject(fact, this.engine, this);
        }
    }

    public synchronized void retractObject(Object data) throws RetractException {
        if (this.getStaticFacts().containsKey(data)) {
            Fact ft = (Fact)this.getStaticFacts().remove(data);
            this.retractFact(ft);
            if (ft.getObjectInstance() == null) {
                ft.clear();
            }
        } else if (this.getDynamicFacts().containsKey(data)) {
            Fact ft = (Fact)this.getDynamicFacts().remove(data);
            this.retractFact(ft);
            if (ft.getObjectInstance() == null) {
                ft.clear();
            }
        }
    }

    public void setBindingValue(String key, Object value) {
        if (!this.scopes.isEmpty() && !key.startsWith("*")) {
            ((Scope)this.scopes.peek()).setBindingValue(key, value);
        } else {
            this.getDefglobals().declareDefglobal(key, value);
        }
    }

    public void setCurrentModule(Module mod) {
        this.currentModule = mod;
    }

    public void setProfileAssert(boolean profileAssert) {
        this.profileAssert = profileAssert;
    }

    public void setProfileFire(boolean profileFire) {
        this.profileFire = profileFire;
    }

    public void setProfileRetract(boolean profileRetract) {
        this.profileRetract = profileRetract;
    }

    public void setStrategy(Strategy strategy) {
        this.theStrat = strategy;
        this.getCurrentFocus().setStrategy(strategy);
    }

    public void setWatchFact(boolean watchFact) {
        this.watchFact = watchFact;
    }

    public void setWatchRules(boolean watchRules) {
        this.watchRules = watchRules;
    }

    protected void assertFactWProfile(Fact fact) throws AssertException {
        ProfileStats.startAssert();
        this.root.assertObject(fact, this.engine, this);
        ProfileStats.endAssert();
    }

    public boolean containsFact(Fact fact) {
        return this.deffactMap.containsKey(fact.equalityIndex());
    }

    protected void retractFactWProfile(Fact fact) throws RetractException {
        ProfileStats.startRetract();
        this.root.retractObject(fact, this.engine, this);
        ProfileStats.endRetract();
    }
}

