/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.AlphaNode;
import org.jamocha.rete.AlphaNodeAnd;
import org.jamocha.rete.AlphaNodeOr;
import org.jamocha.rete.AlphaNodePredConstr;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.CompileEvent;
import org.jamocha.rete.CompilerListener;
import org.jamocha.rete.Constants;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.IFLIANode;
import org.jamocha.rete.InitialFact;
import org.jamocha.rete.IntraFactNode;
import org.jamocha.rete.LIANode;
import org.jamocha.rete.MLTerminalNode;
import org.jamocha.rete.Messages;
import org.jamocha.rete.Module;
import org.jamocha.rete.NoAgendaTNode;
import org.jamocha.rete.NoAgendaTNode2;
import org.jamocha.rete.NoMemANode;
import org.jamocha.rete.NoMemAnd;
import org.jamocha.rete.NoMemOr;
import org.jamocha.rete.NumericAlphaNode;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Slot2;
import org.jamocha.rete.Template;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.TerminalNode2;
import org.jamocha.rete.TerminalNode3;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rule.Action;
import org.jamocha.rule.AndCondition;
import org.jamocha.rule.AndLiteralConstraint;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.LiteralConstraint;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.OrLiteralConstraint;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Rule;
import org.jamocha.rule.Summary;
import org.jamocha.rule.TemplateValidation;

public class DefaultRuleCompiler
implements RuleCompiler {
    private static final long serialVersionUID = 1L;
    private WorkingMemory memory = null;
    private Rete engine = null;
    private Map inputnodes = null;
    private Module currentMod = null;
    private ArrayList listener = new ArrayList();
    protected boolean validate = true;
    protected TemplateValidation tval = null;
    public static final String FUNCTION_NOT_FOUND = Messages.getString("CompilerProperties.function.not.found");
    public static final String INVALID_FUNCTION = Messages.getString("CompilerProperties.invalid.function");
    public static final String ASSERT_ON_PROPOGATE = Messages.getString("CompilerProperties.assert.on.add");
    protected Logger log = LogFactory.createLogger(DefaultRuleCompiler.class);

    public DefaultRuleCompiler(Rete engine, Map inputNodes) {
        this.engine = engine;
        this.inputnodes = inputNodes;
        this.tval = new TemplateValidation(engine);
    }

    public void setValidateRule(boolean valid) {
        this.validate = valid;
    }

    public boolean getValidateRule() {
        return this.validate;
    }

    public void setWorkingMemory(WorkingMemory wm) {
        this.memory = wm;
    }

    public boolean addRule(Rule rule) {
        rule.resolveTemplates(this.engine);
        rule.getComplexity().calculateComplexity();
        if (!this.validate || this.validate && this.tval.analyze(rule) == 1001) {
            if (rule.getConditions() != null && rule.getConditions().length > 0) {
                this.setModule(rule);
                try {
                    Condition[] conds = this.getRuleConditions(rule);
                    int counter = 0;
                    int idx = 0;
                    while (idx < conds.length) {
                        Condition con = conds[idx];
                        con.getCompiler(this).compile(con, counter, rule, rule.getRememberMatch());
                        if (con instanceof ObjectCondition && !((ObjectCondition)con).getNegated()) {
                            ++counter;
                        }
                        ++idx;
                    }
                    this.compileJoins(rule, conds);
                    BaseNode last = rule.getLastNode();
                    TerminalNode tnode = this.createTerminalNode(rule);
                    this.attachTerminalNode(last, tnode);
                    this.compileActions(rule, rule.getActions());
                    this.compileActions(rule, rule.getModificationActions());
                    this.currentMod.addRule(rule);
                    CompileEvent ce = new CompileEvent(rule, 0);
                    ce.setRule(rule);
                    ce.setMessage("Complexity: " + rule.getComplexity().getValue());
                    this.notifyListener(ce);
                    return true;
                }
                catch (AssertException e) {
                    CompileEvent ce = new CompileEvent(rule, 3);
                    ce.setMessage(Messages.getString("RuleCompiler.assert.error"));
                    this.notifyListener(ce);
                    this.log.debug(e);
                    return false;
                }
            }
            if (rule.getConditions().length == 0) {
                this.setModule(rule);
                BaseNode last = (BaseNode)this.inputnodes.get(this.engine.initFact);
                TerminalNode tnode = this.createTerminalNode(rule);
                this.compileActions(rule, rule.getActions());
                this.attachTerminalNode(last, tnode);
                this.currentMod.addRule(rule);
                CompileEvent ce = new CompileEvent(rule, 0);
                ce.setRule(rule);
                this.notifyListener(ce);
                return true;
            }
            return false;
        }
        Summary error = this.tval.getErrors();
        this.engine.writeMessage("Rule " + rule.getName() + " was not added. ", Constants.DEFAULT_OUTPUT);
        this.engine.writeMessage(error.getMessage(), Constants.DEFAULT_OUTPUT);
        Summary warn = this.tval.getWarnings();
        this.engine.writeMessage(warn.getMessage(), Constants.DEFAULT_OUTPUT);
        return false;
    }

    public Condition[] getRuleConditions(Rule rule) {
        Condition[] conditions = rule.getConditions();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        boolean hasAnd = false;
        int idx = 0;
        while (idx < conditions.length) {
            if (conditions[idx] instanceof AndCondition) {
                AndCondition and = (AndCondition)conditions[idx];
                conditionList.addAll(and.getNestedConditionalElement());
                hasAnd = true;
            } else {
                conditionList.add(conditions[idx]);
            }
            ++idx;
        }
        if (hasAnd) {
            Condition[] newlist = new Condition[conditionList.size()];
            conditions = conditionList.toArray(newlist);
        }
        return conditions;
    }

    public void setModule(Rule rule) {
        if (rule.getName().indexOf("::") > 0) {
            String text = rule.getName();
            String[] sp = text.split("::");
            rule.setName(sp[1]);
            String modName = sp[0].toUpperCase();
            this.currentMod = this.engine.findModule(modName);
            if (this.currentMod == null) {
                this.engine.addModule(modName, false);
                this.currentMod = this.engine.findModule(modName);
            }
        } else {
            this.currentMod = this.engine.getCurrentFocus();
        }
        rule.setModule(this.currentMod);
    }

    protected TerminalNode createTerminalNode(Rule rl) {
        if (rl.getModificationActions() != null && rl.getModificationActions().length > 0) {
            MLTerminalNode tnode = new MLTerminalNode(this.engine.nextNodeId(), rl);
            tnode.setNoAgenda(rl.getNoAgenda());
            return tnode;
        }
        if (rl.getNoAgenda() && rl.getExpirationDate() == 0L) {
            return new NoAgendaTNode(this.engine.nextNodeId(), rl);
        }
        if (rl.getNoAgenda() && rl.getExpirationDate() > 0L) {
            return new NoAgendaTNode2(this.engine.nextNodeId(), rl);
        }
        if (rl.getExpirationDate() > 0L) {
            return new TerminalNode3(this.engine.nextNodeId(), rl);
        }
        return new TerminalNode2(this.engine.nextNodeId(), rl);
    }

    public void addObjectTypeNode(ObjectTypeNode node) {
        if (!this.inputnodes.containsKey(node.getDeftemplate())) {
            this.inputnodes.put(node.getDeftemplate(), node);
        }
        if (node.getDeftemplate() instanceof InitialFact) {
            try {
                IFLIANode lian = new IFLIANode(this.engine.nextNodeId());
                node.addSuccessorNode(lian, this.engine, this.engine.workingMem);
            }
            catch (AssertException assertException) {
                // empty catch block
            }
        }
    }

    public void removeObjectTypeNode(ObjectTypeNode node) {
        this.inputnodes.remove(node.getDeftemplate());
        node.clear(this.memory);
        node.clearSuccessors();
    }

    public ObjectTypeNode getObjectTypeNode(Template template) {
        return (ObjectTypeNode)this.inputnodes.get(template);
    }

    public ObjectTypeNode findObjectTypeNode(String templateName) {
        Iterator itr = this.inputnodes.keySet().iterator();
        Template tmpl = null;
        while (itr.hasNext()) {
            tmpl = (Template)itr.next();
            if (tmpl.getName().equals(templateName)) break;
        }
        if (tmpl != null) {
            return (ObjectTypeNode)this.inputnodes.get(tmpl);
        }
        this.log.debug(Messages.getString("RuleCompiler.deftemplate.error"));
        return null;
    }

    public void addListener(CompilerListener listener) {
        if (!this.listener.contains(listener)) {
            this.listener.add(listener);
        }
    }

    public void removeListener(CompilerListener listener) {
        this.listener.remove(listener);
    }

    public Rete getEngine() {
        return this.engine;
    }

    public WorkingMemory getMemory() {
        return this.memory;
    }

    public BaseAlpha2 compileConstraint(LiteralConstraint cnstr, Template templ, Rule rule) {
        BaseAlpha2 current = null;
        if (templ.getSlot(cnstr.getName()) != null) {
            Object sval;
            Slot sl = (Slot)templ.getSlot(cnstr.getName()).clone();
            sl.value = sval = ConversionUtils.convert(sl.getValueType(), cnstr.getValue());
            current = rule.getRememberMatch() ? new AlphaNode(this.engine.nextNodeId()) : new NoMemANode(this.engine.nextNodeId());
            current.setSlot(sl);
            current.setOperator(9);
            current.incrementUseCount();
            templ.getSlot(sl.getId()).incrementNodeCount();
        }
        return current;
    }

    public BaseAlpha2 compileConstraint(AndLiteralConstraint cnstr, Template templ, Rule rule) {
        BaseAlpha2 current = null;
        if (templ.getSlot(cnstr.getName()) != null) {
            Slot2 sl = new Slot2(cnstr.getName());
            sl.setId(templ.getColumnIndex(cnstr.getName()));
            Object sval = cnstr.getValue();
            sl.setValue(sval);
            current = rule.getRememberMatch() ? new AlphaNodeAnd(this.engine.nextNodeId()) : new NoMemAnd(this.engine.nextNodeId());
            current.setSlot(sl);
            current.incrementUseCount();
            templ.getSlot(sl.getId()).incrementNodeCount();
        }
        return current;
    }

    public BaseAlpha2 compileConstraint(OrLiteralConstraint cnstr, Template templ, Rule rule) {
        BaseAlpha2 current = null;
        if (templ.getSlot(cnstr.getName()) != null) {
            Slot2 sl = new Slot2(cnstr.getName());
            sl.setId(templ.getColumnIndex(cnstr.getName()));
            Object sval = cnstr.getValue();
            sl.setValue(sval);
            current = rule.getRememberMatch() ? new AlphaNodeOr(this.engine.nextNodeId()) : new NoMemOr(this.engine.nextNodeId());
            current.setSlot(sl);
            current.incrementUseCount();
            templ.getSlot(sl.getId()).incrementNodeCount();
        }
        return current;
    }

    public BaseAlpha2 compileConstraint(BoundConstraint cnstr, Template templ, Rule rule, int position) {
        IntraFactNode current = null;
        if (rule.getBinding(cnstr.getVariableName()) == null) {
            Binding bind;
            if (cnstr.getIsObjectBinding()) {
                bind = new Binding();
                bind.setVarName(cnstr.getVariableName());
                bind.setLeftRow(position);
                bind.setLeftIndex(-1);
                bind.setIsObjectVar(true);
                rule.addBinding(cnstr.getVariableName(), bind);
            } else {
                bind = new Binding();
                bind.setVarName(cnstr.getVariableName());
                bind.setLeftRow(position);
                bind.setLeftIndex(templ.getSlot(cnstr.getName()).getId());
                bind.setRowDeclared(position);
                cnstr.setFirstDeclaration(true);
                rule.addBinding(cnstr.getVariableName(), bind);
            }
        }
        if (cnstr.hasIntraFactJoin()) {
            IntraFactNode ifnode = new IntraFactNode(this.engine.nextNodeId());
            BoundConstraint first = cnstr.getFirstIFJ();
            Binding rightbind = rule.getBinding((String)first.getValue());
            Slot left = (Slot)templ.getSlot(cnstr.getName()).clone();
            Slot right = (Slot)templ.getSlot(rightbind.getLeftIndex()).clone();
            ifnode.setSlot(left);
            ifnode.setRightSlot(right);
            ifnode.incrementUseCount();
            if (first.getNegated()) {
                ifnode.setOperator(10);
            } else {
                ifnode.setOperator(9);
            }
            current = ifnode;
        }
        return current;
    }

    public BaseAlpha compileConstraint(PredicateConstraint cnstr, Template templ, Rule rule, int position) {
        BaseAlpha current = null;
        if (!cnstr.isPredicateJoin()) {
            if (ConversionUtils.isPredicateOperatorCode(cnstr.getFunctionName())) {
                Object sval;
                int oprCode = ConversionUtils.getOperatorCode(cnstr.getFunctionName());
                if (cnstr.reverseOperator()) {
                    oprCode = ConversionUtils.getOppositeOperatorCode(oprCode);
                }
                Slot sl = (Slot)templ.getSlot(cnstr.getName()).clone();
                sl.value = sval = ConversionUtils.convert(sl.getValueType(), cnstr.getValue());
                BaseAlpha2 node = rule.getRememberMatch() ? (oprCode == 9 ? new AlphaNode(this.engine.nextNodeId()) : new NumericAlphaNode(this.engine.nextNodeId())) : new NoMemANode(this.engine.nextNodeId());
                current = node;
                node.setSlot(sl);
                node.setOperator(oprCode);
                node.incrementUseCount();
                templ.getSlot(sl.getId()).incrementNodeCount();
            } else {
                Function f = this.engine.findFunction(cnstr.getFunctionName());
                if (f != null) {
                    if (f.getReturnType() == 7 || f.getReturnType() == 20) {
                        Parameter[] parameters = new Parameter[cnstr.getParameters().size()];
                        parameters = cnstr.getParameters().toArray(parameters);
                        this.compileParameters(parameters, cnstr, this.engine, templ, rule);
                        AlphaNodePredConstr node = new AlphaNodePredConstr(this.engine.nextNodeId(), f, parameters);
                        node.slot = (Slot)templ.getSlot(cnstr.getName());
                        node.incrementUseCount();
                        current = node;
                    } else {
                        CompileEvent ce = new CompileEvent(this, 10);
                        ce.setMessage(String.valueOf(INVALID_FUNCTION) + " " + f.getReturnType());
                        this.notifyListener(ce);
                    }
                } else {
                    CompileEvent ce = new CompileEvent(this, 9);
                    ce.setMessage(String.valueOf(FUNCTION_NOT_FOUND) + " " + f.getReturnType());
                    this.notifyListener(ce);
                }
            }
        }
        Binding bind = new Binding();
        bind.setVarName(cnstr.getVariableName());
        bind.setLeftRow(position);
        bind.setLeftIndex(templ.getSlot(cnstr.getName()).getId());
        bind.setRowDeclared(position);
        if (rule.getBinding(cnstr.getVariableName()) == null) {
            rule.addBinding(cnstr.getVariableName(), bind);
        }
        return current;
    }

    public void compileParameters(Parameter[] parameters, PredicateConstraint constraint, Rete engine, Template template, Rule rule) {
        int px = 0;
        while (px < parameters.length) {
            if (parameters[px] instanceof BoundParam) {
                BoundParam bp = (BoundParam)parameters[px];
                bp.setColumn(template.getSlot(constraint.getName()).getId());
                bp.setRow(0);
            } else if (parameters[px] instanceof FunctionParam2) {
                FunctionParam2 fp = (FunctionParam2)parameters[px];
                fp.configure(engine, rule);
            }
            ++px;
        }
    }

    public void compileJoins(Rule rule, Condition[] conds) throws AssertException {
        BaseJoin prevJoinNode = null;
        BaseJoin joinNode = null;
        Condition prevCE = null;
        if (conds.length > 1) {
            prevCE = conds[0];
            prevCE.getCompiler(this).compileFirstJoin(prevCE, rule);
            int idx = 1;
            while (idx < conds.length) {
                Condition cdt = conds[idx];
                joinNode = cdt.getCompiler(this).compileJoin(cdt, idx, rule, prevCE);
                cdt.getCompiler(this).connectJoinNode(prevCE, cdt, prevJoinNode, joinNode);
                prevCE = cdt;
                prevJoinNode = joinNode;
                rule.addJoinNode(joinNode);
                ++idx;
            }
        } else if (conds.length == 1) {
            conds[0].getCompiler(this).compileSingleCE(rule);
        }
    }

    protected void compileActions(Rule rule, Action[] acts) {
        int idx = 0;
        while (idx < acts.length) {
            Action atn = acts[idx];
            atn.configure(this.engine, rule);
            ++idx;
        }
    }

    protected void attachTerminalNode(BaseNode last, TerminalNode terminal) {
        if (last != null && terminal != null) {
            try {
                if (last instanceof BaseJoin) {
                    ((BaseJoin)last).addSuccessorNode(terminal, this.engine, this.memory);
                } else if (last instanceof BaseAlpha) {
                    ((BaseAlpha)last).addSuccessorNode(terminal, this.engine, this.memory);
                }
            }
            catch (AssertException assertException) {
                // empty catch block
            }
        }
    }

    public void attachJoinNode(BaseNode last, BaseJoin join) throws AssertException {
        if (last instanceof BaseAlpha) {
            ((BaseAlpha)last).addSuccessorNode(join, this.engine, this.memory);
        } else if (last instanceof BaseJoin) {
            ((BaseJoin)last).addSuccessorNode(join, this.engine, this.memory);
        }
    }

    public LIANode findLIANode(ObjectTypeNode otn) {
        LIANode node = null;
        if (otn.getSuccessorNodes() != null && otn.getSuccessorNodes().length > 0) {
            Object[] nodes = otn.getSuccessorNodes();
            int idx = 0;
            while (idx < nodes.length) {
                if (nodes[idx] instanceof LIANode) {
                    node = (LIANode)nodes[idx];
                    break;
                }
                ++idx;
            }
        }
        return node;
    }

    public void fireErrorEvent(Object reason) {
    }

    public void notifyListener(CompileEvent event) {
        for (CompilerListener listen : this.listener) {
            int etype = event.getEventType();
            if (etype == 0) {
                listen.ruleAdded(event);
                continue;
            }
            if (etype == 1) {
                listen.ruleRemoved(event);
                continue;
            }
            listen.compileError(event);
        }
    }

    public Map getInputnodes() {
        return this.inputnodes;
    }
}

