/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.CompileEvent;
import org.jamocha.rete.CompilerListener;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.IFLIANode;
import org.jamocha.rete.InitialFact;
import org.jamocha.rete.Messages;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Slot2;
import org.jamocha.rete.Template;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryAlphaNode;
import org.jamocha.rete.query.QueryAndAlphaNode;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseAlphaCondition;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryFuncAlphaNode;
import org.jamocha.rete.query.QueryIntraFactNode;
import org.jamocha.rete.query.QueryLIANode;
import org.jamocha.rete.query.QueryObjTypeNode;
import org.jamocha.rete.query.QueryOrAlphaNode;
import org.jamocha.rete.query.QueryParameterNode;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rete.query.QueryRootNode;
import org.jamocha.rule.AndCondition;
import org.jamocha.rule.AndLiteralConstraint;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Defquery;
import org.jamocha.rule.LiteralConstraint;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.OrLiteralConstraint;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Query;
import org.jamocha.rule.TemplateValidation;

public class DefaultQueryCompiler
implements QueryCompiler {
    private static final long serialVersionUID = 1L;
    private Rete engine = null;
    private Map objectTypeNodesMap = null;
    private ArrayList listener = new ArrayList();
    protected boolean validate = true;
    protected TemplateValidation tval = null;
    public static final String FUNCTION_NOT_FOUND = Messages.getString("CompilerProperties.function.not.found");
    public static final String INVALID_FUNCTION = Messages.getString("CompilerProperties.invalid.function");
    protected Logger log = LogFactory.createLogger(DefaultQueryCompiler.class);
    protected Defquery currentQuery = null;

    public DefaultQueryCompiler(Rete engine, Map inputNodes) {
        this.engine = engine;
        this.objectTypeNodesMap = inputNodes;
        this.tval = new TemplateValidation(engine);
    }

    public void setValidateQuery(boolean valid) {
        this.validate = valid;
    }

    public boolean getValidateQuery() {
        return this.validate;
    }

    public boolean addQuery(Query query) {
        query.resolveTemplates(this.engine);
        this.currentQuery = (Defquery)query;
        QueryRootNode queryRoot = this.engine.getRootNode().createQueryRoot(this.engine);
        this.currentQuery.setQueryNetwork(queryRoot);
        if (query.getConditions() != null && query.getConditions().length > 0) {
            try {
                Condition[] conds = this.getRuleConditions(query);
                int counter = 0;
                int idx = 0;
                while (idx < conds.length) {
                    Condition con = conds[idx];
                    con.getCompiler(this).compile(con, counter, query);
                    if (con instanceof ObjectCondition && !((ObjectCondition)con).getNegated()) {
                        ++counter;
                    }
                    ++idx;
                }
                this.compileJoins(query, conds);
                BaseNode last = query.getLastNode();
                QueryResultNode resultNode = new QueryResultNode(this.engine.nextNodeId());
                last.addSuccessorNode(resultNode, this.engine, null);
                this.currentQuery.setQueryResultNode(resultNode);
                this.engine.declareDefquery(query);
                this.currentQuery = null;
                return true;
            }
            catch (AssertException e) {
                CompileEvent ce = new CompileEvent(query, 3);
                ce.setMessage(Messages.getString("RuleCompiler.assert.error"));
                this.notifyListener(ce);
                this.log.debug(e);
                this.currentQuery = null;
                return false;
            }
        }
        return false;
    }

    public Condition[] getRuleConditions(Query query) {
        Condition[] conditions = query.getConditions();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        boolean hasAnd = false;
        int idx = 0;
        while (idx < conditions.length) {
            if (conditions[idx] instanceof AndCondition) {
                AndCondition and = (AndCondition)conditions[idx];
                conditionList.addAll(and.getNestedConditionalElement());
                hasAnd = true;
            } else {
                conditionList.add(conditions[idx]);
            }
            ++idx;
        }
        if (hasAnd) {
            Condition[] newlist = new Condition[conditionList.size()];
            conditions = conditionList.toArray(newlist);
        }
        return conditions;
    }

    public void addObjectTypeNode(ObjectTypeNode node) {
        if (!this.objectTypeNodesMap.containsKey(node.getDeftemplate())) {
            this.objectTypeNodesMap.put(node.getDeftemplate(), node);
        }
        if (node.getDeftemplate() instanceof InitialFact) {
            try {
                IFLIANode lian = new IFLIANode(this.engine.nextNodeId());
                node.addSuccessorNode(lian, this.engine, this.engine.workingMem);
            }
            catch (AssertException assertException) {
                // empty catch block
            }
        }
    }

    public void removeObjectTypeNode(ObjectTypeNode node) {
        this.objectTypeNodesMap.remove(node.getDeftemplate());
        node.clearSuccessors();
    }

    public ObjectTypeNode getObjectTypeNode(Template template) {
        return (ObjectTypeNode)this.objectTypeNodesMap.get(template);
    }

    public ObjectTypeNode findObjectTypeNode(String templateName) {
        Iterator itr = this.objectTypeNodesMap.keySet().iterator();
        Template tmpl = null;
        while (itr.hasNext()) {
            tmpl = (Template)itr.next();
            if (tmpl.getName().equals(templateName)) break;
        }
        if (tmpl != null) {
            return (ObjectTypeNode)this.objectTypeNodesMap.get(tmpl);
        }
        this.log.debug(Messages.getString("RuleCompiler.deftemplate.error"));
        return null;
    }

    public QueryObjTypeNode findQueryObjTypeNode(Template template) {
        return this.currentQuery.getQueryRootNode().findQueryObjTypeNode(template);
    }

    public void addListener(CompilerListener listener) {
        if (!this.listener.contains(listener)) {
            this.listener.add(listener);
        }
    }

    public void removeListener(CompilerListener listener) {
        this.listener.remove(listener);
    }

    public Rete getEngine() {
        return this.engine;
    }

    public QueryBaseAlpha compileConstraint(LiteralConstraint cnstr, Template templ, Query query) {
        QueryAlphaNode current = null;
        if (templ.getSlot(cnstr.getName()) != null) {
            Object sval;
            Slot sl = (Slot)templ.getSlot(cnstr.getName()).clone();
            sl.value = sval = ConversionUtils.convert(sl.getValueType(), cnstr.getValue());
            current = new QueryAlphaNode(this.engine.nextNodeId());
            ((QueryBaseAlphaCondition)current).setSlot(sl);
            ((QueryBaseAlphaCondition)current).setOperator(9);
            current.incrementUseCount();
            templ.getSlot(sl.getId()).incrementNodeCount();
        }
        return current;
    }

    public QueryBaseAlpha compileConstraint(AndLiteralConstraint cnstr, Template templ, Query query) {
        QueryAndAlphaNode current = null;
        if (templ.getSlot(cnstr.getName()) != null) {
            Slot2 sl = new Slot2(cnstr.getName());
            sl.setId(templ.getColumnIndex(cnstr.getName()));
            Object sval = cnstr.getValue();
            sl.setValue(sval);
            current = new QueryAndAlphaNode(this.engine.nextNodeId());
            ((QueryBaseAlphaCondition)current).setSlot(sl);
            ((BaseNode)current).incrementUseCount();
            templ.getSlot(sl.getId()).incrementNodeCount();
        }
        return current;
    }

    public QueryBaseAlpha compileConstraint(OrLiteralConstraint cnstr, Template templ, Query query) {
        QueryOrAlphaNode current = null;
        if (templ.getSlot(cnstr.getName()) != null) {
            Slot2 sl = new Slot2(cnstr.getName());
            sl.setId(templ.getColumnIndex(cnstr.getName()));
            Object sval = cnstr.getValue();
            sl.setValue(sval);
            current = new QueryOrAlphaNode(this.engine.nextNodeId());
            ((QueryBaseAlphaCondition)current).setSlot(sl);
            ((BaseNode)current).incrementUseCount();
            templ.getSlot(sl.getId()).incrementNodeCount();
        }
        return current;
    }

    public QueryBaseAlpha compileConstraint(BoundConstraint cnstr, Template templ, Query query, int position) {
        QueryBaseAlphaCondition current = new QueryParameterNode(this.engine.nextNodeId());
        if (query.getBinding(cnstr.getVariableName()) == null) {
            Binding bind;
            if (cnstr.getIsObjectBinding()) {
                bind = new Binding();
                bind.setVarName(cnstr.getVariableName());
                bind.setLeftRow(position);
                bind.setLeftIndex(-1);
                bind.setIsObjectVar(true);
                query.addBinding(cnstr.getVariableName(), bind);
            } else {
                bind = new Binding();
                bind.setVarName(cnstr.getVariableName());
                bind.setLeftRow(position);
                bind.setLeftIndex(templ.getSlot(cnstr.getName()).getId());
                bind.setRowDeclared(position);
                cnstr.setFirstDeclaration(true);
                query.addBinding(cnstr.getVariableName(), bind);
            }
        }
        if (cnstr.hasIntraFactJoin()) {
            QueryIntraFactNode ifnode = new QueryIntraFactNode(this.engine.nextNodeId());
            BoundConstraint first = cnstr.getFirstIFJ();
            Binding rightbind = query.getBinding((String)first.getValue());
            Slot left = (Slot)templ.getSlot(cnstr.getName()).clone();
            Slot right = (Slot)templ.getSlot(rightbind.getLeftIndex()).clone();
            ifnode.setSlot(left);
            ifnode.setRightSlot(right);
            ifnode.incrementUseCount();
            if (first.getNegated()) {
                ifnode.setOperator(10);
            } else {
                ifnode.setOperator(9);
            }
            current = ifnode;
        } else {
            QueryParameterNode qpn = current;
            qpn.setParameterName(cnstr.getVariableName());
            Slot slot = (Slot)templ.getSlot(cnstr.getName());
            qpn.setSlot(slot);
            ((Defquery)query).addQueryParameterNode(qpn);
        }
        return current;
    }

    public QueryBaseAlpha compileConstraint(PredicateConstraint cnstr, Template templ, Query query, int position) {
        QueryBaseAlphaCondition current = null;
        if (ConversionUtils.isPredicateOperatorCode(cnstr.getFunctionName())) {
            QueryParameterNode node;
            int oprCode = ConversionUtils.getOperatorCode(cnstr.getFunctionName());
            if (cnstr.reverseOperator()) {
                oprCode = ConversionUtils.getOppositeOperatorCode(oprCode);
            }
            Slot sl = (Slot)templ.getSlot(cnstr.getName()).clone();
            current = node = new QueryParameterNode(this.engine.nextNodeId());
            node.setSlot(sl);
            node.setOperator(oprCode);
            String variable = null;
            List params = cnstr.getParameters();
            int i = 0;
            while (i < params.size()) {
                BoundParam p = (BoundParam)params.get(i);
                String var = p.getVariableName();
                if (((Defquery)query).isQueryParameter(var)) {
                    variable = var;
                    break;
                }
                ++i;
            }
            node.setParameterName(variable);
            ((Defquery)query).addQueryParameterNode(node);
        } else {
            Function f = this.engine.findFunction(cnstr.getFunctionName());
            if (f != null) {
                if (f.getReturnType() == 7 || f.getReturnType() == 20) {
                    Parameter[] parameters = new Parameter[cnstr.getParameters().size()];
                    parameters = cnstr.getParameters().toArray(parameters);
                    this.compileParameters(parameters, cnstr, this.engine, templ, query);
                    Slot pslot = (Slot)templ.getSlot(cnstr.getName());
                    QueryFuncAlphaNode node = new QueryFuncAlphaNode(this.engine.nextNodeId(), f, parameters, pslot);
                    node.incrementUseCount();
                    node.setParameterName(cnstr.getVariableName());
                    ((Defquery)query).addQueryFuncNode(node);
                    current = node;
                } else {
                    CompileEvent ce = new CompileEvent(this, 10);
                    ce.setMessage(String.valueOf(INVALID_FUNCTION) + " " + f.getReturnType());
                    this.notifyListener(ce);
                }
            } else {
                CompileEvent ce = new CompileEvent(this, 9);
                ce.setMessage(String.valueOf(FUNCTION_NOT_FOUND) + " " + f.getReturnType());
                this.notifyListener(ce);
            }
        }
        Binding bind = new Binding();
        bind.setVarName(cnstr.getVariableName());
        bind.setLeftRow(position);
        bind.setLeftIndex(templ.getSlot(cnstr.getName()).getId());
        bind.setRowDeclared(position);
        if (query.getBinding(cnstr.getVariableName()) == null) {
            query.addBinding(cnstr.getVariableName(), bind);
        }
        return current;
    }

    public void compileParameters(Parameter[] parameters, PredicateConstraint constraint, Rete engine, Template template, Query query) {
        int px = 0;
        while (px < parameters.length) {
            if (parameters[px] instanceof BoundParam) {
                BoundParam bp = (BoundParam)parameters[px];
                bp.setColumn(template.getSlot(constraint.getName()).getId());
                bp.setRow(0);
            } else if (parameters[px] instanceof FunctionParam2) {
                FunctionParam2 fp = (FunctionParam2)parameters[px];
                fp.configure(engine, query);
            }
            ++px;
        }
    }

    public void compileJoins(Query query, Condition[] conds) throws AssertException {
        QueryBaseJoin prevJoinNode = null;
        QueryBaseJoin joinNode = null;
        Condition prevCE = null;
        if (conds.length > 1) {
            prevCE = conds[0];
            prevCE.getCompiler(this).compileFirstJoin(prevCE, query);
            int idx = 1;
            while (idx < conds.length) {
                Condition cdt = conds[idx];
                joinNode = cdt.getCompiler(this).compileJoin(cdt, idx, query, prevCE);
                cdt.getCompiler(this).connectJoinNode(prevCE, cdt, prevJoinNode, joinNode);
                prevCE = cdt;
                prevJoinNode = joinNode;
                query.addJoinNode(joinNode);
                ++idx;
            }
        } else if (conds.length == 1) {
            conds[0].getCompiler(this).compileSingleCE(query);
        }
    }

    public void attachJoinNode(BaseNode last, BaseJoin join) throws AssertException {
        if (last instanceof BaseAlpha) {
            ((BaseAlpha)last).addSuccessorNode(join, this.engine, null);
        } else if (last instanceof BaseJoin) {
            ((BaseJoin)last).addSuccessorNode(join, this.engine, null);
        }
    }

    public void attachJoinNode(BaseNode last, QueryBaseJoin join) throws AssertException {
        if (last instanceof BaseAlpha) {
            ((BaseAlpha)last).addSuccessorNode(join, this.engine, null);
        } else if (last instanceof BaseJoin) {
            ((BaseJoin)last).addSuccessorNode(join, this.engine, null);
        }
    }

    public QueryLIANode findQueryLIANode(QueryObjTypeNode otn) {
        QueryLIANode node = null;
        if (otn.getSuccessorNodes() != null && otn.getSuccessorNodes().length > 0) {
            Object[] nodes = otn.getSuccessorNodes();
            int idx = 0;
            while (idx < nodes.length) {
                if (nodes[idx] instanceof QueryLIANode) {
                    node = (QueryLIANode)nodes[idx];
                    break;
                }
                ++idx;
            }
        }
        return node;
    }

    public void fireErrorEvent(Object reason) {
    }

    public void notifyListener(CompileEvent event) {
        for (CompilerListener listen : this.listener) {
            int etype = event.getEventType();
            if (etype == 0) {
                listen.ruleAdded(event);
                continue;
            }
            if (etype == 1) {
                listen.ruleRemoved(event);
                continue;
            }
            listen.compileError(event);
        }
    }

    public Map getObjectTypeNodeMap() {
        return this.objectTypeNodesMap;
    }
}

