/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeFact;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.DimensionSlot;
import org.jamocha.rete.Fact;
import org.jamocha.rete.MeasureSlot;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Template;

public class CubeTemplate
implements Template {
    private static final long serialVersionUID = 1L;
    private Cube cube = null;
    private String templateName;
    private String defclass = null;
    protected BaseSlot[] slots;
    private boolean watch = false;
    private int temporalDistance = 0;

    public CubeTemplate(String name, String defclass, BaseSlot[] slots) {
        this.templateName = name;
        this.defclass = defclass;
        this.slots = slots;
    }

    public Fact createFact(Object data, Defclass clazz, long id) {
        BaseSlot[] values = this.cloneAllSlots();
        CubeFact newfact = new CubeFact(this, data, values, id);
        return newfact;
    }

    public Fact createTemporalFact(Object data, Defclass clazz, long id) {
        return null;
    }

    public Cube getCube() {
        return this.cube;
    }

    public BaseSlot[] getAllSlots() {
        return this.slots;
    }

    public String getClassName() {
        return this.defclass;
    }

    public int getColumnIndex(String name) {
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getName().equals(name)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public String getName() {
        return this.templateName;
    }

    public int getNumberOfSlots() {
        return this.slots.length;
    }

    public Template getParent() {
        return null;
    }

    public BaseSlot getSlot(String name) {
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getName().equals(name)) {
                return this.slots[idx];
            }
            ++idx;
        }
        return null;
    }

    public BaseSlot getSlot(int column) {
        return this.slots[column];
    }

    public int getTemporalDistance() {
        return this.temporalDistance;
    }

    public boolean getWatch() {
        return this.watch;
    }

    public boolean inUse() {
        int idx = 0;
        while (idx < this.slots.length) {
            if (this.slots[idx].getNodeCount() > 0) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public void setParent(Template parent) {
    }

    public void setTemporalDistance(int distance) {
        this.temporalDistance = distance;
    }

    public void setNonTemporalRules(boolean value) {
    }

    public boolean getNonTemporalRules() {
        return false;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.templateName + Constants.LINEBREAK);
        int idx = 0;
        while (idx < this.slots.length) {
            buf.append("  (" + this.slots[idx].getName() + " (type ");
            if (this.slots[idx] instanceof DimensionSlot) {
                buf.append(String.valueOf(((DimensionSlot)this.slots[idx]).toPPString()) + "))" + Constants.LINEBREAK);
            } else if (this.slots[idx] instanceof MeasureSlot) {
                buf.append(String.valueOf(((MeasureSlot)this.slots[idx]).toPPString()) + "))" + Constants.LINEBREAK);
            } else if (this.slots[idx] instanceof Slot) {
                buf.append("Object[]))" + Constants.LINEBREAK);
            }
            ++idx;
        }
        if (this.defclass != null) {
            buf.append("[" + this.defclass + "] ");
        }
        buf.append(")");
        if (this.temporalDistance > 0) {
            buf.append(" temporal distance: " + this.temporalDistance + " ms");
        }
        return buf.toString();
    }

    public BaseSlot[] cloneAllSlots() {
        BaseSlot[] cloned = new BaseSlot[this.slots.length];
        int idx = 0;
        while (idx < cloned.length) {
            cloned[idx] = (BaseSlot)this.slots[idx].clone();
            ++idx;
        }
        return cloned;
    }

    public void incrementColumnUseCount(String name) {
        this.getSlot(name).incrementNodeCount();
    }

    public int getSlotsUsed() {
        return this.slots.length;
    }
}

