/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.CubeDimension;
import org.jamocha.rete.CubeFact;
import org.jamocha.rete.CubeHashMemoryImpl;
import org.jamocha.rete.Defmeasure;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.ResultsetFact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.measures.AggregateMeasure;
import org.jamocha.rete.measures.Measure;
import org.jamocha.rete.util.NodeUtils;
import org.jamocha.rete.util.ProfileStats;

public class CubeQueryBNode
extends BaseJoin {
    private static final long serialVersionUID = 1L;
    private CubeFact cubeFact = null;
    private Binding[] numericBindings = null;
    private CubeBinding[] measureBindings = null;
    private CubeBinding[] dimensionBindings = null;

    public CubeQueryBNode(int id) {
        super(id);
    }

    public void setNumericBindings(Binding[] bindings) {
        this.numericBindings = bindings;
    }

    public Binding[] getNumericBindings() {
        return this.numericBindings;
    }

    public void setMeasureBindings(CubeBinding[] measureBindings) {
        this.measureBindings = measureBindings;
    }

    public CubeBinding[] getMeasureBindings() {
        return this.measureBindings;
    }

    public void setDimensionBindings(CubeBinding[] dimensionBindings) {
        this.dimensionBindings = dimensionBindings;
    }

    public CubeBinding[] getDimensionBindings() {
        return this.dimensionBindings;
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        EqHashIndex eqIndex;
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        Map values = (Map)leftmem.get(eqIndex = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts())));
        if (values == null) {
            values = engine.newMap();
            leftmem.put(eqIndex, values);
        }
        values.put(linx, linx);
        if (this.cubeFact != null) {
            CubeHashMemoryImpl rightmem = (CubeHashMemoryImpl)mem.getBetaRightMemory(this);
            if (rightmem.count(eqIndex) > 0) {
                Iterator itr = rightmem.iterator(eqIndex);
                while (itr.hasNext()) {
                    Fact f = (Fact)itr.next();
                    this.propogateAssert(linx.add(f), engine, mem);
                }
            } else {
                ResultsetFact rsFact;
                Cube c = (Cube)this.cubeFact.getObjectInstance();
                Object[] result = this.queryCube(linx, c, engine, mem, rsFact = this.cubeFact.createResultsetFact(engine));
                if (result != null && result.length > 0) {
                    rsFact.setResultsetData(result);
                    this.executeMeasures(c, engine, mem, rsFact);
                    rightmem.addPartialMatch(eqIndex, rsFact, engine);
                    this.propogateAssert(linx.add(rsFact), engine, mem);
                }
            }
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        this.cubeFact = (CubeFact)rfact;
        CubeHashMemoryImpl rightmem = (CubeHashMemoryImpl)mem.getBetaRightMemory(this);
        Cube cube = (Cube)this.cubeFact.getObjectInstance();
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (EqHashIndex eqIndex : leftmem.keySet()) {
            ResultsetFact rsFact;
            Map values = (Map)leftmem.get(eqIndex);
            if (values.size() <= 0) continue;
            ArrayList matchValues = new ArrayList(values.values());
            Index linx = (Index)matchValues.get(0);
            Object[] result = this.queryCube(linx, cube, engine, mem, rsFact = this.cubeFact.createResultsetFact(engine));
            if (result == null || result.length <= 0) break;
            rsFact.setResultsetData(result);
            this.executeMeasures(cube, engine, mem, rsFact);
            rightmem.addPartialMatch(eqIndex, rsFact, engine);
            int idx = 0;
            while (idx < matchValues.size()) {
                linx = (Index)matchValues.get(idx);
                this.propogateAssert(linx.add(rsFact), engine, mem);
                ++idx;
            }
            break block0;
        }
    }

    public void retractLeft(Index linx, Rete engine, WorkingMemory mem) throws RetractException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        EqHashIndex eqIndex = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        Map entries = (Map)leftmem.get(eqIndex);
        entries.remove(linx);
        CubeHashMemoryImpl rightmem = (CubeHashMemoryImpl)mem.getBetaRightMemory(this);
        Iterator itr = rightmem.iterator(eqIndex);
        if (itr != null) {
            while (itr.hasNext()) {
                this.propogateRetract(linx.add((Fact)itr.next()), engine, mem);
            }
        }
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) throws RetractException {
        CubeHashMemoryImpl rightmem = (CubeHashMemoryImpl)mem.getBetaRightMemory(this);
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        Object[] cachedResults = rightmem.iterateAll();
        int idx = 0;
        while (idx < cachedResults.length) {
            Fact right = (Fact)cachedResults[idx];
            EqHashIndex eqIndex = new EqHashIndex(NodeUtils.getRightValues(this.binds, right));
            Map partialMatches = (Map)leftmem.get(eqIndex);
            for (Index match : partialMatches.values()) {
                this.propogateRetract(match.add(right), engine, mem);
            }
            ++idx;
        }
    }

    protected Object[] queryCube(Index linx, Cube c, Rete engine, WorkingMemory mem, ResultsetFact resultFact) {
        Map data;
        Object parameter;
        CubeDimension dimension;
        Binding b;
        HashSet result = new HashSet();
        Map firstResult = null;
        if (c.profileQuery()) {
            ProfileStats.startCubeQuery();
        }
        if (this.binds.length > 0) {
            Binding b2 = this.binds[0];
            CubeDimension dimension2 = c.getDimensions()[b2.getRightIndex()];
            String parameter2 = linx.getFacts()[b2.leftrow].getSlotValue(b2.leftIndex).toString();
            resultFact.setSlotValue(b2.rightIndex, parameter2);
            firstResult = dimension2.getData((Object)parameter2, b2.negated());
            if (firstResult != null && firstResult.size() > 0) {
                result.addAll(firstResult.keySet());
            }
        }
        if (this.binds.length > 1 && result.size() > 0) {
            int idx = 1;
            while (idx < this.binds.length) {
                b = this.binds[idx];
                dimension = c.getDimensions()[b.getRightIndex()];
                parameter = linx.getFacts()[b.leftrow].getSlotValue(b.leftIndex).toString();
                resultFact.setSlotValue(b.rightIndex, parameter);
                data = null;
                data = dimension.getData(parameter, b.negated());
                if (data != null) {
                    result.retainAll(data.keySet());
                }
                ++idx;
            }
        }
        if (this.numericBindings != null && this.numericBindings.length > 0) {
            int idx = 0;
            while (idx < this.numericBindings.length) {
                b = (Binding2)this.numericBindings[idx];
                dimension = c.getDimensions()[b.getRightIndex()];
                parameter = null;
                parameter = ((Binding2)b).getQueryValue() != null ? ((Binding2)b).getQueryValue() : linx.getFacts()[b.getLeftRow()].getSlotValue(b.getLeftIndex());
                resultFact.setSlotValue(((Binding2)b).rightIndex, parameter);
                data = null;
                data = dimension.getData(parameter, ((Binding2)b).getOperator());
                if (data != null) {
                    result.retainAll(data.keySet());
                }
                ++idx;
            }
        }
        if (c.profileQuery()) {
            ProfileStats.endCubeQuery();
        }
        Object[] resultArray = new Object[result.size()];
        return result.toArray(resultArray);
    }

    protected void executeMeasures(Cube c, Rete engine, WorkingMemory mem, ResultsetFact resultFact) {
        if (this.measureBindings != null && this.measureBindings.length > 0) {
            int idx = 0;
            while (idx < this.measureBindings.length) {
                CubeBinding cbinding = this.measureBindings[idx];
                int measureIndex = cbinding.getRightIndex();
                Defmeasure defmeasure = (Defmeasure)this.cubeFact.getSlotValue(measureIndex);
                Measure msr = defmeasure.getMeasure();
                BigDecimal calculatedValue = null;
                if (msr instanceof AggregateMeasure) {
                    AggregateMeasure aggrMsr = (AggregateMeasure)msr;
                    calculatedValue = aggrMsr.calculate(engine, c, resultFact.getResultsetData(), cbinding);
                    resultFact.setSlotValue(cbinding.rightIndex, calculatedValue);
                }
                ++idx;
            }
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CubeQueryBNode-" + this.nodeID + "> ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }
}

