/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.HashIndex;
import org.jamocha.rete.Rete;

public class CubeHashMemoryImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map memory = null;
    protected int counter = 0;

    public CubeHashMemoryImpl(String name, Rete engine) {
        this.memory = engine.newAlphaMemoryMap(name);
    }

    public int addPartialMatch(HashIndex index, Object data, Rete engine) {
        Map matches = (Map)this.memory.get(index);
        int count = 0;
        if (matches == null) {
            count = this.addNewPartialMatch(index, data, engine);
        } else {
            matches.put(data, data);
            count = matches.size();
        }
        ++this.counter;
        return count;
    }

    public int addNewPartialMatch(HashIndex index, Object data, Rete engine) {
        Map matches = engine.newMap();
        matches.put(data, data);
        this.memory.put(index, matches);
        return 1;
    }

    public void clear() {
        Iterator itr = this.memory.values().iterator();
        while (itr.hasNext()) {
            ((Map)itr.next()).clear();
        }
        this.memory.clear();
    }

    public boolean isPartialMatch(HashIndex index, Object data) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            return list.containsKey(data);
        }
        return false;
    }

    public int removePartialMatch(HashIndex index, Object data) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            list.remove(data);
            if (list.size() == 0) {
                this.memory.remove(index);
            }
            --this.counter;
            return list.size();
        }
        return 0;
    }

    public int size() {
        Iterator itr = this.memory.keySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map matches = (Map)this.memory.get(itr.next());
            count += matches.size();
        }
        return count;
    }

    public int bucketCount() {
        return this.counter;
    }

    public Iterator iterator(HashIndex index) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            return list.values().iterator();
        }
        return null;
    }

    public int count(HashIndex index) {
        Map list = (Map)this.memory.get(index);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public Object[] iterateAll() {
        Object[] all = new Object[this.counter];
        Iterator itr = this.memory.keySet().iterator();
        int idx = 0;
        while (itr.hasNext()) {
            Map f = (Map)this.memory.get(itr.next());
            Iterator itr2 = f.values().iterator();
            while (itr2.hasNext()) {
                all[idx] = itr2.next();
                ++idx;
            }
        }
        return all;
    }
}

