/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.HashMap;
import java.util.Map;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.DimensionSlot;
import org.jamocha.rete.EqualityIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.MeasureSlot;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.ResultsetFact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Template;

public class CubeFact
implements Fact {
    private static final long serialVersionUID = 1L;
    protected Template template = null;
    protected Object objInstance;
    protected BaseSlot[] slots = null;
    protected long id;
    private long timeStamp = 0L;
    protected boolean hasBinding = false;
    private EqualityIndex Eindex = null;
    private Map slotMap = null;

    public CubeFact(Template template, Object instance, BaseSlot[] values, long id) {
        this.template = template;
        this.objInstance = instance;
        this.slots = values;
        this.id = id;
        this.timeStamp = System.currentTimeMillis();
        this.slotMap = new HashMap(values.length);
        this.mapSlots();
    }

    protected void mapSlots() {
        int idx = 0;
        while (idx < this.slots.length) {
            this.slotMap.put(this.slots[idx].getName(), this.slots[idx]);
            ++idx;
        }
    }

    public void clear() {
        this.template = null;
        this.objInstance = null;
        this.slots = null;
        this.id = 0L;
        this.timeStamp = 0L;
        this.slotMap.clear();
    }

    public EqualityIndex equalityIndex() {
        if (this.Eindex == null) {
            this.Eindex = new EqualityIndex(this);
        }
        return this.Eindex;
    }

    public int slotHash() {
        int hash = 0;
        int idx = 0;
        while (idx < this.slots.length) {
            hash = this.slots[idx] instanceof MultiSlot ? (hash += this.slots[idx].getName().hashCode() + ((MultiSlot)this.slots[idx]).valueHash()) : (hash += this.slots[idx].getName().hashCode() + this.slots[idx].value.hashCode());
            ++idx;
        }
        return hash;
    }

    public Template getDeftemplate() {
        return this.template;
    }

    public long getFactId() {
        return this.id;
    }

    public Object getObjectInstance() {
        return this.objInstance;
    }

    public int getSlotId(String name) {
        BaseSlot s = (BaseSlot)this.slotMap.get(name);
        return s.getId();
    }

    public Object getSlotValue(int id) {
        BaseSlot s = this.slots[id];
        if (s instanceof DimensionSlot) {
            return ((DimensionSlot)s).getDimension();
        }
        return ((MeasureSlot)s).getDefmeasure();
    }

    public void resetID(Fact fact) {
        this.id = fact.getFactId();
    }

    public void setFactId(Rete engine) {
        if (this.id == -1L) {
            this.id = engine.nextFactId();
        }
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    public String toFactString() {
        StringBuffer buf = new StringBuffer();
        buf.append("f-" + this.id + " (" + this.template.getName());
        if (this.slots.length > 0) {
            buf.append(" ");
        }
        int idx = 0;
        while (idx < this.slots.length) {
            buf.append("(" + this.slots[idx].getName() + " ");
            if (this.slots[idx] instanceof DimensionSlot) {
                buf.append("Dimension");
            } else if (this.slots[idx] instanceof MeasureSlot) {
                buf.append("Measure");
            }
            buf.append(") ");
            ++idx;
        }
        buf.append(")");
        return buf.toString();
    }

    public void updateSlots(Rete engine, BaseSlot[] slots) {
    }

    public boolean slotEquals(Fact fact) {
        if (fact instanceof CubeFact) {
            return ((CubeFact)fact).getObjectInstance() == this.objInstance;
        }
        return false;
    }

    public ResultsetFact createResultsetFact(Rete engine) {
        BaseSlot[] newSlots = new BaseSlot[this.slots.length];
        int idx = 0;
        while (idx < this.slots.length) {
            Slot s = new Slot();
            newSlots[idx] = s;
            s.setName(this.slots[idx].getName());
            s.setId(this.slots[idx].getId());
            ++idx;
        }
        ResultsetFact fact = new ResultsetFact(this.template, this.objInstance, newSlots, engine.nextFactId());
        return fact;
    }
}

