/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Fact;

public class ConversionUtils {
    private static HashMap OPR_MAP = new HashMap();
    private static HashMap STROPR_MAP;

    static {
        OPR_MAP.put(String.valueOf(1), "add");
        OPR_MAP.put(String.valueOf(2), "subtract");
        OPR_MAP.put(String.valueOf(3), "multiply");
        OPR_MAP.put(String.valueOf(4), "divide");
        OPR_MAP.put(String.valueOf(6), "less than");
        OPR_MAP.put(String.valueOf(8), "less than or equal to");
        OPR_MAP.put(String.valueOf(5), "greater than");
        OPR_MAP.put(String.valueOf(7), "greater than or equal to");
        OPR_MAP.put(String.valueOf(9), "equal to");
        OPR_MAP.put(String.valueOf(10), "not equal to");
        STROPR_MAP = null;
        STROPR_MAP = new HashMap();
        OPR_MAP.put("add", "+");
        OPR_MAP.put("subtract", "-");
        OPR_MAP.put("multiply", "*");
        OPR_MAP.put("divide", "/");
        OPR_MAP.put("less than", "<");
        OPR_MAP.put("less than or equal to", "<=");
        OPR_MAP.put("greater than", ">");
        OPR_MAP.put("greater than or equal to", ">=");
        OPR_MAP.put("equal to", "=");
        OPR_MAP.put("not equal to", "!=");
    }

    public static Object convert(int val) {
        return new Integer(val);
    }

    public static Object convert(short val) {
        return new Short(val);
    }

    public static Object convert(float val) {
        return new Float(val);
    }

    public static Object convert(long val) {
        return new Long(val);
    }

    public static Object convert(double val) {
        return new Double(val);
    }

    public static Object convert(byte val) {
        return new Byte(val);
    }

    public static Object convert(int type, Object val) {
        if (type == 1 || type == 14) {
            if (val instanceof BigDecimal) {
                return new Integer(((BigDecimal)val).intValue());
            }
        } else if (type == 2 || type == 15) {
            if (val instanceof BigDecimal) {
                return new Short(((BigDecimal)val).shortValue());
            }
        } else if (type == 4 || type == 17) {
            if (val instanceof BigDecimal) {
                return new Float(((BigDecimal)val).floatValue());
            }
        } else if (type == 3 || type == 16) {
            if (val instanceof BigDecimal) {
                return new Long(((BigDecimal)val).longValue());
            }
        } else if ((type == 5 || type == 18) && val instanceof BigDecimal) {
            return new Double(((BigDecimal)val).doubleValue());
        }
        return val;
    }

    public static String getPPOperator(int opr) {
        return (String)OPR_MAP.get(String.valueOf(opr));
    }

    public static Fact findFact(Deftemplate temp, Fact[] facts) {
        Fact ft = null;
        int idx = 0;
        while (idx < facts.length) {
            if (facts[idx].getDeftemplate() == temp) {
                ft = facts[idx];
            }
            ++idx;
        }
        return ft;
    }

    public static Fact[] mergeFacts(Fact[] left, Fact[] right) {
        Fact[] merged = new Fact[left.length + right.length];
        System.arraycopy(left, 0, merged, 0, left.length);
        System.arraycopy(right, 0, merged, left.length, right.length);
        return merged;
    }

    public static Fact[] mergeFacts(Fact[] left, Fact right) {
        Fact[] merged = new Fact[left.length + 1];
        System.arraycopy(left, 0, merged, 0, left.length);
        merged[left.length] = right;
        return merged;
    }

    public static BaseNode[] add(BaseNode[] list, BaseNode nobj) {
        BaseNode[] newlist = new BaseNode[list.length + 1];
        System.arraycopy(list, 0, newlist, 0, list.length);
        newlist[list.length] = nobj;
        return newlist;
    }

    public static BaseNode[] remove(BaseNode[] list, Object nobj) {
        BaseNode[] newlist = new BaseNode[list.length - 1];
        int pos = 0;
        int idx = 0;
        while (idx < list.length) {
            if (list[idx] != nobj) {
                newlist[pos] = list[idx];
                ++pos;
            }
            ++idx;
        }
        return newlist;
    }

    public static int getTypeCode(Class clzz) {
        if (clzz.isArray()) {
            return 10;
        }
        if (clzz.isPrimitive()) {
            if (clzz == Integer.TYPE) {
                return 1;
            }
            if (clzz == Short.TYPE) {
                return 2;
            }
            if (clzz == Long.TYPE) {
                return 3;
            }
            if (clzz == Float.TYPE) {
                return 4;
            }
            if (clzz == Byte.TYPE) {
                return 6;
            }
            if (clzz == Double.TYPE) {
                return 5;
            }
            if (clzz == Boolean.TYPE) {
                return 7;
            }
            if (clzz == Character.TYPE) {
                return 8;
            }
            return 9;
        }
        if (clzz == Date.class) {
            return 25;
        }
        if (clzz == String.class) {
            return 11;
        }
        return 9;
    }

    public static String getTypeName(int intType) {
        if (intType == 1) {
            return "INTEGER";
        }
        if (intType == 2) {
            return "SHORT";
        }
        if (intType == 3) {
            return "LONG";
        }
        if (intType == 4) {
            return "FLOAT";
        }
        if (intType == 5) {
            return "DOUBLE";
        }
        if (intType == 6) {
            return "BYTE";
        }
        if (intType == 7) {
            return "BOOLEAN";
        }
        if (intType == 8) {
            return "CHAR";
        }
        if (intType == 11) {
            return "STRING";
        }
        if (intType == 25) {
            return "DATE";
        }
        if (intType == 10) {
            return Object[].class.getName();
        }
        return Object.class.getName();
    }

    public static int getOperatorCode(String strSymbol) {
        if (strSymbol.equals("=")) {
            return 9;
        }
        if (strSymbol.equals("!=")) {
            return 10;
        }
        if (strSymbol.equals("+")) {
            return 1;
        }
        if (strSymbol.equals("-")) {
            return 2;
        }
        if (strSymbol.equals("*")) {
            return 3;
        }
        if (strSymbol.equals("/")) {
            return 4;
        }
        if (strSymbol.equals(">")) {
            return 5;
        }
        if (strSymbol.equals(">=")) {
            return 7;
        }
        if (strSymbol.equals("<")) {
            return 6;
        }
        if (strSymbol.equals("<=")) {
            return 8;
        }
        return 13;
    }

    public static int getOppositeOperatorCode(int op) {
        int rvop = 9;
        switch (op) {
            case 9: {
                rvop = 10;
                break;
            }
            case 10: {
                rvop = 9;
                break;
            }
            case 5: {
                rvop = 6;
                break;
            }
            case 6: {
                rvop = 5;
                break;
            }
            case 7: {
                rvop = 8;
                break;
            }
            case 8: {
                rvop = 7;
            }
        }
        return rvop;
    }

    public static String getOppositeOperator(String strSymbol) {
        if (strSymbol.equals("=")) {
            return "!=";
        }
        if (strSymbol.equals("!=")) {
            return "=";
        }
        if (strSymbol.equals("+")) {
            return "-";
        }
        if (strSymbol.equals("-")) {
            return "+";
        }
        if (strSymbol.equals("*")) {
            return "/";
        }
        if (strSymbol.equals("/")) {
            return "*";
        }
        if (strSymbol.equals(">")) {
            return "<";
        }
        if (strSymbol.equals(">=")) {
            return "<=";
        }
        if (strSymbol.equals("<")) {
            return ">";
        }
        if (strSymbol.equals("<=")) {
            return ">=";
        }
        return strSymbol;
    }

    public static boolean isPredicateOperatorCode(String strSymbol) {
        if (strSymbol.equals("=")) {
            return true;
        }
        if (strSymbol.equals("!=")) {
            return true;
        }
        if (strSymbol.equals(">")) {
            return true;
        }
        if (strSymbol.equals(">=")) {
            return true;
        }
        if (strSymbol.equals("<")) {
            return true;
        }
        return strSymbol.equals("<=");
    }

    public static String formatSlot(Object s) {
        if (s != null) {
            if (s instanceof Boolean) {
                return s.toString().toUpperCase();
            }
            if (s instanceof String) {
                return "\"" + s.toString() + "\"";
            }
            if (s.getClass() != null && s.getClass().isArray()) {
                StringBuffer buf = new StringBuffer();
                Object[] ary = (Object[])s;
                int idx = 0;
                while (idx < ary.length) {
                    if (idx > 0) {
                        buf.append(" ");
                    }
                    buf.append(ConversionUtils.formatSlot(ary[idx]));
                    ++idx;
                }
                return buf.toString();
            }
            return s.toString();
        }
        return "nil";
    }

    public static void main(String[] args) {
    }
}

