/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;

public class BoundParam
extends AbstractParam {
    private static final long serialVersionUID = 1L;
    protected Fact fact = null;
    protected Object resolvedVal = null;
    protected int column = -1;
    protected int valueType = -1;
    protected int rowId = -1;
    protected int actionType = 1000;
    protected String variableName = null;
    protected boolean isMultislot = false;

    public BoundParam() {
    }

    public BoundParam(int col, int vType) {
        this.column = col;
        this.valueType = vType;
        this.objBinding = true;
    }

    public BoundParam(int col, int vType, boolean objBinding) {
        this.column = col;
        this.valueType = vType;
        this.objBinding = objBinding;
    }

    public BoundParam(int row, int col, int vType, boolean obj) {
        this.rowId = row;
        this.column = col;
        this.valueType = vType;
        this.objBinding = obj;
    }

    public BoundParam(Fact fact) {
        this.fact = fact;
        this.objBinding = true;
        this.valueType = 13;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String value) {
        this.variableName = value.substring(0, 1).equals("?") ? value.substring(1) : value;
    }

    public int getValueType() {
        return this.valueType;
    }

    public Object getValue() {
        if (this.fact != null) {
            return this.fact.getSlotValue(this.column);
        }
        return this.resolvedVal;
    }

    public Object getValue(Rete engine, int valueType) {
        if (this.fact != null) {
            return this.fact.getSlotValue(this.column);
        }
        return engine.getBinding(this.variableName);
    }

    public void setResolvedValue(Object val) {
        this.resolvedVal = val;
    }

    public Fact getFact() {
        return this.fact;
    }

    public void setFact(Fact[] facts) {
        if (this.rowId > -1 && facts[this.rowId] != null) {
            this.fact = facts[this.rowId];
        }
    }

    public Object getObjectRef() {
        return this.fact.getObjectInstance();
    }

    public boolean isObjectBinding() {
        return this.objBinding;
    }

    public void setObjectBinding(boolean obj) {
        this.objBinding = obj;
    }

    public boolean isMultislot() {
        return this.isMultislot;
    }

    public void setIsMultislot(boolean multi) {
        this.isMultislot = multi;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int action) {
        this.actionType = action;
    }

    public void setRow(int row) {
        this.rowId = row;
    }

    public void setColumn(int col) {
        this.column = col;
        if (this.column == -1) {
            this.objBinding = true;
        }
    }

    public void reset() {
        this.fact = null;
    }

    public String toPPString() {
        if (this.isMultislot) {
            return "$?" + this.variableName;
        }
        return "?" + this.variableName;
    }

    public BoundParam clone() {
        BoundParam clone = new BoundParam(this.rowId, this.column, this.valueType, this.objBinding);
        clone.actionType = this.actionType;
        clone.fact = this.fact;
        clone.isMultislot = this.isMultislot;
        clone.resolvedVal = this.resolvedVal;
        clone.variableName = this.variableName;
        return clone;
    }
}

