/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class Binding2
extends Binding {
    private static final long serialVersionUID = 1L;
    protected int operator = 9;
    protected Function function = null;
    protected Parameter[] params = null;
    protected String rightVariable = null;
    protected Object queryValue = null;

    public Binding2(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public boolean isPredicate() {
        return this.isPredJoin;
    }

    public void setPredicate(boolean isPredicate) {
        this.isPredJoin = isPredicate;
    }

    public Parameter[] getParams() {
        return this.params;
    }

    public void setParams(Parameter[] params) {
        this.params = params;
    }

    public String getRightVariable() {
        return this.rightVariable;
    }

    public void setRightVariable(String rightVariable) {
        this.rightVariable = rightVariable;
    }

    public Object getQueryValue() {
        return this.queryValue;
    }

    public void setQueryValue(Object value) {
        this.queryValue = value;
    }

    public boolean evaluate(Fact[] left, Fact right, Rete engine) {
        if (this.function != null) {
            Fact[] facts = new Fact[left.length + 1];
            System.arraycopy(left, 0, facts, 0, left.length);
            facts[left.length] = right;
            Parameter[] funcParams = this.getParameters(facts, engine);
            ReturnVector rv = this.function.executeFunction(engine, funcParams);
            return rv.firstReturnValue().getBooleanValue();
        }
        if (left.length > this.leftrow) {
            if (left[this.leftrow] == right) {
                return false;
            }
            return Evaluate.evaluate(this.operator, left[this.leftrow].getSlotValue(this.leftIndex), right.getSlotValue(this.rightIndex));
        }
        return false;
    }

    protected Parameter[] getParameters(Fact[] facts, Rete engine) {
        if (this.params != null) {
            Parameter[] newparams = new Parameter[this.params.length];
            int i = 0;
            while (i < this.params.length) {
                ValueParam vp;
                if (this.params[i] instanceof BoundParam) {
                    vp = new ValueParam();
                    BoundParam bp = (BoundParam)this.params[i];
                    newparams[i] = vp;
                    vp.objBinding = bp.objBinding;
                    vp.valueType = bp.valueType;
                    vp.value = facts[bp.rowId].getSlotValue(bp.column);
                } else if (this.params[i] instanceof FunctionParam2) {
                    FunctionParam2 fp = new FunctionParam2();
                    newparams[i] = fp;
                    fp.setEngine(engine);
                    fp.facts = facts;
                    fp.func = ((FunctionParam2)this.params[i]).func;
                    fp.funcName = ((FunctionParam2)this.params[i]).funcName;
                    fp.objBinding = ((FunctionParam2)this.params[i]).objBinding;
                } else if (this.params[i] instanceof ValueParam) {
                    vp = (ValueParam)this.params[i];
                    newparams[i] = vp.cloneParameter();
                }
                ++i;
            }
            return newparams;
        }
        return this.params;
    }

    public String toBindString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.leftrow + ")(");
        buf.append(this.leftIndex);
        if (this.function != null) {
            buf.append(") " + this.function.getName() + " (0)(");
        } else {
            buf.append(") " + ConversionUtils.getPPOperator(this.operator) + " (0)(");
        }
        buf.append(this.rightIndex);
        buf.append(") ?" + this.rightVariable);
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        if (!this.isPredJoin) {
            buf.append("?" + this.varName + " (" + this.leftrow + ")(");
            buf.append(this.leftIndex);
            if (this.function != null) {
                buf.append(") " + this.function.toPPString(this.params, 1) + " ");
            } else {
                buf.append(") " + ConversionUtils.getPPOperator(this.operator) + " (0)(");
            }
            buf.append(this.rightIndex);
            if (this.rightVariable != null) {
                buf.append(") ?" + this.rightVariable);
            } else {
                buf.append(")");
            }
        } else {
            buf.append(this.function.toPPString(this.params, 1));
        }
        return buf.toString();
    }
}

